/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.xwt.jface;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableSetTreeContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.xwt.XWT;
import org.eclipse.papyrus.xwt.internal.core.Core;
import org.eclipse.papyrus.xwt.internal.core.UpdateSourceTrigger;

public class ObservableTreeContentProvider
implements ITreeContentProvider {
    private String contentPath;
    private Object context;
    private Object value;
    private ITreeContentProvider delegate;

    public String getContentPath() {
        return this.contentPath;
    }

    public void setContentPath(String contentPath) {
        this.contentPath = contentPath;
    }

    public void dispose() {
        if (this.delegate == null) {
            return;
        }
        this.delegate.dispose();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput == null) {
            return;
        }
        this.updateContext(viewer, newInput);
        this.delegate.inputChanged(viewer, oldInput, newInput);
    }

    public Object[] getChildren(Object parentElement) {
        if (this.delegate == null) {
            return Core.EMPTY_ARRAY;
        }
        return this.delegate.getChildren(parentElement);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public boolean hasChildren(Object element) {
        if (this.delegate == null) {
            return false;
        }
        return this.delegate.hasChildren(element);
    }

    public Object getParent(Object element) {
        if (this.delegate == null) {
            return null;
        }
        return this.delegate.getParent(element);
    }

    public IObservableSet getKnownElements() {
        if (this.delegate == null) {
            return null;
        }
        if (this.delegate instanceof ObservableSetTreeContentProvider) {
            ObservableSetTreeContentProvider contentProvider = (ObservableSetTreeContentProvider)this.delegate;
            return contentProvider.getKnownElements();
        }
        if (this.delegate instanceof ObservableListTreeContentProvider) {
            ObservableListTreeContentProvider contentProvider = (ObservableListTreeContentProvider)this.delegate;
            return contentProvider.getKnownElements();
        }
        throw new IllegalStateException();
    }

    public void updateContext(Object context, Object value) {
        if (context == this.context && this.value == value) {
            return;
        }
        this.context = context;
        this.value = value;
        IObservableFactory observableFactory = XWT.observableFactory(context, this.getContentPath(), UpdateSourceTrigger.Default);
        IObservable observable = observableFactory.createObservable(value);
        if (observable instanceof IObservableList) {
            this.delegate = new ObservableListTreeContentProvider(observableFactory, null);
        } else if (observable instanceof IObservableSet) {
            this.delegate = new ObservableSetTreeContentProvider(observableFactory, null);
        } else {
            throw new UnsupportedOperationException(observable.getClass().getName());
        }
    }
}

