/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.xwt.internal.xml;

import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.papyrus.xwt.internal.xml.Element;
import org.eclipse.papyrus.xwt.internal.xml.IElementCache;

public class DefaultElementCache
implements IElementCache {
    static int DEFAULT_CACHE_SIZE = 128;
    private final int cacheSize;
    private final Map<String, Element> cache = new LinkedHashMap<String, Element>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Element> eldest) {
            return this.size() > DefaultElementCache.this.cacheSize;
        }
    };

    public DefaultElementCache() {
        this(DEFAULT_CACHE_SIZE);
    }

    public DefaultElementCache(int cacheSize) {
        if (cacheSize <= 0) {
            throw new IllegalArgumentException("non-positive cacheSize");
        }
        this.cacheSize = cacheSize;
    }

    public Element getElement(URL url) {
        return this.cache.get(url.toExternalForm());
    }

    public void cache(URL url, Element element) {
        this.cache.put(url.toExternalForm(), element);
    }
}

