/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.xwt.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.papyrus.xwt.IDataProvider;
import org.eclipse.papyrus.xwt.XWT;
import org.eclipse.papyrus.xwt.XWTException;
import org.eclipse.papyrus.xwt.databinding.EventPropertyObservableValue;
import org.eclipse.papyrus.xwt.databinding.JFaceXWTDataBinding;
import org.eclipse.papyrus.xwt.databinding.ListToArrayObservableValue;
import org.eclipse.papyrus.xwt.databinding.TypedViewerObservableValueDecorator;
import org.eclipse.papyrus.xwt.dataproviders.IObjectDataProvider;
import org.eclipse.papyrus.xwt.internal.core.BindingExpressionPath;
import org.eclipse.papyrus.xwt.internal.core.ScopeKeeper;
import org.eclipse.papyrus.xwt.internal.core.UpdateSourceTrigger;
import org.eclipse.papyrus.xwt.internal.utils.UserData;
import org.eclipse.papyrus.xwt.javabean.metadata.properties.EventProperty;
import org.eclipse.papyrus.xwt.metadata.IMetaclass;
import org.eclipse.papyrus.xwt.metadata.IProperty;
import org.eclipse.papyrus.xwt.metadata.ModelUtils;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeManager {
    public static final int AUTO = 0;
    public static final int VALUE = 1;
    public static final int SET = 2;
    public static final int LIST = 3;
    public static final int COLLECTION = 4;

    public static IObservableValue observableValue(Object control, Object value, String fullPath, UpdateSourceTrigger updateSourceTrigger) {
        try {
            return ScopeManager.observeValue(control, value, fullPath, updateSourceTrigger);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static IObservableList observableList(Object control, Object value, String fullPath, UpdateSourceTrigger updateSourceTrigger) {
        try {
            return (IObservableList)ScopeManager.observe(control, value, fullPath, updateSourceTrigger, 3);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static IObservableSet observableSet(Object control, Object value, String fullPath, UpdateSourceTrigger updateSourceTrigger) {
        try {
            return (IObservableSet)ScopeManager.observe(control, value, fullPath, updateSourceTrigger, 2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static IObservableValue findObservableValue(Object context, Object control, Object data, String propertyName) {
        ScopeKeeper scope = UserData.findScopeKeeper(context);
        if (control == null) {
            control = context;
        }
        return scope.getObservableValue(UserData.getWidget(control), data, propertyName);
    }

    public static IObservableSet findObservableSet(Object context, Object control, Object data, String propertyName) {
        ScopeKeeper scope = UserData.findScopeKeeper(context);
        if (control == null) {
            control = context;
        }
        return scope.getObservableSet(UserData.getWidget(control), data, propertyName);
    }

    public static IObservableList findObservableList(Object context, Object control, Object data, String propertyName) {
        ScopeKeeper scope = UserData.findScopeKeeper(context);
        if (control == null) {
            control = context;
        }
        return scope.getObservableList(UserData.getWidget(control), data, propertyName);
    }

    public static IObservableValue observeValue(Object control, Object value, String fullPath, UpdateSourceTrigger updateSourceTrigger) {
        return ScopeManager.observeValue(control, value, new BindingExpressionPath(fullPath), updateSourceTrigger);
    }

    public static IObservableValue observeValue(Object control, Object value, BindingExpressionPath expressionPath, UpdateSourceTrigger updateSourceTrigger) {
        if (value == null) {
            value = control;
        }
        ObservableValueBuilder builder = new ObservableValueBuilder(control, null, expressionPath, updateSourceTrigger, 1);
        return (IObservableValue)builder.observe(value);
    }

    public static IObservable observe(Object control, Object value, BindingExpressionPath expressionPath, UpdateSourceTrigger updateSourceTrigger) {
        return ScopeManager.observe(control, value, expressionPath, updateSourceTrigger, 0);
    }

    public static IObservableFactory observableFactory(Object control, BindingExpressionPath expressionPath, UpdateSourceTrigger updateSourceTrigger) {
        return new ObservableFactory(control, expressionPath, updateSourceTrigger);
    }

    public static IObservable observe(Object control, Object value, String fullPath, UpdateSourceTrigger updateSourceTrigger, int observeKind) {
        return ScopeManager.observe(control, value, new BindingExpressionPath(fullPath), updateSourceTrigger, observeKind);
    }

    public static IObservable observe(Object control, Object value, BindingExpressionPath expressionPath, UpdateSourceTrigger updateSourceTrigger, int observeKind) {
        if (value == null) {
            value = control;
        }
        ObservableValueBuilder builder = new ObservableValueBuilder(control, null, expressionPath, updateSourceTrigger, observeKind);
        return builder.observe(value);
    }

    public static IObservableValue observeValue(Object control, Object value, Class<?> type, BindingExpressionPath expressionPath, UpdateSourceTrigger updateSourceTrigger) {
        ObservableValueBuilder builder = new ObservableValueBuilder(control, type, expressionPath, updateSourceTrigger, 1);
        return (IObservableValue)builder.observe(value);
    }

    public static IValueProperty createValueProperty(Object control, Object type, BindingExpressionPath expressionPath) {
        IValueProperty valueProperty = null;
        String[] segments = expressionPath.getSegments();
        if (segments == null || segments.length == 0) {
            String segment = expressionPath.getFullPath();
            valueProperty = ScopeManager.doCreateValueProperty(type, segment);
        } else {
            String[] stringArray = segments;
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                IValueProperty segmentValueProperty = ScopeManager.doCreateValueProperty(type, segment);
                valueProperty = valueProperty == null ? segmentValueProperty : valueProperty.value(segmentValueProperty);
                type = valueProperty.getValueType();
                ++n2;
            }
        }
        return valueProperty;
    }

    protected static IValueProperty doCreateValueProperty(Object type, String fullPath) {
        IDataProvider dataProvider = XWT.findDataProvider(type);
        return dataProvider.createValueProperty(type, fullPath);
    }

    public static boolean isPropertyReadOnly(IDataProvider dataProvider, BindingExpressionPath expressionPath) {
        String path;
        int index;
        String[] segments = expressionPath.getSegments();
        if (segments == null || segments.length == 0) {
            String segment = expressionPath.getFullPath();
            return dataProvider.isPropertyReadOnly(segment);
        }
        Object type = null;
        int last = segments.length - 1;
        int i = 0;
        while (i < last) {
            String path2;
            int index2;
            String segment = segments[i];
            int length = segment.length();
            if (length > 1 && segment.charAt(0) == '(' && segment.charAt(length - 1) == ')' && (index2 = (path2 = segment.substring(1, segment.length() - 1)).lastIndexOf(46)) != -1) {
                String className = path2.substring(0, index2);
                segment = path2.substring(index2 + 1);
                type = dataProvider.getModelService().loadModelType(className);
                if (type == null) {
                    throw new XWTException("Class " + className + " not found");
                }
                dataProvider = XWT.findDataProvider(type);
            }
            if ((type = dataProvider.getDataType(segment)) != null) {
                dataProvider = XWT.findDataProvider(type);
                if (dataProvider == null) {
                    throw new XWTException("Data probider is not found for the type " + type.toString());
                }
            } else {
                throw new XWTException("Type is not found for the property " + segment);
            }
            ++i;
        }
        String segment = segments[last];
        int length = segment.length();
        if (length > 1 && segment.charAt(0) == '(' && segment.charAt(length - 1) == ')' && (index = (path = segment.substring(1, segment.length() - 1)).lastIndexOf(46)) != -1) {
            String className = path.substring(0, index);
            segment = path.substring(index + 1);
            type = dataProvider.getModelService().loadModelType(className);
            if (type == null) {
                throw new XWTException("Class " + className + " not found");
            }
            dataProvider = XWT.findDataProvider(type);
        }
        return dataProvider.isPropertyReadOnly(segment);
    }

    static class ObservableFactory
    extends ObservableValueBuilder
    implements IObservableFactory {
        public ObservableFactory(Object control, BindingExpressionPath expressionPath, UpdateSourceTrigger updateSourceTrigger) {
            super(control, null, expressionPath, updateSourceTrigger, 0);
        }

        public IObservable createObservable(Object target) {
            return this.observe(target);
        }
    }

    static class ObservableValueBuilder {
        private Widget widget;
        private Object control;
        private Object value;
        private Object elementType;
        private BindingExpressionPath expressionPath;
        private UpdateSourceTrigger updateSourceTrigger;
        private IDataProvider dataProvider;
        private String currentPath;
        private int observeKind = 1;

        public ObservableValueBuilder(Object control, Object elementType, BindingExpressionPath expressionPath, UpdateSourceTrigger updateSourceTrigger, int observeKind) {
            this.control = control;
            this.expressionPath = expressionPath;
            this.elementType = elementType;
            this.updateSourceTrigger = updateSourceTrigger;
            this.observeKind = observeKind;
        }

        public IObservable observe(Object targetValue) {
            this.value = targetValue;
            this.widget = UserData.getWidget(this.control);
            ScopeKeeper scopeManager = UserData.findScopeKeeper(this.widget);
            if (scopeManager == null) {
                return null;
            }
            if (this.expressionPath.getFullPath() == null && targetValue instanceof IObservable) {
                return (IObservable)targetValue;
            }
            IObservable observable = scopeManager.getObservable(this.widget, this.value, this.expressionPath.getStripedPath());
            if (observable != null) {
                while (observable instanceof IObservableValue && ((IObservableValue)observable).getValue() instanceof IObservable) {
                    observable = (IObservable)((IObservableValue)observable).getValue();
                }
                return observable;
            }
            this.dataProvider = XWT.findDataProvider(this.value);
            Object dataValue = this.value;
            this.currentPath = null;
            Object type = this.elementType;
            String[] segments = this.expressionPath.getSegments();
            if (segments == null || segments.length == 0) {
                String segment = ModelUtils.normalizePropertyName(this.expressionPath.getFullPath());
                observable = this.resolveObservablevalue(scopeManager, dataValue, type, segment);
            } else {
                if (this.observeKind == 4 && !JFaceXWTDataBinding.isViewerProperty(segments[0])) {
                    Class propertyTypeClass;
                    Object propertyType;
                    int kindValue = 1;
                    Object targetValueType = dataValue;
                    if (dataValue instanceof IObservableValue) {
                        targetValueType = ((IObservableValue)dataValue).getValueType();
                    }
                    if ((propertyType = this.dataProvider.getModelService().toModelPropertyType(targetValueType, segments[0])) instanceof Class && (Collection.class.isAssignableFrom(propertyTypeClass = (Class)propertyType) || propertyTypeClass.isArray())) {
                        kindValue = 4;
                    }
                    this.observeKind = kindValue;
                }
                int size = segments.length;
                int lastObserveKind = this.observeKind;
                this.observeKind = 1;
                int i = 0;
                while (i < size) {
                    String segment = segments[i];
                    if (i == size - 1) {
                        this.observeKind = lastObserveKind;
                    }
                    observable = this.resolveObservablevalue(scopeManager, dataValue, type, segment);
                    while (observable instanceof IObservableValue && ((IObservableValue)observable).getValue() instanceof IObservable) {
                        observable = (IObservable)((IObservableValue)observable).getValue();
                    }
                    dataValue = observable;
                    if (i != size - 1 && (type = this.dataProvider.getModelService().toModelType(dataValue)) != null) {
                        this.dataProvider = XWT.findDataProvider(type);
                    }
                    ++i;
                }
            }
            return observable;
        }

        private IObservable resolveObservablevalue(ScopeKeeper scopeManager, Object dataValue, Object type, String segment) {
            String path;
            int index;
            int length;
            if (!BindingExpressionPath.isEmptyPath(segment) && (length = segment.length()) > 1 && segment.charAt(0) == '(' && segment.charAt(length - 1) == ')' && (index = (path = segment.substring(1, segment.length() - 1)).lastIndexOf(46)) != -1) {
                String className = path.substring(0, index);
                segment = path.substring(index + 1);
                type = this.dataProvider.getModelService().loadModelType(className);
                if (type == null && (type = this.dataProvider.getModelService().loadModelType(path)) != null) {
                    segment = null;
                }
                if (type == null) {
                    throw new XWTException("Class " + className + " not found");
                }
                this.dataProvider = XWT.findDataProvider(type);
            }
            if (this.currentPath == null) {
                this.currentPath = segment;
            } else if (segment != null) {
                this.currentPath = String.valueOf(this.currentPath) + '.' + segment;
            }
            IObservableValue segmentValue = scopeManager.getObservableValue(this.widget, this.value, this.currentPath);
            try {
                if (segmentValue == null) {
                    if (segment != null) {
                        segmentValue = this.createValueProperty(dataValue, segment, type);
                        if (segmentValue == null) {
                            throw new XWTException(" Property " + segment + " is not found in " + this.expressionPath.getFullPath());
                        }
                        scopeManager.addObservableValue(this.widget, this.value, this.currentPath, (IObservable)segmentValue);
                    } else if (dataValue instanceof IObservable) {
                        segmentValue = (IObservable)dataValue;
                    }
                } else if (segment == null && type != null && segmentValue instanceof TypedViewerObservableValueDecorator) {
                    TypedViewerObservableValueDecorator typedViewerObservableValueDecorator = (TypedViewerObservableValueDecorator)segmentValue;
                    typedViewerObservableValueDecorator.setElementType(type);
                }
            }
            catch (IllegalArgumentException e) {
                String message = e.getMessage();
                if (!message.startsWith("Could not find property with name")) {
                    throw e;
                }
                throw new XWTException(" Property " + segment + " is not found in " + this.expressionPath.getFullPath());
            }
            return segmentValue;
        }

        protected IObservable createValueProperty(Object object, String propertyName, Object targetType) {
            IObservableValue activeValue;
            Object valueType;
            IMetaclass mateclass;
            IProperty property;
            Object observable = null;
            Object type = null;
            type = targetType == null ? this.dataProvider.getModelService().toModelType(object) : targetType;
            if (UserData.getWidget(object) != null) {
                observable = JFaceXWTDataBinding.observeWidget(object, propertyName, this.updateSourceTrigger, this.observeKind);
            }
            if (observable == null && this.dataProvider instanceof IObjectDataProvider && (property = (mateclass = XWT.getMetaclass(type)).findProperty(propertyName)) instanceof EventProperty) {
                observable = new EventPropertyObservableValue(object, (EventProperty)property);
            }
            if (observable != null) {
                return observable;
            }
            observable = this.dataProvider.observe(object, propertyName, type, this.observeKind);
            if (observable instanceof IObservableValue && (valueType = (activeValue = (IObservableValue)observable).getValueType()) instanceof Class) {
                Class classType = (Class)valueType;
                if (valueType != null && classType.isArray()) {
                    Object values = this.dataProvider.getData(propertyName);
                    ArrayList<Object> array = new ArrayList<Object>();
                    if (values != null) {
                        Object[] objectArray = (Object[])values;
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object value = objectArray[n2];
                            array.add(value);
                            ++n2;
                        }
                    }
                    WritableList writableList = new WritableList(XWT.getRealm(), array, classType.getComponentType());
                    return new ListToArrayObservableValue((IObservableList)writableList, activeValue);
                }
            }
            return observable;
        }
    }
}

