/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.xwt.databinding;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.xwt.IDataProvider;
import org.eclipse.papyrus.xwt.IValueConverter;
import org.eclipse.papyrus.xwt.XWTException;
import org.eclipse.papyrus.xwt.databinding.AbstractDataBinding;
import org.eclipse.papyrus.xwt.databinding.IBindingContext;
import org.eclipse.papyrus.xwt.internal.core.Binding;
import org.eclipse.papyrus.xwt.internal.core.BindingExpressionPath;
import org.eclipse.papyrus.xwt.internal.core.BindingGate;
import org.eclipse.papyrus.xwt.internal.core.ScopeManager;
import org.eclipse.papyrus.xwt.metadata.ModelUtils;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataBinding
extends AbstractDataBinding {
    private IObservable observableWidget;
    private BindingGate bindingGate;

    public DataBinding(Binding binding, IDataProvider dataProvider) {
        super(binding, dataProvider);
        assert (dataProvider != null) : "DataProvider is null";
    }

    @Override
    public Object getValue(Class<?> targetType) {
        IObservable observableWidget = this.getObservableWidget();
        IObservable observableSource = this.getObservableSource(1);
        if (observableWidget == null) {
            if (observableSource == null) {
                return null;
            }
            if (targetType != null && !targetType.isInstance(observableSource)) {
                return observableSource;
            }
            Object value = observableSource;
            if (observableSource instanceof IObservableValue) {
                value = ((IObservableValue)observableSource).getValue();
            }
            return this.convertedValue(value);
        }
        BindingGate bindingContext = this.getBindingGate();
        if (bindingContext != null && observableSource != null) {
            Object target = this.getControl();
            if (target instanceof Text && this.getTargetProperty().equalsIgnoreCase("text")) {
                if (this.isSourcePropertyReadOnly()) {
                    Text text = (Text)target;
                    text.setEditable(false);
                }
            } else if (target instanceof Button && this.getTargetProperty().equalsIgnoreCase("selection")) {
                if (this.isSourcePropertyReadOnly()) {
                    Button button = (Button)target;
                    button.setEnabled(false);
                }
            } else if ((target instanceof Combo || target instanceof CCombo) && this.getTargetProperty().equalsIgnoreCase("text")) {
                if (this.isSourcePropertyReadOnly()) {
                    Control control = (Control)target;
                    control.setEnabled(false);
                }
            } else if (target instanceof MenuItem && this.getTargetProperty().equalsIgnoreCase("selection") && this.isSourcePropertyReadOnly()) {
                MenuItem menuItem = (MenuItem)target;
                menuItem.setEnabled(false);
            }
            bindingContext.bind(observableSource, observableWidget, this);
        }
        if (targetType != null && !targetType.isInstance(observableSource)) {
            return observableSource;
        }
        Object value = observableSource;
        while (value instanceof IObservableValue) {
            value = ((IObservableValue)value).getValue();
        }
        return this.convertedValue(value);
    }

    private BindingGate getBindingGate() {
        if (this.bindingGate == null) {
            IBindingContext dataBindingContext = this.getDataBindingContext();
            this.bindingGate = new BindingGate(dataBindingContext);
        }
        return this.bindingGate;
    }

    private Object convertedValue(Object value) {
        IValueConverter converter = this.getConverter();
        if (converter != null) {
            value = converter.convert(value);
        }
        return value;
    }

    public boolean isSourcePropertyReadOnly() {
        IDataProvider dataProvider = this.getDataProvider();
        try {
            return ScopeManager.isPropertyReadOnly(dataProvider, this.getSourcePropertyExpression());
        }
        catch (XWTException xWTException) {
            return false;
        }
    }

    public IObservable getObservableSource(int observeKind) {
        IObservable observableSource = this.getObservableSource();
        if (observableSource == null) {
            IDataProvider dataProvider = this.getDataProvider();
            observableSource = ScopeManager.observe(this.getControl(), dataProvider.getData(null), this.getSourcePropertyExpression(), this.getUpdateSourceTrigger(), observeKind);
            if (observableSource != null) {
                this.setObservableSource(observableSource);
            }
        }
        return observableSource;
    }

    public IObservable getObservableWidget() {
        if (this.observableWidget == null) {
            BindingExpressionPath path;
            int observeKind;
            Object host;
            Object target;
            block7: {
                target = this.getControl();
                host = this.getHost();
                String targetProperty = this.getTargetProperty();
                targetProperty = ModelUtils.normalizePropertyName(targetProperty);
                observeKind = 0;
                if (host instanceof Viewer && "input".equals(targetProperty)) {
                    this.getObservableSource(4);
                    IObservable observableSource = this.getObservableSource();
                    if (observableSource instanceof IObservableList) {
                        return null;
                    }
                    if (observableSource instanceof IObservableSet) {
                        return null;
                    }
                }
                path = this.getTargetPropertyExpression();
                if (!path.isEmptyPath()) break block7;
                return null;
            }
            try {
                this.observableWidget = ScopeManager.observe(target, host, path, this.getUpdateSourceTrigger(), observeKind);
            }
            catch (XWTException xWTException) {
                // empty catch block
            }
        }
        return this.observableWidget;
    }
}

