/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.string;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.library.AbstractSimpleBinaryOperation;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;

public class StringLastIndexOfOperation
extends AbstractSimpleBinaryOperation {
    @NonNull
    public static final StringLastIndexOfOperation INSTANCE = new StringLastIndexOfOperation();

    @NonNull
    public IntegerValue evaluate(@Nullable Object left, @Nullable Object right) {
        String leftString = StringLastIndexOfOperation.asString((Object)left);
        String rightString = StringLastIndexOfOperation.asString((Object)right);
        if (rightString.length() <= 0) {
            return ValuesUtil.integerValueOf((int)(leftString.length() + 1));
        }
        int index = leftString.lastIndexOf(rightString);
        if (index >= 0) {
            return ValuesUtil.integerValueOf((int)(index + 1));
        }
        return ValuesUtil.integerValueOf((int)0);
    }
}

