/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.iterator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.DomainIterationManager;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.AbstractIteration;
import org.eclipse.ocl.examples.domain.library.LibraryBinaryOperation;
import org.eclipse.ocl.examples.domain.library.LibraryFeature;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.impl.ValueImpl;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;

public class SortedByIteration
extends AbstractIteration {
    @NonNull
    public static final SortedByIteration INSTANCE = new SortedByIteration();

    @NonNull
    public SortingValue createAccumulatorValue(@NonNull DomainEvaluator evaluator, @NonNull TypeId accumulatorTypeId, @NonNull TypeId bodyTypeId) {
        DomainStandardLibrary standardLibrary = evaluator.getStandardLibrary();
        DomainInheritance comparableType = standardLibrary.getOclComparableType().getInheritance(standardLibrary);
        DomainInheritance selfType = standardLibrary.getOclSelfType().getInheritance(standardLibrary);
        DomainOperation staticOperation = comparableType.lookupLocalOperation(standardLibrary, "compareTo", new DomainInheritance[]{selfType});
        if (staticOperation != null) {
            DomainType bodyType = evaluator.getIdResolver().getType(bodyTypeId, null);
            LibraryFeature implementation = bodyType.lookupImplementation(standardLibrary, staticOperation);
            return new SortingValue(evaluator, (CollectionTypeId)accumulatorTypeId, (LibraryBinaryOperation)implementation);
        }
        throw new InvalidValueException(EvaluatorMessages.UndefinedOperation, new Object[]{String.valueOf(String.valueOf(comparableType)) + "::" + "compareTo"});
    }

    @NonNull
    protected Object resolveTerminalValue(@NonNull DomainIterationManager iterationManager) {
        SortingValue accumulatorValue = (SortingValue)iterationManager.getAccumulatorValue();
        assert (accumulatorValue != null);
        return accumulatorValue.createSortedValue();
    }

    @Nullable
    protected Object updateAccumulator(@NonNull DomainIterationManager iterationManager) {
        Object bodyVal = iterationManager.evaluateBody();
        if (bodyVal == null) {
            throw new InvalidValueException(EvaluatorMessages.UndefinedBody, new Object[]{"sortedBy"});
        }
        Object iterValue = iterationManager.get();
        SortingValue accumulatorValue = (SortingValue)iterationManager.getAccumulatorValue();
        assert (accumulatorValue != null);
        accumulatorValue.put(iterValue, bodyVal);
        return CARRY_ON;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SortingValue
    extends ValueImpl
    implements Comparator<Object> {
        @NonNull
        protected final CollectionTypeId typeId;
        @NonNull
        private final DomainEvaluator evaluator;
        private final boolean isUnique;
        @NonNull
        private final LibraryBinaryOperation implementation;
        @NonNull
        private final Map<Object, Object> content = new HashMap<Object, Object>();
        private Map<Object, Integer> repeatCounts = null;

        public SortingValue(@NonNull DomainEvaluator evaluator, @NonNull CollectionTypeId returnTypeId, @NonNull LibraryBinaryOperation implementation) {
            this.typeId = returnTypeId;
            this.evaluator = evaluator;
            this.implementation = implementation;
            CollectionTypeId generalizedId = this.typeId.getGeneralizedId();
            this.isUnique = generalizedId == TypeId.SET || generalizedId == TypeId.ORDERED_SET;
        }

        @NonNull
        public Object asObject() {
            return this.content;
        }

        @Override
        public int compare(Object o1, Object o2) {
            Object v2;
            if (o1 == o2) {
                return 0;
            }
            Object v1 = this.content.get(o1);
            if (v1 == (v2 = this.content.get(o2))) {
                return 0;
            }
            if (v1 == null) {
                return -1;
            }
            if (v2 == null) {
                return 1;
            }
            try {
                IntegerValue comparison = ValuesUtil.asIntegerValue((Object)this.implementation.evaluate(this.evaluator, (TypeId)TypeId.INTEGER, v1, v2));
                return comparison.signum();
            }
            catch (InvalidValueException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InvalidValueException(e);
            }
        }

        @NonNull
        public Value createSortedValue() {
            ArrayList<Object> result = new ArrayList<Object>(this.content.keySet());
            Collections.sort(result, this);
            if (this.isUnique || this.repeatCounts == null) {
                return this.evaluator.getIdResolver().createCollectionOfAll(true, this.isUnique, (TypeId)this.typeId, result);
            }
            ArrayList nonUniqueResult = new ArrayList();
            for (Object e : result) {
                nonUniqueResult.add(e);
                Integer repeatCount = this.repeatCounts.get(e);
                if (repeatCount == null) continue;
                int i = repeatCount;
                while (i > 0) {
                    nonUniqueResult.add(e);
                    --i;
                }
            }
            return this.evaluator.getIdResolver().createCollectionOfAll(true, false, (TypeId)this.typeId, nonUniqueResult);
        }

        @NonNull
        public TypeId getTypeId() {
            return this.typeId;
        }

        public void put(@Nullable Object iterVal, @Nullable Object comparable) {
            if (this.content.put(iterVal, comparable) != null && !this.isUnique) {
                Integer repeatCount;
                if (this.repeatCounts == null) {
                    this.repeatCounts = new HashMap<Object, Integer>();
                }
                repeatCount = (repeatCount = this.repeatCounts.get(iterVal)) == null ? Integer.valueOf(1) : Integer.valueOf(repeatCount + 1);
                this.repeatCounts.put(iterVal, repeatCount);
            }
        }

        public String toString() {
            return this.content.toString();
        }
    }
}

