/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.iterator;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.DomainIterationManager;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.AbstractIteration;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;

public class OneIteration
extends AbstractIteration {
    @NonNull
    public static final OneIteration INSTANCE = new OneIteration();

    @NonNull
    public MutableBoolean createAccumulatorValue(@NonNull DomainEvaluator evaluator, @NonNull TypeId accumulatorTypeId, @NonNull TypeId bodyTypeId) {
        return new MutableBoolean();
    }

    @NonNull
    protected Object resolveTerminalValue(@NonNull DomainIterationManager iterationManager) {
        MutableBoolean accumulatorValue = (MutableBoolean)iterationManager.getAccumulatorValue();
        assert (accumulatorValue != null);
        return accumulatorValue.isSet();
    }

    @Nullable
    protected Object updateAccumulator(@NonNull DomainIterationManager iterationManager) {
        Object bodyVal = iterationManager.evaluateBody();
        if (bodyVal == null) {
            throw new InvalidValueException(EvaluatorMessages.UndefinedBody, new Object[]{"one"});
        }
        if (bodyVal == Boolean.FALSE) {
            return CARRY_ON;
        }
        if (bodyVal != Boolean.TRUE) {
            throw new InvalidValueException(EvaluatorMessages.NonBooleanBody, new Object[]{"one"});
        }
        MutableBoolean accumulatorValue = (MutableBoolean)iterationManager.getAccumulatorValue();
        assert (accumulatorValue != null);
        if (accumulatorValue.isSet()) {
            return Boolean.FALSE;
        }
        accumulatorValue.set();
        return CARRY_ON;
    }

    public static class MutableBoolean {
        private boolean value = false;

        public boolean isSet() {
            return this.value;
        }

        public void set() {
            this.value = true;
        }
    }
}

