/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.executor;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainMetaclass;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.types.AbstractMetaclass;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.library.ecore.EcoreExecutorPackage;
import org.eclipse.ocl.examples.library.executor.DomainReflectivePackage;
import org.eclipse.ocl.examples.library.executor.ExecutableStandardLibrary;
import org.eclipse.ocl.examples.library.oclstdlib.OCLstdlibTables;

public class ExecutorStandardLibrary
extends ExecutableStandardLibrary {
    @NonNull
    private Map<String, WeakReference<EcoreExecutorPackage>> ePackageMap = new WeakHashMap<String, WeakReference<EcoreExecutorPackage>>();
    private Map<DomainPackage, WeakReference<DomainReflectivePackage>> domainPackageMap = null;
    private Map<EcoreExecutorPackage, List<EcoreExecutorPackage>> extensions = null;
    private DomainType enumerationType = null;
    private DomainType metaclassType = null;

    public ExecutorStandardLibrary(EcoreExecutorPackage ... execPackages) {
        OCLstdlibTables.PACKAGE.getClass();
        EcoreExecutorPackage[] ecoreExecutorPackageArray = execPackages;
        int n = execPackages.length;
        int n2 = 0;
        while (n2 < n) {
            EcoreExecutorPackage execPackage = ecoreExecutorPackageArray[n2];
            assert (execPackage != null);
            this.addPackage(execPackage, null);
            ++n2;
        }
    }

    public void addExtension(@NonNull EcoreExecutorPackage basePackage, @NonNull EcoreExecutorPackage extensionPackage) {
        List<EcoreExecutorPackage> list;
        Map<EcoreExecutorPackage, List<EcoreExecutorPackage>> extensions2 = this.extensions;
        if (extensions2 == null) {
            this.extensions = extensions2 = new HashMap<EcoreExecutorPackage, List<EcoreExecutorPackage>>();
        }
        if ((list = extensions2.get(basePackage)) == null) {
            list = new ArrayList<EcoreExecutorPackage>();
            extensions2.put(basePackage, list);
        }
        list.add(extensionPackage);
    }

    public synchronized void addPackage(@NonNull EcoreExecutorPackage execPackage, @Nullable EcoreExecutorPackage extendedPackage) {
        WeakReference<EcoreExecutorPackage> oldExecPackage = this.ePackageMap.put(execPackage.getNsURI(), new WeakReference<EcoreExecutorPackage>(execPackage));
    }

    @NonNull
    protected DomainMetaclass createMetaclass(@NonNull DomainType classType) {
        AbstractMetaclass metaclass = new AbstractMetaclass((DomainStandardLibrary)this, classType);
        return metaclass;
    }

    @NonNull
    public DomainType getEnumerationType() {
        Map<EcoreExecutorPackage, List<EcoreExecutorPackage>> extensions2 = this.extensions;
        if (extensions2 == null) {
            throw new IllegalStateException("No extension package registered to define Enumeration type");
        }
        if (this.enumerationType != null) {
            return this.enumerationType;
        }
        for (EcoreExecutorPackage basePackage : extensions2.keySet()) {
            for (EcoreExecutorPackage extensionPackage : extensions2.get(basePackage)) {
                for (DomainType domainType : extensionPackage.getOwnedType()) {
                    if (!"Enumeration".equals(domainType.getName())) continue;
                    this.enumerationType = domainType;
                    return domainType;
                }
            }
        }
        throw new IllegalStateException("No extension package defines Enumeration type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public DomainInheritance getInheritance(@NonNull DomainType type) {
        Map<DomainPackage, WeakReference<DomainReflectivePackage>> domainPackageMap2;
        DomainType containerType;
        if (type instanceof DomainInheritance) {
            return (DomainInheritance)type;
        }
        if (type instanceof DomainMetaclass) {
            DomainType instanceType = (DomainType)DomainUtil.nonNullPivot((Object)((DomainMetaclass)type).getInstanceType());
            DomainMetaclass metaclass = this.getMetaclass(instanceType);
            DomainType containerType2 = metaclass.getContainerType();
            return containerType2.getInheritance((DomainStandardLibrary)this);
        }
        if (type instanceof DomainCollectionType && (containerType = ((DomainCollectionType)type).getContainerType()) != null && containerType != type) {
            return containerType.getInheritance((DomainStandardLibrary)this);
        }
        DomainPackage domainPackage = type.getPackage();
        Object object = this;
        synchronized (object) {
            EcoreExecutorPackage ecoreExecutorPackage;
            String nsURI = domainPackage.getNsURI();
            EcoreExecutorPackage ecoreExecutorPackage2 = ecoreExecutorPackage = nsURI != null ? (EcoreExecutorPackage)this.weakGet(this.ePackageMap, nsURI) : null;
            if (ecoreExecutorPackage != null) {
                List<EcoreExecutorPackage> packages;
                DomainInheritance executorType = ecoreExecutorPackage.getType(type.getName());
                if (executorType != null) {
                    return executorType;
                }
                Map<EcoreExecutorPackage, List<EcoreExecutorPackage>> extensions2 = this.extensions;
                if (extensions2 != null && (packages = extensions2.get(ecoreExecutorPackage)) != null) {
                    for (EcoreExecutorPackage extensionPackage : packages) {
                        executorType = extensionPackage.getType(type.getName());
                        if (executorType == null) continue;
                        return executorType;
                    }
                }
            }
            if ((domainPackageMap2 = this.domainPackageMap) == null) {
                domainPackageMap2 = this.domainPackageMap = new WeakHashMap<DomainPackage, WeakReference<DomainReflectivePackage>>();
            }
        }
        object = domainPackageMap2;
        synchronized (object) {
            DomainReflectivePackage domainExecutorPackage = (DomainReflectivePackage)this.weakGet(domainPackageMap2, domainPackage);
            if (domainExecutorPackage == null) {
                domainExecutorPackage = new DomainReflectivePackage((DomainStandardLibrary)this, domainPackage);
                domainPackageMap2.put(domainPackage, new WeakReference<DomainReflectivePackage>(domainExecutorPackage));
            }
            return domainExecutorPackage.getInheritance(type);
        }
    }

    @NonNull
    public DomainType getMetaclassType() {
        Map<EcoreExecutorPackage, List<EcoreExecutorPackage>> extensions2 = this.extensions;
        if (extensions2 == null) {
            throw new IllegalStateException("No extension package registered to define Metaclass type");
        }
        if (this.metaclassType != null) {
            return this.metaclassType;
        }
        for (EcoreExecutorPackage basePackage : extensions2.keySet()) {
            for (EcoreExecutorPackage extensionPackage : extensions2.get(basePackage)) {
                for (DomainType domainType : extensionPackage.getOwnedType()) {
                    if (!"Metaclass".equals(domainType.getName())) continue;
                    this.metaclassType = domainType;
                    return domainType;
                }
            }
        }
        throw new IllegalStateException("No extension package defines Metaclass type");
    }

    @Nullable
    public DomainType getNestedType(@NonNull DomainPackage parentPackage, @NonNull String name) {
        List<EcoreExecutorPackage> list;
        DomainType nestedType = super.getNestedType(parentPackage, name);
        if (nestedType != null) {
            return nestedType;
        }
        if (this.extensions != null && (list = this.extensions.get(parentPackage)) != null) {
            for (EcoreExecutorPackage extensionPackage : list) {
                assert (extensionPackage != null);
                nestedType = super.getNestedType((DomainPackage)extensionPackage, name);
                if (nestedType == null) continue;
                return nestedType;
            }
        }
        return nestedType;
    }

    public DomainPackage getNsURIPackage(@NonNull String nsURI) {
        WeakReference<EcoreExecutorPackage> weakReference = this.ePackageMap.get(nsURI);
        if (weakReference == null) {
            return null;
        }
        return (DomainPackage)weakReference.get();
    }

    @Nullable
    public synchronized EcoreExecutorPackage getPackage(@NonNull EPackage ePackage) {
        String nsURI = ePackage.getNsURI();
        return nsURI != null ? (EcoreExecutorPackage)this.weakGet(this.ePackageMap, nsURI) : null;
    }

    public synchronized DomainInheritance getOclType(@NonNull String typeName) {
        for (WeakReference<EcoreExecutorPackage> dPackage : this.ePackageMap.values()) {
            DomainInheritance type;
            EcoreExecutorPackage packageRef;
            if (dPackage == null || (packageRef = (EcoreExecutorPackage)dPackage.get()) == null || (type = packageRef.getType(typeName)) == null) continue;
            return type;
        }
        return null;
    }
}

