/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.executor;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainProperty;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.DomainTypeParameters;
import org.eclipse.ocl.examples.domain.elements.FeatureFilter;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.types.AbstractFragment;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.library.executor.DomainProperties;
import org.eclipse.ocl.examples.library.executor.DomainReflectiveFragment;
import org.eclipse.ocl.examples.library.executor.DomainReflectivePackage;
import org.eclipse.ocl.examples.library.executor.ExecutorTypeParameter;
import org.eclipse.ocl.examples.library.executor.ReflectiveType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainReflectiveType
extends ReflectiveType {
    @NonNull
    protected final DomainStandardLibrary standardLibrary;
    @NonNull
    protected final DomainType domainType;
    private DomainProperties allProperties;

    public DomainReflectiveType(@NonNull DomainReflectivePackage evaluationPackage, @NonNull DomainType domainType) {
        super((String)DomainUtil.nonNullModel((Object)domainType.getName()), evaluationPackage, DomainReflectiveType.computeFlags(domainType), new ExecutorTypeParameter[0]);
        this.standardLibrary = evaluationPackage.getStandardLibrary();
        this.domainType = domainType;
    }

    @Override
    @NonNull
    protected AbstractFragment createFragment(@NonNull DomainInheritance baseInheritance) {
        return new DomainReflectiveFragment(this, baseInheritance);
    }

    @NonNull
    public Iterable<? extends DomainOperation> getAllOperations(@Nullable FeatureFilter featureFilter) {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public Iterable<? extends DomainProperty> getAllProperties(@Nullable FeatureFilter featureFilter) {
        DomainProperties allProperties2 = this.allProperties;
        if (allProperties2 == null) {
            this.allProperties = allProperties2 = new DomainProperties((DomainInheritance)this);
        }
        return allProperties2.getAllProperties(featureFilter);
    }

    @Override
    @NonNull
    public Iterable<? extends DomainInheritance> getInitialSuperInheritances() {
        final Iterator iterator = this.domainType.getLocalSuperTypes().iterator();
        return new Iterable<DomainInheritance>(){

            @Override
            public Iterator<DomainInheritance> iterator() {
                return new Iterator<DomainInheritance>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public DomainInheritance next() {
                        return ((DomainType)iterator.next()).getInheritance((this).DomainReflectiveType.this.standardLibrary);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @NonNull
    public List<? extends DomainOperation> getLocalOperations() {
        return this.domainType.getLocalOperations();
    }

    @NonNull
    public List<? extends DomainProperty> getLocalProperties() {
        return this.domainType.getLocalProperties();
    }

    @NonNull
    public List<? extends DomainType> getLocalSuperTypes() {
        return this.domainType.getLocalSuperTypes();
    }

    @Nullable
    public DomainProperty getMemberProperty(@NonNull String name) {
        DomainProperties allProperties2 = this.allProperties;
        if (allProperties2 == null) {
            this.allProperties = allProperties2 = new DomainProperties((DomainInheritance)this);
        }
        return allProperties2.getMemberProperty(name);
    }

    @NonNull
    public String getMetaTypeName() {
        return this.domainType.getMetaTypeName();
    }

    @NonNull
    public List<? extends DomainProperty> getOwnedAttribute() {
        return this.domainType.getLocalProperties();
    }

    @NonNull
    public List<? extends DomainOperation> getOwnedOperation() {
        return this.domainType.getLocalOperations();
    }

    @NonNull
    public DomainStandardLibrary getStandardLibrary() {
        return this.standardLibrary;
    }

    @Override
    @NonNull
    public TypeId getTypeId() {
        return this.domainType.getTypeId();
    }

    @NonNull
    public DomainTypeParameters getTypeParameters() {
        return this.domainType.getTypeParameters();
    }
}

