/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.collection;

import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.ids.TupleTypeId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.AbstractBinaryOperation;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;

public class CollectionProductOperation
extends AbstractBinaryOperation {
    @NonNull
    public static final CollectionProductOperation INSTANCE = new CollectionProductOperation();

    @NonNull
    public CollectionValue evaluate(@NonNull DomainEvaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceVal, @Nullable Object argVal) {
        CollectionTypeId collTypeId;
        TupleTypeId tupleTypeId;
        CollectionValue argumentValue;
        CollectionValue sourceValue = CollectionProductOperation.asCollectionValue((Object)sourceVal);
        Set product = sourceValue.product(argumentValue = CollectionProductOperation.asCollectionValue((Object)argVal), tupleTypeId = (TupleTypeId)(collTypeId = (CollectionTypeId)returnTypeId).getElementTypeId());
        if (product != null) {
            return evaluator.getIdResolver().createSetOfAll(collTypeId, (Iterable)product);
        }
        throw new InvalidValueException(EvaluatorMessages.MissingResult, new Object[]{"product"});
    }
}

