/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.api.interpreter.context;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionQuery;
import org.eclipse.sirius.common.tools.api.interpreter.DefaultInterpreterContextFactory;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.ext.base.Option;

public final class SiriusInterpreterContextFactory {
    private SiriusInterpreterContextFactory() {
    }

    public static IInterpreterContext createInterpreterContext(EObject element, EStructuralFeature feature) {
        Collection targetDomainClasses = Sets.newLinkedHashSet();
        Collection<Object> avalaiblePackages = Sets.newLinkedHashSet();
        Collection<Object> dependencies = Sets.newLinkedHashSet();
        Map<Object, Object> variables = Maps.newLinkedHashMap();
        boolean requiresTargetType = true;
        IInterpretedExpressionQuery query = DialectManager.INSTANCE.createInterpretedExpressionQuery(element, feature);
        Option<Collection<String>> targetDomainClassesOption = query.getTargetDomainClasses();
        if (!targetDomainClassesOption.some()) {
            requiresTargetType = false;
        } else {
            targetDomainClasses = (Collection)targetDomainClassesOption.get();
        }
        if (!targetDomainClassesOption.some() || !((Collection)targetDomainClassesOption.get()).isEmpty()) {
            avalaiblePackages = query.getPackagesToImport();
            variables = query.getAvailableVariables();
            dependencies = query.getDependencies();
        }
        IInterpreterContext context = DefaultInterpreterContextFactory.createInterpreterContext((EObject)element, (boolean)requiresTargetType, (EStructuralFeature)feature, (Collection)targetDomainClasses, (Collection)avalaiblePackages, (Map)variables, (Collection)dependencies);
        return context;
    }
}

