/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.repair.commands;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.sirius.business.api.repair.IRepairParticipant;
import org.eclipse.sirius.viewpoint.DView;

public class RestoreModelElementStateCommand
extends IdentityCommand {
    private DView view;
    private List<IRepairParticipant> repairParticipants;
    private IProgressMonitor monitor;

    public RestoreModelElementStateCommand(DView view, List<IRepairParticipant> repairParticipants, IProgressMonitor monitor) {
        this.view = view;
        this.repairParticipants = repairParticipants;
        this.monitor = monitor;
    }

    public void execute() {
        this.monitor.beginTask("restor model elements", this.repairParticipants.size());
        for (IRepairParticipant participant : this.repairParticipants) {
            participant.restoreModelElementState(this.view, (IProgressMonitor)new NullProgressMonitor());
            this.monitor.worked(1);
        }
        this.monitor.done();
        this.repairParticipants = null;
        this.view = null;
    }

    public boolean canUndo() {
        return false;
    }
}

