/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.query;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.sirius.viewpoint.DAnalysis;

public class DAnalysisesInternalQuery {
    protected Collection<DAnalysis> analysises;

    public DAnalysisesInternalQuery(Collection<DAnalysis> analysises) {
        this.analysises = analysises;
    }

    public Collection<DAnalysis> getAllAnalyses() {
        LinkedHashSet analysisAndReferenced = Sets.newLinkedHashSet();
        for (DAnalysis analysis : new ArrayList<DAnalysis>(this.analysises)) {
            if (analysis == null) continue;
            analysisAndReferenced.add(analysis);
            this.addAllReferencedAnalyses(analysisAndReferenced, analysis);
        }
        return analysisAndReferenced;
    }

    private void addAllReferencedAnalyses(Collection<DAnalysis> analysisAndReferenced, DAnalysis analysis) {
        for (DAnalysis referenced : Sets.newLinkedHashSet(analysis.getReferencedAnalysis())) {
            if (analysisAndReferenced.contains(referenced) || referenced.eResource() == null) continue;
            analysisAndReferenced.add(referenced);
            this.addAllReferencedAnalyses(analysisAndReferenced, referenced);
        }
    }
}

