/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.movida.registry;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.componentization.ViewpointResourceHandler;
import org.eclipse.sirius.business.api.query.ViewpointQuery;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class MaskingPolicy {
    private Ordering<SiriusImplementation> viewpointComparator;
    private final ListMultimap<URI, SiriusImplementation> viewpointImplementations = ArrayListMultimap.create();
    private final LoadingCache<Resource, Integer> score = CacheBuilder.newBuilder().build(CacheLoader.from((Function)Functions.constant((Object)0)));
    private final ViewpointResourceHandler resourceHandler;

    public MaskingPolicy(Comparator<URI> comparator, ViewpointResourceHandler resourceHandler) {
        this.viewpointComparator = Ordering.from(comparator).onResultOf((Function)new Function<SiriusImplementation, URI>(){

            public URI apply(SiriusImplementation vp) {
                return vp.provider.getURI();
            }
        }).reverse();
        this.resourceHandler = (ViewpointResourceHandler)Preconditions.checkNotNull((Object)resourceHandler);
    }

    public synchronized MaskingChange resourceLoaded(Resource loaded) {
        Preconditions.checkNotNull((Object)loaded);
        Preconditions.checkState((boolean)loaded.isLoaded(), (Object)("The resource is not loaded: " + loaded));
        MaskingChange change = new MaskingChange();
        for (Viewpoint viewpoint : this.resourceHandler.collectViewpointDefinitions(loaded)) {
            Option<URI> uri = new ViewpointQuery(viewpoint).getViewpointURI();
            Preconditions.checkState((boolean)uri.some(), (Object)("Could not identify logical Sirius URI for Sirius " + viewpoint));
            SiriusImplementation vi = new SiriusImplementation((URI)uri.get(), loaded);
            List implementations = this.viewpointImplementations.get((Object)vi.logicalURI);
            int insertionPoint = this.insertSorted(implementations, vi);
            if (insertionPoint == -1) {
                MaskingChange result = new MaskingChange();
                result.masked.add(loaded);
                return result;
            }
            this.updateScore(loaded, insertionPoint, change);
            int i = insertionPoint + 1;
            while (i < implementations.size()) {
                this.updateScore(((SiriusImplementation)implementations.get(i)).provider, 1, change);
                ++i;
            }
        }
        return change;
    }

    public synchronized MaskingChange aboutToUnload(final Resource unloaded) {
        Preconditions.checkNotNull((Object)unloaded);
        Preconditions.checkState((boolean)unloaded.isLoaded(), (Object)("The resource is not loaded: " + unloaded));
        MaskingChange change = new MaskingChange();
        ImmutableSet viewpointsFromUnloadedResource = ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)this.viewpointImplementations.values(), (Predicate)new Predicate<SiriusImplementation>(){

            public boolean apply(SiriusImplementation input) {
                return input.provider == unloaded;
            }
        }));
        for (SiriusImplementation vi : viewpointsFromUnloadedResource) {
            int index;
            List providers = this.viewpointImplementations.get((Object)vi.logicalURI);
            int i = index = this.removeSorted(providers, vi);
            while (i < providers.size()) {
                this.updateScore(((SiriusImplementation)providers.get(i)).provider, -1, change);
                ++i;
            }
        }
        this.score.invalidate((Object)unloaded);
        change.masked.add(unloaded);
        assert (change.isConsistent());
        return change;
    }

    private int insertSorted(List<SiriusImplementation> providers, SiriusImplementation viewpoint) {
        assert (this.viewpointComparator.isOrdered(providers));
        int x = this.viewpointComparator.binarySearch(providers, (Object)viewpoint);
        if (x >= 0) {
            return -1;
        }
        assert (x < 0) : "The viewpoint should not already be present in the list";
        int insertionPoint = -x - 1;
        providers.add(insertionPoint, viewpoint);
        assert (this.viewpointComparator.isOrdered(providers));
        return insertionPoint;
    }

    private int removeSorted(List<SiriusImplementation> providers, SiriusImplementation viewpoint) {
        assert (providers != null && providers.contains(viewpoint)) : "Trying to remove unknown viewpoint implementation " + viewpoint;
        assert (this.viewpointComparator.isOrdered(providers));
        int index = this.viewpointComparator.binarySearch(providers, (Object)viewpoint);
        providers.remove(viewpoint);
        return index;
    }

    private void updateScore(Resource res, int delta, MaskingChange change) {
        int oldValue;
        try {
            oldValue = (Integer)this.score.get((Object)res);
        }
        catch (ExecutionException executionException) {
            oldValue = 0;
        }
        int newValue = oldValue + delta;
        assert (newValue >= 0);
        this.score.put((Object)res, (Object)newValue);
        if (oldValue == 0 && newValue > 0) {
            change.masked.add(res);
        } else if (oldValue >= 0 && newValue == 0) {
            change.unmasked.add(res);
        }
    }

    public synchronized boolean isMasked(Resource res) {
        return this.score.asMap().containsKey(res) && (Integer)this.score.getIfPresent((Object)res) > 0;
    }

    public synchronized Set<Resource> getUnmaskedResources() {
        HashSet unmasked = Sets.newHashSet();
        for (Resource resource : this.score.asMap().keySet()) {
            if (this.isMasked(resource)) continue;
            unmasked.add(resource);
        }
        return ImmutableSet.copyOf((Collection)unmasked);
    }

    public synchronized Set<Resource> getMaskedResources() {
        return ImmutableSet.copyOf((Collection)Sets.difference(this.score.asMap().keySet(), this.getUnmaskedResources()));
    }

    public static class MaskingChange {
        Set<Resource> masked = Sets.newHashSet();
        Set<Resource> unmasked = Sets.newHashSet();

        public boolean isConsistent() {
            return Sets.intersection(this.masked, this.unmasked).isEmpty();
        }
    }

    private static class SiriusImplementation {
        private final URI logicalURI;
        private final Resource provider;

        public SiriusImplementation(URI logicalURI, Resource provider) {
            this.logicalURI = (URI)Preconditions.checkNotNull((Object)logicalURI);
            this.provider = (Resource)Preconditions.checkNotNull((Object)provider);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.logicalURI, this.provider});
        }

        public boolean equals(Object obj) {
            if (obj instanceof SiriusImplementation) {
                SiriusImplementation that = (SiriusImplementation)obj;
                return Objects.equal((Object)this.logicalURI, (Object)that.logicalURI) && Objects.equal((Object)this.provider, (Object)that.provider);
            }
            return false;
        }

        public String toString() {
            return String.valueOf(this.logicalURI.toString()) + " (" + this.provider.getURI().toString() + ")";
        }
    }
}

