/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.logger;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.RuntimeLogger;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerInterpreter;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.internal.logger.RuntimeLoggerInterpreterImpl;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.EclipseUtil;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public class RuntimeLoggerManagerImpl
implements RuntimeLoggerManager {
    private Collection<RuntimeLogger> loggers = new LinkedHashSet<RuntimeLogger>();

    public static RuntimeLoggerManager init() {
        RuntimeLoggerManagerImpl manager = new RuntimeLoggerManagerImpl();
        if (SiriusPlugin.IS_ECLIPSE_RUNNING) {
            List parsedLoggers = EclipseUtil.getExtensionPlugins(RuntimeLogger.class, (String)"org.eclipse.sirius.runtimeLogger", (String)"class");
            for (RuntimeLogger logger : parsedLoggers) {
                manager.add(logger);
            }
        }
        return manager;
    }

    @Override
    public RuntimeLoggerInterpreter decorate(IInterpreter interpreter) {
        return new RuntimeLoggerInterpreterImpl(interpreter);
    }

    private void add(RuntimeLogger logger) {
        this.loggers.add(logger);
    }

    @Override
    public void error(EObject odesignObject, EStructuralFeature feature, String message) {
        for (RuntimeLogger logger : this.loggers) {
            logger.error(odesignObject, feature, message);
        }
    }

    @Override
    public void info(EObject odesignObject, EStructuralFeature feature, String message) {
        for (RuntimeLogger logger : this.loggers) {
            logger.info(odesignObject, feature, message);
        }
    }

    @Override
    public void warning(EObject odesignObject, EStructuralFeature feature, String message) {
        for (RuntimeLogger logger : this.loggers) {
            logger.warning(odesignObject, feature, message);
        }
    }

    @Override
    public void clearAll() {
        for (RuntimeLogger logger : this.loggers) {
            logger.clearAll();
        }
    }

    @Override
    public void clear(EObject eObject) {
        for (RuntimeLogger logger : this.loggers) {
            logger.clear(eObject);
        }
    }

    @Override
    public void error(EObject odesignObject, EStructuralFeature feature, Throwable exception) {
        for (RuntimeLogger logger : this.loggers) {
            logger.error(odesignObject, feature, exception);
        }
    }

    @Override
    public void info(EObject odesignObject, EStructuralFeature feature, Throwable exception) {
        for (RuntimeLogger logger : this.loggers) {
            logger.info(odesignObject, feature, exception);
        }
    }

    @Override
    public void warning(EObject odesignObject, EStructuralFeature feature, Throwable exception) {
        for (RuntimeLogger logger : this.loggers) {
            logger.warning(odesignObject, feature, exception);
        }
    }
}

