/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.extender;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.sirius.business.api.extender.MetamodelDescriptorManager;
import org.eclipse.sirius.business.api.extender.MetamodelDescriptorProvider;
import org.eclipse.sirius.common.tools.api.util.EclipseUtil;
import org.eclipse.sirius.ecore.extender.business.api.accessor.MetamodelDescriptor;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class MetamodelDescriptorManagerImpl
implements MetamodelDescriptorManager {
    private Collection<MetamodelDescriptorProvider> providers = new ArrayList<MetamodelDescriptorProvider>();

    public static MetamodelDescriptorManager init() {
        MetamodelDescriptorManagerImpl manager = new MetamodelDescriptorManagerImpl();
        if (SiriusPlugin.IS_ECLIPSE_RUNNING) {
            List parsedDialects = EclipseUtil.getExtensionPlugins(MetamodelDescriptorProvider.class, (String)"org.eclipse.sirius.mmdescriptor", (String)"class");
            for (MetamodelDescriptorProvider provider : parsedDialects) {
                manager.enableProvider(provider);
            }
        }
        return manager;
    }

    private void enableProvider(MetamodelDescriptorProvider provider) {
        this.providers.add(provider);
    }

    @Override
    public Collection<MetamodelDescriptor> provides(Collection<Viewpoint> enabledViewpoints) {
        HashSet<MetamodelDescriptor> result = new HashSet<MetamodelDescriptor>();
        for (Viewpoint vp : enabledViewpoints) {
            for (MetamodelDescriptorProvider provider : this.providers) {
                Collection<MetamodelDescriptor> provided = provider.provides(vp);
                if (provided == null) continue;
                result.addAll(provided);
            }
        }
        return result;
    }
}

