/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.dialect.description;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.description.ColorDescription;
import org.eclipse.sirius.viewpoint.description.ColorStep;
import org.eclipse.sirius.viewpoint.description.ConditionalStyleDescription;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.EAttributeCustomization;
import org.eclipse.sirius.viewpoint.description.InterpolatedColor;
import org.eclipse.sirius.viewpoint.description.SelectionDescription;
import org.eclipse.sirius.viewpoint.description.SemanticBasedDecoration;
import org.eclipse.sirius.viewpoint.description.VSMElementCustomization;
import org.eclipse.sirius.viewpoint.description.util.DescriptionSwitch;

public class DescriptionInterpretedExpressionTargetSwitch
extends DescriptionSwitch<Option<Collection<String>>> {
    private static final int DO_NOT_CONSIDER_FEATURE = -1;
    protected int featureID;
    protected IInterpretedExpressionTargetSwitch globalSwitch;
    private int lastFeatureID;

    public DescriptionInterpretedExpressionTargetSwitch(EStructuralFeature feature, IInterpretedExpressionTargetSwitch theGlobalSwitch) {
        this.lastFeatureID = this.featureID = feature != null ? feature.getFeatureID() : -1;
        this.globalSwitch = theGlobalSwitch;
    }

    @Override
    public Option<Collection<String>> doSwitch(EObject theEObject) {
        Option doSwitch = (Option)super.doSwitch(theEObject);
        if (doSwitch != null) {
            return doSwitch;
        }
        LinkedHashSet defaultResult = Sets.newLinkedHashSet();
        return Options.newSome((Object)defaultResult);
    }

    public void setConsiderFeature(boolean considerFeature) {
        if (considerFeature) {
            this.featureID = this.lastFeatureID;
        } else {
            this.lastFeatureID = this.featureID;
            this.featureID = -1;
        }
    }

    private EObject getFirstRelevantContainer(EObject element) {
        return this.globalSwitch.getFirstRelevantContainer(element);
    }

    @Override
    public Option<Collection<String>> caseSemanticBasedDecoration(SemanticBasedDecoration object) {
        Option result = null;
        LinkedHashSet target = Sets.newLinkedHashSet();
        switch (this.featureID) {
            case -1: 
            case 3: {
                target.add(object.getDomainClass());
                result = Options.newSome((Object)target);
                break;
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> caseConditionalStyleDescription(ConditionalStyleDescription styleDescription) {
        LinkedHashSet target = Sets.newLinkedHashSet();
        Option<Collection<String>> result = Options.newSome((Object)target);
        switch (this.featureID) {
            case 0: {
                result = this.globalSwitch.doSwitch(this.getFirstRelevantContainer(styleDescription), false);
                break;
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> caseColorDescription(ColorDescription object) {
        return Options.newNone();
    }

    @Override
    public Option<Collection<String>> caseColorStep(ColorStep object) {
        return Options.newNone();
    }

    @Override
    public Option<Collection<String>> caseInterpolatedColor(InterpolatedColor object) {
        return Options.newNone();
    }

    @Override
    public Option<Collection<String>> caseVSMElementCustomization(VSMElementCustomization object) {
        Option result = null;
        switch (this.featureID) {
            case -1: 
            case 0: {
                result = Options.newNone();
                break;
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> caseEAttributeCustomization(EAttributeCustomization object) {
        Option result = null;
        switch (this.featureID) {
            case -1: 
            case 3: {
                result = Options.newNone();
                break;
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> caseSelectionDescription(SelectionDescription selectionDescription) {
        Option<Collection<String>> result = null;
        switch (this.featureID) {
            case 0: 
            case 3: 
            case 4: {
                EObjectQuery query = new EObjectQuery(selectionDescription);
                Option<EObject> parentRepresentationDescription = query.getFirstAncestorOfType(DescriptionPackage.eINSTANCE.getRepresentationDescription());
                if (!parentRepresentationDescription.some()) break;
                result = this.globalSwitch.doSwitch((EObject)parentRepresentationDescription.get(), false);
                break;
            }
        }
        return result;
    }
}

