/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.contribution;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.query.ViewpointQuery;
import org.eclipse.sirius.business.internal.contribution.IdentifierBasedMatcher;
import org.eclipse.sirius.business.internal.contribution.ModelContributor;
import org.eclipse.sirius.business.internal.contribution.ReferenceResolver;
import org.eclipse.sirius.business.internal.contribution.Updater;
import org.eclipse.sirius.description.contribution.Contribution;
import org.eclipse.sirius.description.contribution.FeatureContribution;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.emf.AllContents;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class IncrementalModelContributor
extends ModelContributor {
    private EObject model;
    private Map<EObject, Object> modelIds;
    private Function<EObject, Object> idFunction;
    private Map<EObject, Object> contributions;
    private EcoreUtil.Copier currentCopier;
    private Map<Viewpoint, String> viewpointUris;
    private List<EStructuralFeature> targetsWithEOpposites;

    public IncrementalModelContributor(Function<Iterable<EObject>, Iterable<Contribution>> contributionFinder, ReferenceResolver resolver, Function<EObject, Object> idFunction) {
        super(contributionFinder, resolver);
        this.idFunction = (Function)Preconditions.checkNotNull(idFunction);
    }

    @Override
    public EObject apply(EObject targetModel, Collection<? extends EObject> contributionSources) {
        ArrayList referenceInputs = Lists.newArrayList(contributionSources);
        this.currentCopier = new EcoreUtil.Copier();
        ArrayList inputs = Lists.newArrayList((Iterable)this.currentCopier.copyAll((Collection)referenceInputs));
        this.currentCopier.copyReferences();
        HashMap inputIds = Maps.newHashMap();
        for (EObject root : referenceInputs) {
            for (EObject obj : AllContents.of((EObject)root, (boolean)true)) {
                inputIds.put((EObject)this.currentCopier.get((Object)obj), this.idFunction.apply((Object)obj));
            }
        }
        this.viewpointUris = Maps.newHashMap();
        for (Viewpoint originalVP : Iterables.filter((Iterable)this.currentCopier.keySet(), Viewpoint.class)) {
            Option<URI> uri = new ViewpointQuery(originalVP).getViewpointURI();
            if (!uri.some()) continue;
            this.viewpointUris.put((Viewpoint)this.currentCopier.get((Object)originalVP), ((URI)uri.get()).toString());
        }
        EObject result = super.apply((EObject)this.currentCopier.get((Object)targetModel), inputs);
        this.postProcess(result);
        this.contributions = Maps.newHashMap((Map)Maps.filterKeys((Map)inputIds, (Predicate)Predicates.in((Collection)this.additions)));
        if (this.model == null) {
            this.model = result;
            this.modelIds = Maps.newHashMap((Map)Maps.filterKeys((Map)inputIds, (Predicate)new Predicate<EObject>(){

                public boolean apply(EObject input) {
                    return input == IncrementalModelContributor.this.model || EcoreUtil.isAncestor((EObject)IncrementalModelContributor.this.model, (EObject)input);
                }
            }));
        } else {
            Function<EObject, Object> f = this.update(result, inputIds);
            HashMap newIds = Maps.newHashMap();
            for (EObject obj : AllContents.of((EObject)this.model, (boolean)true)) {
                newIds.put(obj, f.apply((Object)obj));
            }
            this.modelIds = newIds;
        }
        return this.model;
    }

    protected void postProcess(EObject result) {
    }

    public Object getIdentifier(EObject obj) {
        return this.modelIds.get(obj);
    }

    public void resetState(EObject newModel, Map<EObject, ? extends Object> ids) {
        this.model = newModel;
        this.modelIds = Maps.newHashMap(ids);
    }

    public Map<EObject, Object> getContributionPoints() {
        return ImmutableMap.copyOf(this.contributions);
    }

    protected String getSiriusURI(Viewpoint copiedSirius) {
        return this.viewpointUris.get(copiedSirius);
    }

    @Override
    protected List<Contribution> findAllContributions(EObject targetModel, Iterable<EObject> sources) {
        List<Contribution> rawResult = super.findAllContributions(targetModel, sources);
        ArrayList result = Lists.newArrayListWithCapacity((int)rawResult.size());
        for (Contribution contribution : rawResult) {
            if (this.currentCopier.containsKey((Object)contribution)) {
                EObject copy = (EObject)this.currentCopier.get((Object)contribution);
                if (!(copy instanceof Contribution)) continue;
                result.add((Contribution)copy);
                continue;
            }
            result.add(contribution);
        }
        this.targetsWithEOpposites = Lists.newArrayList();
        for (Contribution contribution : result) {
            for (FeatureContribution fc : contribution.getFeatureMask()) {
                if (!(fc.getTargetFeature() instanceof EReference) || ((EReference)fc.getTargetFeature()).getEOpposite() == null) continue;
                this.targetsWithEOpposites.add((EStructuralFeature)((EReference)fc.getTargetFeature()).getEOpposite());
            }
        }
        return result;
    }

    private Function<EObject, Object> update(EObject result, final Map<EObject, Object> inputIds) {
        Function<EObject, Object> idFunction2 = new Function<EObject, Object>(){

            public Object apply(EObject from) {
                if (IncrementalModelContributor.this.modelIds.containsKey(from)) {
                    return IncrementalModelContributor.this.modelIds.get(from);
                }
                return inputIds.get(from);
            }
        };
        IdentifierBasedMatcher matcher = new IdentifierBasedMatcher(idFunction2);
        Updater updater = new Updater(matcher, this.model, result);
        updater.setFeaturesToIgnore(this.targetsWithEOpposites);
        updater.update();
        return idFunction2;
    }
}

