/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.command.control;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class ControlCommand
extends RecordingCommand {
    protected final TransactionalEditingDomain domain;
    protected final EObject semanticObjectToControl;
    protected final URI destination;
    protected Resource controlledResource;

    public ControlCommand(EObject semanticObjectToControl, URI destination) {
        super(TransactionUtil.getEditingDomain((EObject)semanticObjectToControl));
        this.domain = TransactionUtil.getEditingDomain((EObject)semanticObjectToControl);
        this.semanticObjectToControl = semanticObjectToControl;
        this.destination = destination;
    }

    protected boolean prepare() {
        return super.prepare() && this.domain.isControllable((Object)this.semanticObjectToControl);
    }

    protected void doExecute() {
        this.move(this.semanticObjectToControl, this.destination);
        EcoreUtil.resolveAll((ResourceSet)this.domain.getResourceSet());
    }

    protected void move(EObject root, URI uri) {
        this.controlledResource = this.getOrCreateChildResource(root.eResource(), uri);
        if (this.controlledResource == null) {
            throw new RuntimeException("Invalid target URI for control: could not load or create " + uri);
        }
        this.controlledResource.getContents().add((Object)root);
    }

    protected Resource getOrCreateChildResource(Resource parent, URI uri) {
        Resource existingResource = parent.getResourceSet().getResource(uri, false);
        if (existingResource != null) {
            return this.isValidControlTarget(parent, existingResource) ? existingResource : null;
        }
        return parent.getResourceSet().createResource(uri);
    }

    private boolean isValidControlTarget(Resource parent, Resource child) {
        return child != parent && !this.domain.isReadOnly(child);
    }
}

