/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.query;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.query.FileQuery;
import org.eclipse.sirius.business.api.session.resource.AirdResource;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class ResourceQuery {
    private final Resource resource;

    public ResourceQuery(Resource resource) {
        this.resource = (Resource)Preconditions.checkNotNull((Object)resource);
    }

    public Collection<URI> getResolvedDependencies() {
        HashSet dependencies = Sets.newHashSet();
        for (EObject root : this.resource.getContents()) {
            dependencies.addAll(new EObjectQuery(root).getResolvedDependencies());
        }
        return dependencies;
    }

    public Collection<URI> getUnresolvedDependencies() {
        HashSet dependencies = Sets.newHashSet();
        for (EObject root : this.resource.getContents()) {
            dependencies.addAll(new EObjectQuery(root).getUnresolvedDependencies());
        }
        return dependencies;
    }

    public boolean isRepresentationsResource() {
        boolean isRepresentationsResource = false;
        try {
            isRepresentationsResource = this.resource.getURI() != null;
        }
        catch (IllegalStateException illegalStateException) {}
        isRepresentationsResource = isRepresentationsResource && new FileQuery(this.resource.getURI().fileExtension()).isSessionResourceFile();
        boolean bl = isRepresentationsResource = isRepresentationsResource || this.resource instanceof AirdResource;
        if (!isRepresentationsResource && this.resource.getContents() != null && this.resource.getContents().size() == 1) {
            isRepresentationsResource = ((EObject)this.resource.getContents().get(0)).eClass().equals(ViewpointPackage.eINSTANCE.getDAnalysis());
        }
        return isRepresentationsResource;
    }

    public boolean isModelerResource() {
        if (this.resource.getURI() != null) {
            return new FileQuery(this.resource.getURI().fileExtension()).isVSMFile();
        }
        return false;
    }
}

