/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.utilities;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.ids.TuplePartId;
import org.eclipse.ocl.examples.domain.ids.TupleTypeId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.TupleValue;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.PropertyCallExp;
import org.eclipse.ocl.examples.pivot.StringLiteralExp;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConstraintEvaluator<T> {
    @NonNull
    protected final ExpressionInOCL expression;
    private OCLExpression body;

    private static OCLExpression getConstraintExpression(@NonNull ExpressionInOCL constraintSpecification) {
        PropertyCallExp propertyCallExp;
        Property referredProperty;
        OCLExpression body = constraintSpecification.getBodyExpression();
        if (body instanceof PropertyCallExp && (referredProperty = (propertyCallExp = (PropertyCallExp)body).getReferredProperty()) != null && referredProperty.getOwningType() instanceof TupleType && "status".equals(referredProperty.getName())) {
            return propertyCallExp.getSource();
        }
        return body;
    }

    public ConstraintEvaluator(@NonNull ExpressionInOCL expression) {
        this.expression = expression;
        this.body = ConstraintEvaluator.getConstraintExpression(expression);
    }

    public T evaluate(@NonNull EvaluationVisitor evaluationVisitor) {
        if (this.expression.getContextVariable() == null && this.body instanceof StringLiteralExp) {
            String stringSymbol = ((StringLiteralExp)this.body).getStringSymbol();
            return this.handleInvalidExpression(stringSymbol);
        }
        Object result = null;
        boolean status = false;
        try {
            result = this.body.accept(evaluationVisitor);
            status = this.getConstraintResultStatus(result);
        }
        catch (InvalidValueException e) {
            return this.handleInvalidResult(e);
        }
        catch (Throwable e) {
            return this.handleExceptionResult(e);
        }
        if (status) {
            return this.handleSuccessResult();
        }
        return this.handleFailureResult(result);
    }

    protected String getConstraintName() {
        Constraint constraint = PivotUtil.getContainingConstraint(this.expression);
        if (constraint != null) {
            return constraint.getName();
        }
        return "<<unknown>>";
    }

    @NonNull
    protected String getConstraintResultMessage(@Nullable Object result) {
        if (result instanceof TupleValue) {
            TupleValue tupleValue = (TupleValue)result;
            TupleTypeId tupleTypeId = tupleValue.getTypeId();
            TuplePartId messagePartId = tupleTypeId.getPartId("message");
            if (messagePartId != null) {
                String string = String.valueOf(tupleValue.getValue(messagePartId));
                return string;
            }
        } else if (result == null) {
            return DomainUtil.bind((String)OCLMessages.ValidationResultIsNull_ERROR_, (Object[])new Object[]{this.getConstraintTypeName(), this.getConstraintName(), this.getObjectLabel()});
        }
        return DomainUtil.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{this.getConstraintTypeName(), this.getConstraintName(), this.getObjectLabel()});
    }

    protected int getConstraintResultSeverity(@Nullable Object result) {
        if (result instanceof TupleValue) {
            TupleValue tupleValue = (TupleValue)result;
            TupleTypeId tupleTypeId = tupleValue.getTypeId();
            TuplePartId severityPartId = tupleTypeId.getPartId("severity");
            if (severityPartId != null) {
                IntegerValue value = ValuesUtil.integerValueOf((Object)tupleValue.getValue(severityPartId));
                int signum = value.signum();
                if (signum < 0) {
                    return 4;
                }
                if (signum == 0) {
                    return 1;
                }
                return 2;
            }
            TuplePartId statusPartId = tupleTypeId.getPartId("status");
            if (statusPartId != null) {
                result = tupleValue.getValue(statusPartId);
            }
        }
        return result == null ? 4 : 2;
    }

    protected boolean getConstraintResultStatus(@Nullable Object result) {
        if (result == Boolean.TRUE) {
            return true;
        }
        if (result instanceof TupleValue) {
            TupleValue tupleValue = (TupleValue)result;
            TupleTypeId tupleTypeId = tupleValue.getTypeId();
            TuplePartId statusPartId = tupleTypeId.getPartId("status");
            if (statusPartId == null) {
                return false;
            }
            Object value = tupleValue.getValue(statusPartId);
            if (value == Boolean.TRUE) {
                return true;
            }
        }
        return false;
    }

    protected String getConstraintTypeName() {
        Type type = PivotUtil.getContainingType(this.expression);
        if (type != null) {
            return type.getName();
        }
        return "<<unknown>>";
    }

    protected abstract String getObjectLabel();

    protected abstract T handleExceptionResult(@NonNull Throwable var1);

    protected abstract T handleFailureResult(@Nullable Object var1);

    protected abstract T handleInvalidExpression(@NonNull String var1);

    protected abstract T handleInvalidResult(@NonNull InvalidValueException var1);

    protected abstract T handleSuccessResult();

    protected boolean isBooleanConstraint() {
        TypeId typeId = this.expression.getTypeId();
        return typeId == TypeId.BOOLEAN;
    }
}

