/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.utilities;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.LambdaType;
import org.eclipse.ocl.examples.pivot.LoopExp;
import org.eclipse.ocl.examples.pivot.Metaclass;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeTemplateParameter;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.utilities.ASSaver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASSaverResolveVisitor
extends AbstractExtendingVisitor<Object, ASSaver> {
    public ASSaverResolveVisitor(@NonNull ASSaver saver) {
        super(saver);
    }

    @Override
    public Object visitClass(@NonNull Class object) {
        List<Type> superClasses = object.getSuperClass();
        int i = 0;
        while (i < superClasses.size()) {
            Type referredClass = superClasses.get(i);
            if (referredClass != null) {
                Type resolvedClass = ((ASSaver)this.context).resolveType(referredClass);
                superClasses.set(i, resolvedClass);
            }
            ++i;
        }
        return super.visitClass(object);
    }

    @Override
    public Object visitCollectionType(@NonNull CollectionType object) {
        Type referredType = (Type)DomainUtil.nonNullModel((Object)object.getElementType());
        Type resolvedType = ((ASSaver)this.context).resolveType(referredType);
        if (resolvedType != referredType) {
            object.setElementType(resolvedType);
        }
        return super.visitCollectionType(object);
    }

    @Override
    public Object visitLambdaType(@NonNull LambdaType object) {
        Type referredType = (Type)DomainUtil.nonNullModel((Object)object.getContextType());
        Type resolvedType = ((ASSaver)this.context).resolveType(referredType);
        object.setContextType(resolvedType);
        referredType = (Type)DomainUtil.nonNullModel((Object)object.getResultType());
        resolvedType = ((ASSaver)this.context).resolveType(referredType);
        object.setResultType(resolvedType);
        List<Type> parameterTypes = object.getParameterType();
        int i = 0;
        while (i < parameterTypes.size()) {
            referredType = parameterTypes.get(i);
            if (referredType != null) {
                resolvedType = ((ASSaver)this.context).resolveType(referredType);
                parameterTypes.set(i, resolvedType);
            }
            ++i;
        }
        return super.visitLambdaType(object);
    }

    @Override
    public Object visitLoopExp(@NonNull LoopExp object) {
        Iteration referredIteration = (Iteration)DomainUtil.nonNullModel((Object)object.getReferredIteration());
        Iteration resolvedIteration = ((ASSaver)this.context).resolveOperation(referredIteration);
        object.setReferredIteration(resolvedIteration);
        return super.visitLoopExp(object);
    }

    @Override
    public Object visitMetaclass(@NonNull Metaclass<?> object) {
        Type referredType = (Type)DomainUtil.nonNullModel((Object)object.getInstanceType());
        Type resolvedType = ((ASSaver)this.context).resolveType(referredType);
        object.setInstanceType(resolvedType);
        return super.visitMetaclass(object);
    }

    @Override
    public Object visitOperationCallExp(@NonNull OperationCallExp object) {
        Operation referredOperation = (Operation)DomainUtil.nonNullModel((Object)object.getReferredOperation());
        Operation resolvedOperation = ((ASSaver)this.context).resolveOperation(referredOperation);
        object.setReferredOperation(resolvedOperation);
        return super.visitOperationCallExp(object);
    }

    @Override
    public Object visitTemplateParameterSubstitution(@NonNull TemplateParameterSubstitution object) {
        Type referredType = (Type)DomainUtil.nonNullModel((Object)((Type)object.getActual()));
        Type resolvedType = ((ASSaver)this.context).resolveType(referredType);
        object.setActual(resolvedType);
        return null;
    }

    @Override
    public Object visitTypeTemplateParameter(@NonNull TypeTemplateParameter object) {
        List<Type> constrainingTypes = object.getConstrainingType();
        int i = 0;
        while (i < constrainingTypes.size()) {
            Type referredType = constrainingTypes.get(i);
            if (referredType != null) {
                Type resolvedType = ((ASSaver)this.context).resolveType(referredType);
                constrainingTypes.set(i, resolvedType);
            }
            ++i;
        }
        return null;
    }

    @Override
    public Object visitType(@NonNull Type object) {
        return null;
    }

    @Override
    public Object visitTypedElement(@NonNull TypedElement object) {
        Type referredType = (Type)DomainUtil.nonNullEMF((Object)object.getType());
        Type resolvedType = ((ASSaver)this.context).resolveType(referredType);
        object.setType(resolvedType);
        return null;
    }

    @Override
    public Object visiting(@NonNull Visitable visitable) {
        throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for PivotSaver Resolve pass");
    }
}

