/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.utilities;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.resource.ASResource;
import org.eclipse.ocl.examples.pivot.resource.ASResourceFactory;
import org.eclipse.ocl.examples.pivot.resource.ASResourceFactoryRegistry;
import org.eclipse.ocl.examples.pivot.utilities.AS2Moniker;
import org.eclipse.ocl.examples.pivot.utilities.AS2MonikerVisitor;
import org.eclipse.ocl.examples.pivot.utilities.AS2XMIidVisitor;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AS2XMIid {
    @NonNull
    protected final Map<String, String> moniker2id;

    @NonNull
    public static AS2XMIid load(@NonNull URI uri) {
        HashMap<String, String> moniker2id = new HashMap<String, String>();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        ASResourceFactoryRegistry.INSTANCE.configureResourceSet((ResourceSet)resourceSet);
        try {
            EList eAdapters;
            AS2MonikerVisitor monikerVisitor;
            Resource resource = resourceSet.getResource(uri, true);
            if (resource instanceof XMLResource && (monikerVisitor = PivotUtil.getAdapter(AS2MonikerVisitor.class, (List<Adapter>)(eAdapters = resource.eAdapters()))) != null) {
                XMLResource xmlResource = (XMLResource)resource;
                TreeIterator tit = xmlResource.getAllContents();
                while (tit.hasNext()) {
                    Object moniker;
                    Element element;
                    String oldID;
                    EObject eObject = (EObject)tit.next();
                    if (!(eObject instanceof Element) || (oldID = xmlResource.getID((EObject)(element = (Element)eObject))) == null || !((moniker = element.accept(monikerVisitor)) instanceof String)) continue;
                    moniker2id.put((String)moniker, oldID);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new AS2XMIid(moniker2id);
    }

    public AS2XMIid() {
        this.moniker2id = new HashMap<String, String>();
    }

    protected AS2XMIid(@NonNull Map<String, String> moniker2id) {
        this.moniker2id = moniker2id;
    }

    public void assignIds(@NonNull ASResource asResource, @Nullable Map<?, ?> options) {
        StringBuilder s = null;
        HashMap<String, Element> allIds = new HashMap<String, Element>();
        ASResourceFactory resourceFactory = asResource.getASResourceFactory();
        Object optionInternalUUIDs = options != null ? (Object)options.get("INTERNAL_UUIDS") : null;
        boolean internalUUIDs = optionInternalUUIDs != null && Boolean.valueOf(optionInternalUUIDs.toString()) != false;
        TreeIterator tit = asResource.getAllContents();
        while (tit.hasNext()) {
            EObject eObject = (EObject)tit.next();
            if (!(eObject instanceof Element)) continue;
            Element element = (Element)eObject;
            AS2XMIidVisitor idVisitor = resourceFactory.createAS2XMIidVisitor(this);
            String id = asResource.getID(element);
            if (id == null) {
                id = idVisitor.getID(element, internalUUIDs);
            }
            if (id == null) continue;
            assert (id.length() > 0) : "Zero length id for '" + element.eClass().getName() + "'";
            EObject oldElement = allIds.put(id, element);
            if (oldElement != null) {
                if (s == null) {
                    s = new StringBuilder();
                    s.append("Duplicate xmi:id values generated for ");
                }
                s.append("\n '" + id + "' for '" + element.eClass().getName() + "'");
            }
            asResource.setID(element, id);
        }
        if (s != null) {
            throw new IllegalStateException(s.toString());
        }
    }

    public void assignIds(@NonNull ResourceSet asResourceSet, @Nullable Map<?, ?> options) {
        for (Resource resource : asResourceSet.getResources()) {
            if (!(resource instanceof ASResource)) continue;
            this.assignIds((ASResource)resource, options);
        }
        MetaModelManager metaModelManager = PivotUtil.findMetaModelManager(asResourceSet);
        if (metaModelManager != null) {
            metaModelManager.assignLibraryIds(this, options);
        }
    }

    public String getID(@NonNull Element element, boolean internalUUIDs) {
        String moniker = AS2Moniker.toString(element);
        String id = this.moniker2id.get(moniker);
        if (id == null && internalUUIDs) {
            id = EcoreUtil.generateUUID();
        }
        return id;
    }
}

