/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.uml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.Unlimited;
import org.eclipse.ocl.examples.domain.values.UnlimitedValue;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.pivot.BooleanLiteralExp;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.EnumLiteralExp;
import org.eclipse.ocl.examples.pivot.Enumeration;
import org.eclipse.ocl.examples.pivot.EnumerationLiteral;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.IntegerLiteralExp;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.NullLiteralExp;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.PrimitiveType;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.RealLiteralExp;
import org.eclipse.ocl.examples.pivot.Region;
import org.eclipse.ocl.examples.pivot.State;
import org.eclipse.ocl.examples.pivot.StringLiteralExp;
import org.eclipse.ocl.examples.pivot.Transition;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.examples.pivot.Vertex;
import org.eclipse.ocl.examples.pivot.VoidType;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.uml.UML2Pivot;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralNull;
import org.eclipse.uml2.uml.LiteralReal;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UML2PivotUseSwitch
extends UMLSwitch<Object> {
    private static final Logger logger = Logger.getLogger(UML2PivotUseSwitch.class);
    @NonNull
    protected final UML2Pivot converter;
    @NonNull
    protected final MetaModelManager metaModelManager;
    private Set<EClass> doneWarnings = null;

    public UML2PivotUseSwitch(@NonNull UML2Pivot converter) {
        this.converter = converter;
        this.metaModelManager = converter.getMetaModelManager();
    }

    public Class caseClass(org.eclipse.uml2.uml.Class umlClass) {
        assert (umlClass != null);
        Class pivotElement = this.converter.getCreated(Class.class, (EObject)umlClass);
        if (pivotElement != null) {
            EList invariants = umlClass.getOwnedRules();
            this.doSwitchAll(Constraint.class, pivotElement.getOwnedInvariant(), (List<? extends EObject>)invariants);
            this.copyConstraints(pivotElement, (org.eclipse.uml2.uml.Namespace)umlClass, (List<org.eclipse.uml2.uml.Constraint>)invariants);
        }
        return pivotElement;
    }

    public Object caseClassifier(Classifier umlClassifier) {
        assert (umlClassifier != null);
        Class pivotElement = this.converter.getCreated(Class.class, (EObject)umlClassifier);
        if (pivotElement != null) {
            EList invariants = umlClassifier.getOwnedRules();
            this.doSwitchAll(Constraint.class, pivotElement.getOwnedInvariant(), (List<? extends EObject>)invariants);
            this.copyConstraints(pivotElement, (org.eclipse.uml2.uml.Namespace)umlClassifier, (List<org.eclipse.uml2.uml.Constraint>)invariants);
        }
        return umlClassifier;
    }

    public Constraint caseConstraint(org.eclipse.uml2.uml.Constraint umlConstraint) {
        assert (umlConstraint != null);
        Constraint pivotElement = this.converter.refreshNamedElement(Constraint.class, PivotPackage.Literals.CONSTRAINT, (org.eclipse.uml2.uml.NamedElement)umlConstraint);
        ValueSpecification umlSpecification = umlConstraint.getSpecification();
        Object pivotSpecification = umlSpecification != null ? this.doSwitch((EObject)umlSpecification) : null;
        pivotElement.setSpecification((OpaqueExpression)pivotSpecification);
        this.copyNamedElement(pivotElement, (org.eclipse.uml2.uml.NamedElement)umlConstraint);
        this.doSwitchAll(Element.class, pivotElement.getConstrainedElement(), (List<? extends EObject>)umlConstraint.getConstrainedElements());
        return pivotElement;
    }

    public Object caseInstanceValue(InstanceValue umlInstanceValue) {
        assert (umlInstanceValue != null);
        InstanceSpecification umlInstance = umlInstanceValue.getInstance();
        if (umlInstance instanceof org.eclipse.uml2.uml.EnumerationLiteral) {
            EnumerationLiteral pivotEnumerationLiteral = this.converter.getCreated(EnumerationLiteral.class, (EObject)umlInstance);
            ExpressionInOCL pivotElement = this.converter.refreshNamedElement(ExpressionInOCL.class, PivotPackage.Literals.EXPRESSION_IN_OCL, (org.eclipse.uml2.uml.NamedElement)umlInstanceValue);
            OCLExpression body = pivotElement.getBodyExpression();
            if (!(body instanceof EnumLiteralExp)) {
                body = PivotFactory.eINSTANCE.createEnumLiteralExp();
                pivotElement.setBodyExpression(body);
                if (pivotEnumerationLiteral != null) {
                    Enumeration type = pivotEnumerationLiteral.getEnumeration();
                    body.setType(type);
                    pivotElement.setType(type);
                }
            }
            ((EnumLiteralExp)body).setReferredEnumLiteral(pivotEnumerationLiteral);
            this.copyNamedElement(pivotElement, (org.eclipse.uml2.uml.NamedElement)umlInstanceValue);
            return pivotElement;
        }
        this.converter.error("Unknown InstanceValue " + umlInstance.getClass() + " for UML2PivotReferenceSwitch");
        return null;
    }

    public Class caseInterface(Interface umlInterface) {
        assert (umlInterface != null);
        Class pivotElement = this.converter.getCreated(Class.class, (EObject)umlInterface);
        if (pivotElement != null) {
            EList umlGeneralizations = umlInterface.getGeneralizations();
            ArrayList<Type> newSuperTypes = new ArrayList<Type>(Math.max(1, umlGeneralizations.size()));
            for (Generalization umlGeneralization : umlGeneralizations) {
                Type pivotGeneral;
                Classifier umlGeneral = umlGeneralization.getGeneral();
                if (umlGeneral == null || newSuperTypes.contains(pivotGeneral = this.converter.getCreated(Type.class, (EObject)umlGeneral))) continue;
                newSuperTypes.add(pivotGeneral);
            }
            if (newSuperTypes.isEmpty()) {
                Class oclElementType = this.metaModelManager.getOclElementType();
                newSuperTypes.add(oclElementType);
            }
            PivotUtil.refreshList(pivotElement.getSuperClass(), newSuperTypes);
        }
        return pivotElement;
    }

    public Object caseLiteralBoolean(LiteralBoolean umlLiteral) {
        assert (umlLiteral != null);
        ExpressionInOCL pivotElement = this.converter.refreshNamedElement(ExpressionInOCL.class, PivotPackage.Literals.EXPRESSION_IN_OCL, (org.eclipse.uml2.uml.NamedElement)umlLiteral);
        OCLExpression body = pivotElement.getBodyExpression();
        if (!(body instanceof BooleanLiteralExp)) {
            body = PivotFactory.eINSTANCE.createBooleanLiteralExp();
            pivotElement.setBodyExpression(body);
            PrimitiveType type = this.metaModelManager.getBooleanType();
            body.setType(type);
            pivotElement.setType(type);
        }
        ((BooleanLiteralExp)body).setBooleanSymbol(umlLiteral.booleanValue());
        this.copyNamedElement(pivotElement, (org.eclipse.uml2.uml.NamedElement)umlLiteral);
        return pivotElement;
    }

    public Object caseLiteralInteger(LiteralInteger umlLiteral) {
        assert (umlLiteral != null);
        ExpressionInOCL pivotElement = this.converter.refreshNamedElement(ExpressionInOCL.class, PivotPackage.Literals.EXPRESSION_IN_OCL, (org.eclipse.uml2.uml.NamedElement)umlLiteral);
        OCLExpression body = pivotElement.getBodyExpression();
        if (!(body instanceof IntegerLiteralExp)) {
            body = PivotFactory.eINSTANCE.createIntegerLiteralExp();
            pivotElement.setBodyExpression(body);
            PrimitiveType type = this.metaModelManager.getIntegerType();
            body.setType(type);
            pivotElement.setType(type);
        }
        ((IntegerLiteralExp)body).setIntegerSymbol(umlLiteral.getValue());
        this.copyNamedElement(pivotElement, (org.eclipse.uml2.uml.NamedElement)umlLiteral);
        return pivotElement;
    }

    public Object caseLiteralNull(LiteralNull umlLiteral) {
        assert (umlLiteral != null);
        ExpressionInOCL pivotElement = this.converter.refreshNamedElement(ExpressionInOCL.class, PivotPackage.Literals.EXPRESSION_IN_OCL, (org.eclipse.uml2.uml.NamedElement)umlLiteral);
        OCLExpression body = pivotElement.getBodyExpression();
        if (!(body instanceof NullLiteralExp)) {
            body = PivotFactory.eINSTANCE.createNullLiteralExp();
            pivotElement.setBodyExpression(body);
            VoidType type = this.metaModelManager.getOclVoidType();
            body.setType(type);
            pivotElement.setType(type);
        }
        this.copyNamedElement(pivotElement, (org.eclipse.uml2.uml.NamedElement)umlLiteral);
        return pivotElement;
    }

    public Object caseLiteralReal(LiteralReal umlLiteral) {
        assert (umlLiteral != null);
        ExpressionInOCL pivotElement = this.converter.refreshNamedElement(ExpressionInOCL.class, PivotPackage.Literals.EXPRESSION_IN_OCL, (org.eclipse.uml2.uml.NamedElement)umlLiteral);
        OCLExpression body = pivotElement.getBodyExpression();
        if (!(body instanceof RealLiteralExp)) {
            body = PivotFactory.eINSTANCE.createRealLiteralExp();
            pivotElement.setBodyExpression(body);
            PrimitiveType type = this.metaModelManager.getRealType();
            body.setType(type);
            pivotElement.setType(type);
        }
        ((RealLiteralExp)body).setRealSymbol(umlLiteral.getValue());
        this.copyNamedElement(pivotElement, (org.eclipse.uml2.uml.NamedElement)umlLiteral);
        return pivotElement;
    }

    public Object caseLiteralString(LiteralString umlLiteral) {
        assert (umlLiteral != null);
        ExpressionInOCL pivotElement = this.converter.refreshNamedElement(ExpressionInOCL.class, PivotPackage.Literals.EXPRESSION_IN_OCL, (org.eclipse.uml2.uml.NamedElement)umlLiteral);
        OCLExpression body = pivotElement.getBodyExpression();
        if (!(body instanceof StringLiteralExp)) {
            body = PivotFactory.eINSTANCE.createStringLiteralExp();
            pivotElement.setBodyExpression(body);
            PrimitiveType type = this.metaModelManager.getStringType();
            body.setType(type);
            pivotElement.setType(type);
        }
        String umlValue = umlLiteral.getValue();
        ((StringLiteralExp)body).setStringSymbol(umlValue != null ? umlValue : "");
        this.copyNamedElement(pivotElement, (org.eclipse.uml2.uml.NamedElement)umlLiteral);
        return pivotElement;
    }

    public Object caseLiteralUnlimitedNatural(LiteralUnlimitedNatural umlLiteral) {
        assert (umlLiteral != null);
        ExpressionInOCL pivotElement = this.converter.refreshNamedElement(ExpressionInOCL.class, PivotPackage.Literals.EXPRESSION_IN_OCL, (org.eclipse.uml2.uml.NamedElement)umlLiteral);
        OCLExpression body = pivotElement.getBodyExpression();
        if (!(body instanceof UnlimitedNaturalLiteralExp)) {
            body = PivotFactory.eINSTANCE.createUnlimitedNaturalLiteralExp();
            pivotElement.setBodyExpression(body);
            PrimitiveType type = this.metaModelManager.getUnlimitedNaturalType();
            body.setType(type);
            pivotElement.setType(type);
        }
        long value = umlLiteral.getValue();
        ((UnlimitedNaturalLiteralExp)body).setUnlimitedNaturalSymbol(value >= 0L ? Long.valueOf(value) : Unlimited.INSTANCE);
        this.copyNamedElement(pivotElement, (org.eclipse.uml2.uml.NamedElement)umlLiteral);
        return pivotElement;
    }

    public OpaqueExpression caseOpaqueExpression(org.eclipse.uml2.uml.OpaqueExpression umlExpression) {
        assert (umlExpression != null);
        OpaqueExpression pivotElement = this.converter.refreshNamedElement(OpaqueExpression.class, PivotPackage.Literals.OPAQUE_EXPRESSION, (org.eclipse.uml2.uml.NamedElement)umlExpression);
        pivotElement.getBody().clear();
        pivotElement.getLanguage().clear();
        EList umlBodies = umlExpression.getBodies();
        EList umlLanguages = umlExpression.getLanguages();
        int i = 0;
        while (i < umlBodies.size()) {
            org.eclipse.uml2.uml.Operation umlOperation;
            EObject eContainerContainer;
            EObject eContainer;
            String umlLanguage;
            String asLanguage = "OCL";
            if (i < umlLanguages.size() && (umlLanguage = (String)umlLanguages.get(i)) != null && umlLanguage.length() > 0) {
                asLanguage = umlLanguage;
            }
            pivotElement.getLanguage().add(asLanguage);
            String umlBody = (String)umlBodies.get(i);
            if (umlBody != null && asLanguage.equals("OCL") && (eContainer = umlExpression.eContainer()) instanceof org.eclipse.uml2.uml.Constraint && (eContainerContainer = eContainer.eContainer()) instanceof org.eclipse.uml2.uml.Operation && (umlOperation = (org.eclipse.uml2.uml.Operation)eContainerContainer).getBodyCondition() == eContainer) {
                umlBody = PivotUtil.getBodyExpression(umlBody);
            }
            pivotElement.getBody().add(umlBody);
            ++i;
        }
        this.copyNamedElement(pivotElement, (org.eclipse.uml2.uml.NamedElement)umlExpression);
        return pivotElement;
    }

    public Operation caseOperation(org.eclipse.uml2.uml.Operation umlOperation) {
        assert (umlOperation != null);
        Operation pivotElement = this.converter.getCreated(Operation.class, (EObject)umlOperation);
        if (pivotElement != null) {
            ArrayList<org.eclipse.uml2.uml.Constraint> exclusions;
            this.doSwitchAll(Type.class, pivotElement.getRaisedException(), (List<? extends EObject>)umlOperation.getRaisedExceptions());
            this.doSwitchAll(Operation.class, pivotElement.getRedefinedOperation(), (List<? extends EObject>)umlOperation.getRedefinedOperations());
            for (Parameter umlParameter : umlOperation.getOwnedParameters()) {
                ParameterDirectionKind direction = umlParameter.getDirection();
                if (direction != ParameterDirectionKind.RETURN_LITERAL) continue;
                this.resolveMultiplicity(pivotElement, (org.eclipse.uml2.uml.TypedElement)umlParameter);
            }
            EList preconditions = umlOperation.getPreconditions();
            org.eclipse.uml2.uml.Constraint bodyCondition = umlOperation.getBodyCondition();
            EList postconditions = umlOperation.getPostconditions();
            this.doSwitchAll(Constraint.class, pivotElement.getPrecondition(), (List<? extends EObject>)preconditions);
            this.doSwitchAll(Constraint.class, pivotElement.getPostcondition(), (List<? extends EObject>)postconditions);
            Constraint constraint = bodyCondition != null ? (Constraint)this.doSwitch((EObject)bodyCondition) : null;
            OpaqueExpression specification = null;
            if (constraint != null) {
                specification = constraint.getSpecification();
                constraint.setSpecification(null);
            }
            pivotElement.setBodyExpression(specification);
            if (preconditions.size() > 0 || bodyCondition != null || postconditions.size() > 0) {
                exclusions = new ArrayList();
                exclusions.addAll((Collection<org.eclipse.uml2.uml.Constraint>)preconditions);
                if (bodyCondition != null) {
                    exclusions.add(bodyCondition);
                }
                exclusions.addAll((Collection<org.eclipse.uml2.uml.Constraint>)postconditions);
            } else {
                exclusions = Collections.emptyList();
            }
            this.copyConstraints(pivotElement, (org.eclipse.uml2.uml.Namespace)umlOperation, exclusions);
        }
        return pivotElement;
    }

    public Package casePackage(org.eclipse.uml2.uml.Package umlPackage) {
        assert (umlPackage != null);
        Package pivotElement = this.converter.getCreated(Package.class, (EObject)umlPackage);
        if (pivotElement != null) {
            this.doSwitchAll(Package.class, pivotElement.getImportedPackage(), (List<? extends EObject>)umlPackage.getImportedPackages());
            this.copyConstraints(pivotElement, (org.eclipse.uml2.uml.Namespace)umlPackage, null);
        }
        return pivotElement;
    }

    public Property caseProperty(org.eclipse.uml2.uml.Property umlProperty) {
        assert (umlProperty != null);
        Property pivotElement = this.converter.getCreated(Property.class, (EObject)umlProperty);
        if (pivotElement != null) {
            ValueSpecification umlValue;
            org.eclipse.uml2.uml.Class umlClass;
            this.resolveMultiplicity(pivotElement, (org.eclipse.uml2.uml.TypedElement)umlProperty);
            this.doSwitchAll(Property.class, pivotElement.getRedefinedProperty(), (List<? extends EObject>)umlProperty.getRedefinedProperties());
            OpaqueExpression asExpression = null;
            String propertyName = pivotElement.getName();
            if (propertyName != null && (umlClass = umlProperty.getClass_()) != null) {
                for (org.eclipse.uml2.uml.Operation umlOperation : umlClass.getOwnedOperations()) {
                    EList constrainedElement;
                    if (!propertyName.equals(umlOperation.getName()) || umlOperation.getOwnedParameters().size() != 1) continue;
                    org.eclipse.uml2.uml.Constraint bodyCondition = umlOperation.getBodyCondition();
                    if (bodyCondition == null || (constrainedElement = bodyCondition.getConstrainedElements()).size() < 2 || constrainedElement.get(0) != umlOperation || constrainedElement.get(1) != umlProperty) break;
                    asExpression = PivotFactory.eINSTANCE.createOpaqueExpression();
                    asExpression.getLanguage().add("OCL");
                    asExpression.getBody().add(String.valueOf(propertyName) + "()");
                    asExpression.setIsRequired(pivotElement.isRequired());
                    asExpression.setType(pivotElement.getType());
                    break;
                }
            }
            if (asExpression == null && (umlValue = umlProperty.getDefaultValue()) != null) {
                Type defaultValueType;
                asExpression = (OpaqueExpression)this.doSwitch((EObject)umlValue);
                Type requiredType = pivotElement.getType();
                Type type = defaultValueType = asExpression != null ? asExpression.getType() : null;
                if (requiredType != null && defaultValueType != null && !defaultValueType.conformsTo((DomainStandardLibrary)this.metaModelManager, requiredType)) {
                    this.converter.error("Incompatible '" + defaultValueType + "' initializer for " + pivotElement + " when '" + requiredType + "' required");
                }
            }
            pivotElement.setDefaultExpression(asExpression);
        }
        return pivotElement;
    }

    public Region caseRegion(org.eclipse.uml2.uml.Region umlRegion) {
        assert (umlRegion != null);
        Region pivotElement = this.converter.getCreated(Region.class, (EObject)umlRegion);
        if (pivotElement != null) {
            this.copyConstraints(pivotElement, (org.eclipse.uml2.uml.Namespace)umlRegion, null);
        }
        return pivotElement;
    }

    public State caseState(org.eclipse.uml2.uml.State umlState) {
        assert (umlState != null);
        State pivotElement = this.converter.getCreated(State.class, (EObject)umlState);
        if (pivotElement != null) {
            this.copyConstraints(pivotElement, (org.eclipse.uml2.uml.Namespace)umlState, null);
        }
        return pivotElement;
    }

    public Transition caseTransition(org.eclipse.uml2.uml.Transition umlTransition) {
        assert (umlTransition != null);
        Transition pivotElement = this.converter.getCreated(Transition.class, (EObject)umlTransition);
        if (pivotElement != null) {
            org.eclipse.uml2.uml.Vertex umlSource = umlTransition.getSource();
            org.eclipse.uml2.uml.Vertex umlTarget = umlTransition.getTarget();
            Vertex pivotSource = umlSource != null ? this.converter.getCreated(Vertex.class, (EObject)umlSource) : null;
            Vertex pivotTarget = umlTarget != null ? this.converter.getCreated(Vertex.class, (EObject)umlTarget) : null;
            pivotElement.setSource(pivotSource);
            pivotElement.setTarget(pivotTarget);
            this.copyConstraints(pivotElement, (org.eclipse.uml2.uml.Namespace)umlTransition, null);
        }
        return pivotElement;
    }

    public EObject caseTypedElement(org.eclipse.uml2.uml.TypedElement umlTypedElement) {
        assert (umlTypedElement != null);
        TypedElement pivotElement = this.converter.getCreated(TypedElement.class, (EObject)umlTypedElement);
        if (pivotElement != null) {
            assert (pivotElement.getType() != null);
            this.resolveMultiplicity(pivotElement, umlTypedElement);
        }
        return pivotElement;
    }

    protected void copyConstraints(@NonNull Namespace pivotElement, @NonNull org.eclipse.uml2.uml.Namespace umlNamespace, @Nullable List<org.eclipse.uml2.uml.Constraint> exclusions) {
        Object ownedRules = umlNamespace.getOwnedRules();
        if (exclusions != null && exclusions.size() > 0) {
            ownedRules = new ArrayList(ownedRules);
            ownedRules.removeAll(exclusions);
        }
        this.doSwitchAll(Constraint.class, pivotElement.getOwnedRule(), (List<? extends EObject>)ownedRules);
    }

    protected void copyModelElement(@NonNull Element pivotElement, @NonNull org.eclipse.uml2.uml.Element umlElement) {
        this.converter.setOriginalMapping(pivotElement, (EObject)umlElement);
    }

    protected void copyNamedElement(@NonNull NamedElement pivotElement, @NonNull org.eclipse.uml2.uml.NamedElement umlNamedElement) {
        this.copyModelElement(pivotElement, (org.eclipse.uml2.uml.Element)umlNamedElement);
        String name = umlNamedElement.getName();
        pivotElement.setName(name);
    }

    public Object doInPackageSwitch(EObject eObject) {
        int classifierID = eObject.eClass().getClassifierID();
        return this.doSwitch(classifierID, eObject);
    }

    public <T extends Element> void doSwitchAll(@NonNull java.lang.Class<T> pivotClass, Collection<T> pivotElements, List<? extends EObject> eObjects) {
        assert (pivotElements != null);
        assert (eObjects != null);
        for (EObject eObject : eObjects) {
            EClass eClass;
            UML2Pivot adapter;
            Resource eResource;
            if (eObject == null) continue;
            Object pivotElement = this.converter.getCreated(pivotClass, eObject);
            if (pivotElement == null && (eResource = eObject.eResource()) != null && (adapter = UML2Pivot.findAdapter(eResource, this.metaModelManager)) != null) {
                pivotElement = adapter.getCreated(pivotClass, eObject);
            }
            if (pivotElement == null) {
                if (!(eObject instanceof org.eclipse.uml2.uml.Constraint)) {
                    System.out.println("Use switching " + eObject);
                }
                Element doSwitchResult = (Element)this.doSwitch(eObject);
                pivotElement = doSwitchResult;
            }
            if (pivotElement != null) {
                pivotElements.add(pivotElement);
                continue;
            }
            if (this.doneWarnings == null) {
                this.doneWarnings = new HashSet<EClass>();
            }
            if (!this.doneWarnings.add(eClass = eObject.eClass())) continue;
            logger.warn((Object)("Failed to create a pivot representation of a UML '" + eClass.getName() + "'"));
        }
    }

    @Nullable
    public org.eclipse.uml2.uml.Property getOtherEnd(@NonNull List<org.eclipse.uml2.uml.Property> umlMemberEnds, @NonNull org.eclipse.uml2.uml.Property umlProperty) {
        for (org.eclipse.uml2.uml.Property umlMemberEnd : umlMemberEnds) {
            if (umlMemberEnd == umlProperty) continue;
            return umlMemberEnd;
        }
        return null;
    }

    protected void resolveMultiplicity(@NonNull TypedElement pivotElement, @NonNull org.eclipse.uml2.uml.TypedElement umlTypedElement) {
        boolean isRequired = false;
        org.eclipse.uml2.uml.Type umlType = umlTypedElement.getType();
        if (umlType != null) {
            Type pivotType = this.converter.resolveType(umlType);
            if (umlTypedElement instanceof MultiplicityElement && pivotType != null) {
                MultiplicityElement umlMultiplicity = (MultiplicityElement)umlTypedElement;
                int lower = umlMultiplicity.getLower();
                int upper = umlMultiplicity.getUpper();
                if (upper == 1) {
                    isRequired = lower == 1;
                } else {
                    isRequired = true;
                    boolean isOrdered = umlMultiplicity.isOrdered();
                    boolean isUnique = umlMultiplicity.isUnique();
                    IntegerValue lowerValue = ValuesUtil.integerValueOf((int)lower);
                    UnlimitedValue upperValue = upper == -1 ? ValuesUtil.UNLIMITED_VALUE : ValuesUtil.integerValueOf((int)upper);
                    pivotType = this.metaModelManager.getCollectionType(isOrdered, isUnique, pivotType, lowerValue, (IntegerValue)upperValue);
                }
            }
            pivotElement.setType(pivotType);
        } else {
            pivotElement.setType(this.metaModelManager.getOclVoidType());
        }
        pivotElement.setIsRequired(isRequired);
    }
}

