/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.uml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.UnlimitedValue;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Profile;
import org.eclipse.ocl.examples.pivot.ProfileApplication;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Stereotype;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeExtension;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.uml.UML2Pivot;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.util.UMLSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UML2PivotReferenceSwitch
extends UMLSwitch<Object> {
    private static final Logger logger = Logger.getLogger(UML2PivotReferenceSwitch.class);
    @NonNull
    protected final UML2Pivot converter;
    @NonNull
    protected final MetaModelManager metaModelManager;
    private Set<EClass> doneWarnings = null;

    public UML2PivotReferenceSwitch(@NonNull UML2Pivot converter) {
        this.converter = converter;
        this.metaModelManager = converter.getMetaModelManager();
    }

    public Object caseAssociation(Association umlAssociation) {
        assert (umlAssociation != null);
        EList memberEnds = umlAssociation.getMemberEnds();
        if (memberEnds.size() == 2) {
            org.eclipse.uml2.uml.Property firstEnd = (org.eclipse.uml2.uml.Property)memberEnds.get(0);
            org.eclipse.uml2.uml.Property secondEnd = (org.eclipse.uml2.uml.Property)memberEnds.get(1);
            if (firstEnd != null && secondEnd != null) {
                Property firstProperty = this.converter.getCreated(Property.class, (EObject)firstEnd);
                Property secondProperty = this.converter.getCreated(Property.class, (EObject)secondEnd);
                if (firstProperty != null && secondProperty != null) {
                    firstProperty.setOpposite(secondProperty);
                    secondProperty.setOpposite(firstProperty);
                }
            }
        }
        return this;
    }

    public Class caseClass(org.eclipse.uml2.uml.Class umlClass) {
        assert (umlClass != null);
        Class pivotElement = this.converter.getCreated(Class.class, (EObject)umlClass);
        if (pivotElement != null) {
            this.doSwitchAll(Type.class, pivotElement.getSuperClass(), (List<? extends EObject>)umlClass.getSuperClasses());
            if (pivotElement.getSuperClass().isEmpty()) {
                Class oclElementType = this.metaModelManager.getOclElementType();
                pivotElement.getSuperClass().add(oclElementType);
            }
        }
        return pivotElement;
    }

    public Object caseExtension(Extension umlExtension) {
        this.caseAssociation((Association)umlExtension);
        assert (umlExtension != null);
        TypeExtension asTypeExtension = this.converter.getCreated(TypeExtension.class, (EObject)umlExtension);
        if (asTypeExtension != null) {
            org.eclipse.uml2.uml.Class umlMetaclass = umlExtension.getMetaclass();
            org.eclipse.uml2.uml.Stereotype umlStereotype = umlExtension.getStereotype();
            if (umlMetaclass != null && umlStereotype != null) {
                Type asMetaclass = this.converter.getCreated(Type.class, (EObject)umlMetaclass);
                Stereotype asStereotype = this.converter.getCreated(Stereotype.class, (EObject)umlStereotype);
                if (asMetaclass != null && asStereotype != null) {
                    asTypeExtension.setStereotype(asStereotype);
                    asTypeExtension.setType(asMetaclass);
                    if (UML2Pivot.ADD_TYPE_EXTENSION.isActive()) {
                        UML2Pivot.ADD_TYPE_EXTENSION.println(asTypeExtension.toString());
                    }
                    this.converter.addTypeExtension(asTypeExtension);
                }
            }
        }
        return this;
    }

    public Object caseProfileApplication(org.eclipse.uml2.uml.ProfileApplication umlProfileApplication) {
        org.eclipse.uml2.uml.Profile umlProfile;
        assert (umlProfileApplication != null);
        ProfileApplication asProfileApplication = this.converter.getCreated(ProfileApplication.class, (EObject)umlProfileApplication);
        if (asProfileApplication != null && (umlProfile = umlProfileApplication.getAppliedProfile()) != null) {
            Profile asProfile = this.converter.getCreated(Profile.class, (EObject)umlProfile);
            asProfileApplication.setAppliedProfile(asProfile);
            this.converter.addProfileApplication(asProfileApplication);
        }
        return this;
    }

    public Object caseProperty(org.eclipse.uml2.uml.Property umlProperty) {
        assert (umlProperty != null);
        this.caseTypedElement((org.eclipse.uml2.uml.TypedElement)umlProperty);
        Property asProperty = this.converter.getCreated(Property.class, (EObject)umlProperty);
        if (asProperty != null) {
            EObject eContainer;
            Type asTargetType;
            org.eclipse.uml2.uml.Type umlTargetType;
            if (asProperty.getName() == null && (umlTargetType = umlProperty.getType()) != null && (asTargetType = this.converter.getCreated(Type.class, (EObject)umlTargetType)) != null) {
                asProperty.setName(asTargetType.getName());
            }
            Type pivotType = null;
            Association umlAssociation = umlProperty.getAssociation();
            if (umlAssociation != null) {
                org.eclipse.uml2.uml.Type oppositeType;
                org.eclipse.uml2.uml.Property opposite;
                if (umlProperty.getOwningAssociation() != null) {
                    asProperty.setImplicit(true);
                }
                if ((opposite = this.getOtherEnd(umlProperty)) != null && (oppositeType = opposite.getType()) != null) {
                    pivotType = this.converter.getCreated(Type.class, (EObject)oppositeType);
                }
            }
            if (pivotType == null && (eContainer = umlProperty.eContainer()) != null) {
                pivotType = this.converter.getCreated(Type.class, eContainer);
            }
            if (pivotType != null) {
                this.converter.addProperty(pivotType, asProperty);
            }
        }
        return asProperty;
    }

    public Object caseStereotype(org.eclipse.uml2.uml.Stereotype umlStereotype) {
        assert (umlStereotype != null);
        this.caseClass((org.eclipse.uml2.uml.Class)umlStereotype);
        Stereotype asStereotype = this.converter.getCreated(Stereotype.class, (EObject)umlStereotype);
        if (asStereotype != null) {
            this.converter.addStereotype(asStereotype);
        }
        return asStereotype;
    }

    public EObject caseTypedElement(org.eclipse.uml2.uml.TypedElement umlTypedElement) {
        assert (umlTypedElement != null);
        TypedElement pivotElement = this.converter.getCreated(TypedElement.class, (EObject)umlTypedElement);
        if (pivotElement != null) {
            this.resolveMultiplicity(pivotElement, umlTypedElement);
        }
        return pivotElement;
    }

    public Object doInPackageSwitch(EObject eObject) {
        int classifierID = eObject.eClass().getClassifierID();
        return this.doSwitch(classifierID, eObject);
    }

    public <T extends Element> void doSwitchAll(@NonNull java.lang.Class<T> pivotClass, Collection<T> pivotElements, List<? extends EObject> eObjects) {
        assert (pivotElements != null);
        assert (eObjects != null);
        for (EObject eObject : eObjects) {
            EClass eClass;
            UML2Pivot adapter;
            Resource eResource;
            if (eObject == null) continue;
            Object pivotElement = this.converter.getCreated(pivotClass, eObject);
            if (pivotElement == null && (eResource = eObject.eResource()) != null && (adapter = UML2Pivot.findAdapter(eResource, this.metaModelManager)) != null) {
                pivotElement = adapter.getCreated(pivotClass, eObject);
            }
            if (pivotElement == null) {
                if (!(eObject instanceof Constraint)) {
                    System.out.println("Reference switching " + eObject);
                }
                Element doSwitchResult = (Element)this.doSwitch(eObject);
                pivotElement = doSwitchResult;
            }
            if (pivotElement != null) {
                pivotElements.add(pivotElement);
                continue;
            }
            if (this.doneWarnings == null) {
                this.doneWarnings = new HashSet<EClass>();
            }
            if (!this.doneWarnings.add(eClass = eObject.eClass())) continue;
            logger.warn((Object)("Failed to create a pivot representation of a UML '" + eClass.getName() + "'"));
        }
    }

    protected org.eclipse.uml2.uml.Property getOtherEnd(@NonNull org.eclipse.uml2.uml.Property umlProperty) {
        org.eclipse.uml2.uml.Property otherEnd = umlProperty.getOtherEnd();
        if (otherEnd != null) {
            return otherEnd;
        }
        Association association = umlProperty.getAssociation();
        if (association != null) {
            ArrayList memberEnds = new ArrayList(association.getMemberEnds());
            memberEnds.remove(umlProperty);
            for (org.eclipse.uml2.uml.Property aProperty : memberEnds) {
                if (aProperty.getName().equals(umlProperty)) continue;
                return aProperty;
            }
        }
        return otherEnd;
    }

    @Nullable
    public org.eclipse.uml2.uml.Property getOtherEnd(@NonNull List<org.eclipse.uml2.uml.Property> umlMemberEnds, @NonNull org.eclipse.uml2.uml.Property umlProperty) {
        for (org.eclipse.uml2.uml.Property umlMemberEnd : umlMemberEnds) {
            if (umlMemberEnd == umlProperty) continue;
            return umlMemberEnd;
        }
        return null;
    }

    protected void resolveMultiplicity(@NonNull TypedElement pivotElement, @NonNull org.eclipse.uml2.uml.TypedElement umlTypedElement) {
        boolean isRequired = false;
        org.eclipse.uml2.uml.Type umlType = umlTypedElement.getType();
        if (umlType != null) {
            Type pivotType = this.converter.resolveType(umlType);
            if (umlTypedElement instanceof MultiplicityElement && pivotType != null) {
                MultiplicityElement umlMultiplicity = (MultiplicityElement)umlTypedElement;
                int lower = umlMultiplicity.getLower();
                int upper = umlMultiplicity.getUpper();
                if (upper == 1) {
                    isRequired = lower == 1;
                } else {
                    isRequired = true;
                    boolean isOrdered = umlMultiplicity.isOrdered();
                    boolean isUnique = umlMultiplicity.isUnique();
                    IntegerValue lowerValue = ValuesUtil.integerValueOf((int)lower);
                    UnlimitedValue upperValue = upper == -1 ? ValuesUtil.UNLIMITED_VALUE : ValuesUtil.integerValueOf((int)upper);
                    pivotType = this.metaModelManager.getCollectionType(isOrdered, isUnique, pivotType, lowerValue, (IntegerValue)upperValue);
                }
            }
            pivotElement.setType(pivotType);
        } else {
            pivotElement.setType(this.metaModelManager.getOclVoidType());
        }
        pivotElement.setIsRequired(isRequired);
    }
}

