/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.uml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Profile;
import org.eclipse.ocl.examples.pivot.Stereotype;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeExtension;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.TypeServer;
import org.eclipse.ocl.examples.pivot.uml.UML2Pivot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileAnalysis {
    @NonNull
    protected final UML2Pivot.Outer converter;
    @NonNull
    protected final MetaModelManager metaModelManager;
    @NonNull
    private final Set<Type> allExtendedMetatypes = new HashSet<Type>();
    @NonNull
    private final Set<Package> allExtendedMetapackages = new HashSet<Package>();
    @NonNull
    private final Set<Stereotype> allExtendingStereotypes = new HashSet<Stereotype>();
    @NonNull
    private final Set<Stereotype> allStereotypes = new HashSet<Stereotype>();
    @NonNull
    private final Map<Profile, Set<Stereotype>> profile2ownedStereotypes = new HashMap<Profile, Set<Stereotype>>();
    @NonNull
    private final Map<String, Type> metatypeName2metatype = new HashMap<String, Type>();
    @NonNull
    private final Map<Type, Set<Type>> metatype2superMetatypeClosure = new HashMap<Type, Set<Type>>();
    @NonNull
    private final Map<Type, Set<Type>> metatype2subMetatypeClosure = new HashMap<Type, Set<Type>>();
    @NonNull
    private final Map<Stereotype, Set<Stereotype>> stereotype2superStereotypeClosure = new HashMap<Stereotype, Set<Stereotype>>();
    @NonNull
    private final Map<Stereotype, Set<Stereotype>> stereotype2subStereotypeClosure = new HashMap<Stereotype, Set<Stereotype>>();

    public ProfileAnalysis(@NonNull UML2Pivot.Outer converter) {
        this.converter = converter;
        this.metaModelManager = converter.getMetaModelManager();
    }

    public void addStereotype(@NonNull Stereotype asStereotype) {
        this.allStereotypes.add(asStereotype);
        Package asPackage = asStereotype.getPackage();
        if (asPackage instanceof Profile) {
            Profile asProfile = (Profile)asPackage;
            Set<Stereotype> ownedStereotypes = this.profile2ownedStereotypes.get(asProfile);
            if (ownedStereotypes == null) {
                ownedStereotypes = new HashSet<Stereotype>();
                this.profile2ownedStereotypes.put(asProfile, ownedStereotypes);
            }
            ownedStereotypes.add(asStereotype);
        }
    }

    public void addTypeExtension(@NonNull TypeExtension asTypeExtension) {
        Type extendedMetatype = asTypeExtension.getType();
        Stereotype extendingStereotype = asTypeExtension.getStereotype();
        if (extendedMetatype != null && extendingStereotype != null) {
            this.allExtendedMetatypes.add(extendedMetatype);
            this.allExtendingStereotypes.add(extendingStereotype);
            Package metaPackage = extendedMetatype.getPackage();
            if (metaPackage != null) {
                this.allExtendedMetapackages.add(metaPackage);
            }
        }
    }

    public void analyze() {
        this.computeMetatypeName2metatype();
        this.computeMetatypeClosure();
        this.computeStereotypeClosure();
    }

    private void computeMetatypeName2metatype() {
        for (Package metapackage : this.allExtendedMetapackages) {
            for (Type metatype : metapackage.getOwnedType()) {
                if (metatype == null) continue;
                this.metatypeName2metatype.put(metatype.getName(), metatype);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void computeMetatypeClosure() {
        for (Package metapackage : this.allExtendedMetapackages) {
            for (Type subMetatype : metapackage.getOwnedType()) {
                if (subMetatype == null) continue;
                HashSet<Type> superMetatypeClosure = new HashSet<Type>();
                this.metatype2superMetatypeClosure.put(subMetatype, superMetatypeClosure);
                for (DomainType domainType : this.metaModelManager.getAllSuperClasses(subMetatype)) {
                    void var6_6;
                    if (domainType instanceof TypeServer) {
                        Type type = ((TypeServer)domainType).getPivotType();
                    }
                    if (!(var6_6 instanceof Type)) continue;
                    superMetatypeClosure.add((Type)var6_6);
                    Set<Type> subMetatypeClosure = this.metatype2subMetatypeClosure.get(var6_6);
                    if (subMetatypeClosure == null) {
                        subMetatypeClosure = new HashSet<Type>();
                        this.metatype2subMetatypeClosure.put((Type)var6_6, subMetatypeClosure);
                    }
                    subMetatypeClosure.add(subMetatype);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void computeStereotypeClosure() {
        for (Stereotype subStereotype : this.allStereotypes) {
            if (subStereotype == null) continue;
            HashSet<Stereotype> superStereotypeClosure = new HashSet<Stereotype>();
            this.stereotype2superStereotypeClosure.put(subStereotype, superStereotypeClosure);
            for (DomainType domainType : this.metaModelManager.getAllSuperClasses(subStereotype)) {
                void var4_4;
                if (domainType instanceof TypeServer) {
                    Type type = ((TypeServer)domainType).getPivotType();
                }
                if (!(var4_4 instanceof Stereotype)) continue;
                superStereotypeClosure.add((Stereotype)var4_4);
                Set<Stereotype> subStereotypeClosure = this.stereotype2subStereotypeClosure.get(var4_4);
                if (subStereotypeClosure == null) {
                    subStereotypeClosure = new HashSet<Stereotype>();
                    this.stereotype2subStereotypeClosure.put((Stereotype)var4_4, subStereotypeClosure);
                }
                subStereotypeClosure.add(subStereotype);
            }
        }
    }

    @NonNull
    public Map<Type, Set<TypeExtension>> computeMetatypes2typeExtensions() {
        Set<Stereotype> applicableStereotypes = this.allStereotypes;
        Map<Type, Set<TypeExtension>> extensibleMetatype2typeExtensions = this.getExtensibleMetatype2typeExtensions(applicableStereotypes);
        HashMap metatype2typeExtensions = new HashMap();
        return extensibleMetatype2typeExtensions;
    }

    @NonNull
    public Map<Type, Set<TypeExtension>> computeMetatypes2typeExtensions(@NonNull Set<Profile> appliedProfileClosure) {
        Set<Stereotype> applicableStereotypes = this.getOwnedStereotypes(appliedProfileClosure);
        Map<Type, Set<TypeExtension>> extensibleMetatype2typeExtensions = this.getExtensibleMetatype2typeExtensions(applicableStereotypes);
        HashMap<Type, Set<TypeExtension>> metatype2typeExtensions = new HashMap<Type, Set<TypeExtension>>();
        for (Type metatype : extensibleMetatype2typeExtensions.keySet()) {
            Set<Type> metatypeSubClosure;
            Set someTypeExtensions = (Set)metatype2typeExtensions.get(metatype);
            if (someTypeExtensions == null || (metatypeSubClosure = this.getSubMetatypeClosure(metatype)) == null) continue;
            for (Type subMetatype : metatypeSubClosure) {
                HashSet allTypeExtensions = (HashSet)metatype2typeExtensions.get(subMetatype);
                if (allTypeExtensions == null) {
                    allTypeExtensions = new HashSet();
                    metatype2typeExtensions.put(subMetatype, allTypeExtensions);
                }
                allTypeExtensions.addAll(someTypeExtensions);
            }
        }
        return metatype2typeExtensions;
    }

    @NonNull
    private Map<Type, Set<TypeExtension>> getExtensibleMetatype2typeExtensions(@NonNull Iterable<Stereotype> applicableStereotypes) {
        HashMap<Type, Set<TypeExtension>> extensibleMetatype2typeExtensions = new HashMap<Type, Set<TypeExtension>>();
        for (Stereotype applicableStereotype : applicableStereotypes) {
            for (TypeExtension typeExtension : applicableStereotype.getExtensionOfs()) {
                Type extensibleMetatype = typeExtension.getType();
                if (extensibleMetatype == null) continue;
                HashSet<TypeExtension> typeExtensions = (HashSet<TypeExtension>)extensibleMetatype2typeExtensions.get(extensibleMetatype);
                if (typeExtensions == null) {
                    typeExtensions = new HashSet<TypeExtension>();
                    extensibleMetatype2typeExtensions.put(extensibleMetatype, typeExtensions);
                }
                typeExtensions.add(typeExtension);
            }
        }
        return extensibleMetatype2typeExtensions;
    }

    @Nullable
    public Type getMetatype(@NonNull String packageName, @NonNull String className) {
        return this.metatypeName2metatype.get(className);
    }

    @NonNull
    private Set<Stereotype> getOwnedStereotypes(@NonNull Iterable<Profile> asProfiles) {
        HashSet<Stereotype> allOwnedStereotypes = new HashSet<Stereotype>();
        for (Profile asProfile : asProfiles) {
            Set<Stereotype> ownedStereotypes = this.profile2ownedStereotypes.get(asProfile);
            if (ownedStereotypes == null) continue;
            allOwnedStereotypes.addAll(ownedStereotypes);
        }
        return allOwnedStereotypes;
    }

    @Nullable
    private Set<Type> getSubMetatypeClosure(@NonNull Type metatype) {
        return this.metatype2subMetatypeClosure.get(metatype);
    }
}

