/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.uml;

import java.util.List;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.common.utils.StringUtils;
import org.eclipse.ocl.examples.pivot.Annotation;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.Comment;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.DataType;
import org.eclipse.ocl.examples.pivot.Detail;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Enumeration;
import org.eclipse.ocl.examples.pivot.EnumerationLiteral;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.PrimitiveType;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeTemplateParameter;
import org.eclipse.ocl.examples.pivot.TypedMultiplicityElement;
import org.eclipse.ocl.examples.pivot.uml.Pivot2UML;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ClassifierTemplateParameter;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.RedefinableTemplateSignature;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pivot2UMLDeclarationVisitor
extends AbstractExtendingVisitor<EModelElement, Pivot2UML> {
    public Pivot2UMLDeclarationVisitor(@NonNull Pivot2UML context) {
        super(context);
    }

    protected void copyClassifier(@NonNull Classifier umlClassifier, @NonNull Type pivotType) {
        this.copyNamedElement((org.eclipse.uml2.uml.NamedElement)umlClassifier, pivotType);
        TemplateSignature pivotTemplateSignature = pivotType.getOwnedTemplateSignature();
        if (pivotTemplateSignature != null) {
            umlClassifier.setOwnedTemplateSignature((org.eclipse.uml2.uml.TemplateSignature)this.safeVisit(pivotTemplateSignature));
        }
        this.safeVisitAll((List)umlClassifier.getEAnnotations(), (List<? extends Element>)pivotType.getOwnedAnnotation());
        StringBuilder s = null;
        for (Constraint pivotConstraint : pivotType.getOwnedInvariant()) {
            this.safeVisit(pivotConstraint);
            if (s == null) {
                s = new StringBuilder();
            } else {
                s.append(" ");
            }
            s.append(pivotConstraint.getName());
        }
    }

    protected void copyDataTypeOrEnum(@NonNull org.eclipse.uml2.uml.DataType umlDataType, @NonNull DataType pivotDataType) {
        this.copyClassifier((Classifier)umlDataType, pivotDataType);
    }

    protected void copyDetails(@NonNull EAnnotation umlAnnotation, @NonNull Annotation pivotAnnotation) {
        this.copyEModelElement((EModelElement)umlAnnotation, pivotAnnotation);
        this.safeVisitAll((List)umlAnnotation.getEAnnotations(), (List<? extends Element>)pivotAnnotation.getOwnedAnnotation());
        for (Detail pivotDetail : pivotAnnotation.getOwnedDetail()) {
            String name = pivotDetail.getName();
            String value = StringUtils.splice(pivotDetail.getValue(), (String)"");
            umlAnnotation.getDetails().put((Object)name, (Object)value);
        }
    }

    protected void copyEModelElement(@NonNull EModelElement umlElement, @NonNull Element pivotModelElement) {
        ((Pivot2UML)this.context).putCreated(pivotModelElement, umlElement);
    }

    protected void copyModelElement(@NonNull org.eclipse.uml2.uml.Element umlElement, @NonNull Element pivotModelElement) {
        this.copyEModelElement((EModelElement)umlElement, pivotModelElement);
        this.safeVisitAll((List)umlElement.getOwnedComments(), (List<? extends Element>)pivotModelElement.getOwnedComment());
    }

    protected void copyNamedElement(@NonNull org.eclipse.uml2.uml.NamedElement umlNamedElement, @NonNull NamedElement pivotNamedElement) {
        this.copyModelElement((org.eclipse.uml2.uml.Element)umlNamedElement, pivotNamedElement);
        umlNamedElement.setName(pivotNamedElement.getName());
        this.safeVisitAll((List)umlNamedElement.getOwnedComments(), (List<? extends Element>)pivotNamedElement.getOwnedComment());
    }

    protected void copyTypedElement(@NonNull TypedElement umlTypedElement, @NonNull TypedMultiplicityElement pivotTypedElement) {
        this.copyNamedElement((org.eclipse.uml2.uml.NamedElement)umlTypedElement, pivotTypedElement);
        ((Pivot2UML)this.context).defer(pivotTypedElement);
    }

    public <T extends EObject> void safeVisitAll(List<T> eObjects, List<? extends Element> pivotObjects) {
        for (Element element : pivotObjects) {
            EObject eObject = (EObject)this.safeVisit(element);
            if (eObject == null) continue;
            eObjects.add(eObject);
        }
    }

    @Override
    public org.eclipse.uml2.uml.Element visiting(@NonNull Visitable visitable) {
        throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for Pivot2UML Declaration pass");
    }

    @Override
    public EAnnotation visitAnnotation(@NonNull Annotation pivotAnnotation) {
        EAnnotation umlAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        this.copyDetails(umlAnnotation, pivotAnnotation);
        umlAnnotation.setSource(pivotAnnotation.getName());
        this.safeVisitAll((List)umlAnnotation.getContents(), (List<? extends Element>)pivotAnnotation.getOwnedContent());
        if (!pivotAnnotation.getReference().isEmpty()) {
            ((Pivot2UML)this.context).defer(pivotAnnotation);
        }
        return umlAnnotation;
    }

    @Override
    public Classifier visitClass(@NonNull Class pivotClass) {
        Interface umlClassifier;
        if (pivotClass.getTemplateBinding().size() > 0) {
            return null;
        }
        if (pivotClass.isInterface()) {
            Interface umlInterface = UMLFactory.eINSTANCE.createInterface();
            this.safeVisitAll((List)umlInterface.getOwnedOperations(), (List<? extends Element>)pivotClass.getOwnedOperation());
            this.safeVisitAll((List)umlInterface.getOwnedAttributes(), (List<? extends Element>)pivotClass.getOwnedAttribute());
            umlClassifier = umlInterface;
        } else {
            org.eclipse.uml2.uml.Class umlClass = UMLFactory.eINSTANCE.createClass();
            this.safeVisitAll((List)umlClass.getOwnedOperations(), (List<? extends Element>)pivotClass.getOwnedOperation());
            this.safeVisitAll((List)umlClass.getOwnedAttributes(), (List<? extends Element>)pivotClass.getOwnedAttribute());
            umlClassifier = umlClass;
        }
        this.copyClassifier((Classifier)umlClassifier, pivotClass);
        ((Pivot2UML)this.context).defer(pivotClass);
        umlClassifier.setIsAbstract(pivotClass.isAbstract());
        return umlClassifier;
    }

    @Override
    public EModelElement visitComment(@NonNull Comment pivotComment) {
        org.eclipse.uml2.uml.Comment umlComment = UMLFactory.eINSTANCE.createComment();
        umlComment.setBody(pivotComment.getBody());
        return umlComment;
    }

    @Override
    public org.eclipse.uml2.uml.Constraint visitConstraint(@NonNull Constraint pivotConstraint) {
        OpaqueExpression specification = pivotConstraint.getSpecification();
        if (specification == null) {
            return null;
        }
        String exprString = PivotUtil.getBody(specification);
        if (exprString == null) {
            return null;
        }
        return null;
    }

    @Override
    public org.eclipse.uml2.uml.DataType visitDataType(@NonNull DataType pivotDataType) {
        if (pivotDataType.getTemplateBinding().size() > 0) {
            return null;
        }
        org.eclipse.uml2.uml.DataType umlDataType = UMLFactory.eINSTANCE.createDataType();
        this.copyDataTypeOrEnum(umlDataType, pivotDataType);
        return umlDataType;
    }

    @Override
    public org.eclipse.uml2.uml.Enumeration visitEnumeration(@NonNull Enumeration pivotEnumeration) {
        if (pivotEnumeration.getTemplateBinding().size() > 0) {
            return null;
        }
        org.eclipse.uml2.uml.Enumeration umlEnumeration = UMLFactory.eINSTANCE.createEnumeration();
        this.copyDataTypeOrEnum((org.eclipse.uml2.uml.DataType)umlEnumeration, pivotEnumeration);
        this.safeVisitAll((List)umlEnumeration.getOwnedLiterals(), (List<? extends Element>)pivotEnumeration.getOwnedLiteral());
        return umlEnumeration;
    }

    @Override
    public org.eclipse.uml2.uml.EnumerationLiteral visitEnumerationLiteral(@NonNull EnumerationLiteral pivotEnumLiteral) {
        org.eclipse.uml2.uml.EnumerationLiteral umlEnumLiteral = UMLFactory.eINSTANCE.createEnumerationLiteral();
        this.copyNamedElement((org.eclipse.uml2.uml.NamedElement)umlEnumLiteral, pivotEnumLiteral);
        return umlEnumLiteral;
    }

    @Override
    public org.eclipse.uml2.uml.Operation visitOperation(@NonNull Operation pivotOperation) {
        if (pivotOperation.getTemplateBinding().size() > 0) {
            return null;
        }
        org.eclipse.uml2.uml.Operation umlOperation = UMLFactory.eINSTANCE.createOperation();
        this.copyNamedElement((org.eclipse.uml2.uml.NamedElement)umlOperation, pivotOperation);
        ((Pivot2UML)this.context).defer(pivotOperation);
        TemplateSignature pivotTemplateSignature = pivotOperation.getOwnedTemplateSignature();
        umlOperation.setOwnedTemplateSignature((org.eclipse.uml2.uml.TemplateSignature)this.safeVisit(pivotTemplateSignature));
        this.safeVisitAll((List)umlOperation.getOwnedParameters(), (List<? extends Element>)pivotOperation.getOwnedParameter());
        this.safeVisitAll((List)umlOperation.getRaisedExceptions(), (List<? extends Element>)pivotOperation.getRaisedException());
        for (Constraint pivotConstraint : pivotOperation.getOwnedRule()) {
            this.safeVisit(pivotConstraint);
        }
        return umlOperation;
    }

    @Override
    public org.eclipse.uml2.uml.Package visitPackage(@NonNull Package pivotPackage) {
        org.eclipse.uml2.uml.Package umlPackage = UMLFactory.eINSTANCE.createPackage();
        this.copyNamedElement((org.eclipse.uml2.uml.NamedElement)umlPackage, pivotPackage);
        ((Pivot2UML)this.context).defer(pivotPackage);
        this.safeVisitAll((List)umlPackage.getNestedPackages(), (List<? extends Element>)pivotPackage.getNestedPackage());
        this.safeVisitAll((List)umlPackage.getOwnedTypes(), (List<? extends Element>)pivotPackage.getOwnedType());
        return umlPackage;
    }

    @Override
    public org.eclipse.uml2.uml.Parameter visitParameter(@NonNull Parameter pivotParameter) {
        org.eclipse.uml2.uml.Parameter umlParameter = UMLFactory.eINSTANCE.createParameter();
        this.copyTypedElement((TypedElement)umlParameter, pivotParameter);
        return umlParameter;
    }

    @Override
    public org.eclipse.uml2.uml.Element visitPrimitiveType(@NonNull PrimitiveType pivotPrimitiveType) {
        if (pivotPrimitiveType.getTemplateBinding().size() > 0) {
            return null;
        }
        org.eclipse.uml2.uml.PrimitiveType umlPrimitiveType = UMLFactory.eINSTANCE.createPrimitiveType();
        this.copyDataTypeOrEnum((org.eclipse.uml2.uml.DataType)umlPrimitiveType, pivotPrimitiveType);
        return umlPrimitiveType;
    }

    @Override
    public org.eclipse.uml2.uml.Property visitProperty(@NonNull Property pivotProperty) {
        org.eclipse.uml2.uml.Property umlProperty = UMLFactory.eINSTANCE.createProperty();
        this.copyTypedElement((TypedElement)umlProperty, pivotProperty);
        umlProperty.setIsComposite(pivotProperty.isComposite());
        umlProperty.setIsReadOnly(pivotProperty.isReadOnly());
        umlProperty.setIsDerived(pivotProperty.isDerived());
        if (pivotProperty.getOpposite() != null || !pivotProperty.getKeys().isEmpty()) {
            ((Pivot2UML)this.context).defer(pivotProperty);
        }
        return umlProperty;
    }

    @Override
    public org.eclipse.uml2.uml.TemplateSignature visitTemplateSignature(@NonNull TemplateSignature pivotTemplateSignature) {
        RedefinableTemplateSignature umlTemplateSignature = UMLFactory.eINSTANCE.createRedefinableTemplateSignature();
        this.safeVisitAll((List)umlTemplateSignature.getOwnedParameters(), (List<? extends Element>)pivotTemplateSignature.getOwnedParameter());
        return umlTemplateSignature;
    }

    @Override
    public ClassifierTemplateParameter visitTypeTemplateParameter(@NonNull TypeTemplateParameter pivotTypeTemplateParameter) {
        ClassifierTemplateParameter umlTypeParameter = UMLFactory.eINSTANCE.createClassifierTemplateParameter();
        umlTypeParameter.setOwnedParameteredElement((ParameterableElement)this.safeVisit(pivotTypeTemplateParameter.getOwnedParameteredElement()));
        ((Pivot2UML)this.context).putCreated(pivotTypeTemplateParameter, (EModelElement)umlTypeParameter);
        if (!pivotTypeTemplateParameter.getConstrainingType().isEmpty()) {
            ((Pivot2UML)this.context).defer(pivotTypeTemplateParameter);
        }
        return umlTypeParameter;
    }
}

