/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.prettyprint;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.values.Unlimited;
import org.eclipse.ocl.examples.pivot.AnyType;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.LambdaType;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.PrimitiveType;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.TypedMultiplicityElement;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrinter;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrettyPrintVisitor
extends AbstractExtendingVisitor<Object, PrettyPrinter> {
    public PrettyPrintVisitor(@NonNull PrettyPrinter context) {
        super(context);
    }

    @Override
    public Object safeVisit(@Nullable Visitable element) {
        if (element == null) {
            return null;
        }
        try {
            return element.accept(this);
        }
        catch (Exception e) {
            ((PrettyPrinter)this.context).append("<<" + e.getClass().getSimpleName() + ">>");
            return null;
        }
    }

    public String toString() {
        return ((PrettyPrinter)this.context).toString();
    }

    @Override
    @Nullable
    public Object visitAnyType(@NonNull AnyType object) {
        ((PrettyPrinter)this.context).appendName(object);
        return null;
    }

    @Override
    public Object visitClass(@NonNull Class object) {
        TemplateParameter owningTemplateParameter = object.getOwningTemplateParameter();
        if (owningTemplateParameter != null) {
            return owningTemplateParameter.accept(this);
        }
        return super.visitClass(object);
    }

    @Override
    public Object visitCollectionType(@NonNull CollectionType object) {
        ((PrettyPrinter)this.context).appendName(object);
        ((PrettyPrinter)this.context).appendTemplateParameters(object);
        ((PrettyPrinter)this.context).appendTemplateBindings(object);
        Number lower = object.getLower();
        Number upper = object.getUpper();
        if (!(lower == null || upper == null || lower.longValue() == 0L && upper instanceof Unlimited)) {
            ((PrettyPrinter)this.context).appendMultiplicity(lower, upper);
        }
        return null;
    }

    @Override
    public Object visitLambdaType(@NonNull LambdaType object) {
        ((PrettyPrinter)this.context).appendName(object, ((PrettyPrinter)this.context).getRestrictedNames());
        ((PrettyPrinter)this.context).append(" ");
        ((PrettyPrinter)this.context).appendElement(object.getContextType());
        ((PrettyPrinter)this.context).append("(");
        String prefix = "";
        for (Type parameterType : object.getParameterType()) {
            ((PrettyPrinter)this.context).append(prefix);
            ((PrettyPrinter)this.context).appendElement(parameterType);
            prefix = ",";
        }
        ((PrettyPrinter)this.context).append(") : ");
        ((PrettyPrinter)this.context).appendElement(object.getResultType());
        return null;
    }

    @Override
    public Object visitNamedElement(@NonNull NamedElement object) {
        if (((PrettyPrinter)this.context).showNames()) {
            ((PrettyPrinter)this.context).appendParent(((PrettyPrinter)this.context).getScope(), object, "::");
        }
        ((PrettyPrinter)this.context).appendName(object, ((PrettyPrinter)this.context).getReservedNames());
        return null;
    }

    @Override
    public Object visitOpaqueExpression(@NonNull OpaqueExpression object) {
        ((PrettyPrinter)this.context).append(PivotUtil.getBody(object));
        return null;
    }

    @Override
    public Object visitOperation(@NonNull Operation object) {
        if (((PrettyPrinter)this.context).showNames()) {
            ((PrettyPrinter)this.context).appendParent(((PrettyPrinter)this.context).getScope(), object, "::");
            ((PrettyPrinter)this.context).appendName(object);
        } else {
            ((PrettyPrinter)this.context).appendName(object, ((PrettyPrinter)this.context).getReservedNames());
        }
        ((PrettyPrinter)this.context).appendTemplateParameters(object);
        ((PrettyPrinter)this.context).appendTemplateBindings(object);
        if (((PrettyPrinter)this.context).showNames()) {
            ((PrettyPrinter)this.context).appendParameters(object, true);
            Type type = object.getType();
            if (type != null) {
                ((PrettyPrinter)this.context).append(" : ");
                ((PrettyPrinter)this.context).appendTypedMultiplicity(object);
            }
        } else {
            ((PrettyPrinter)this.context).append("(");
            String prefix = "";
            if (object instanceof Iteration) {
                Iteration iteration = (Iteration)object;
                for (Parameter parameter : iteration.getOwnedIterator()) {
                    ((PrettyPrinter)this.context).append(prefix);
                    ((PrettyPrinter)this.context).appendTypedMultiplicity(parameter);
                    prefix = ",";
                }
                if (iteration.getOwnedAccumulator().size() > 0) {
                    prefix = ";";
                    for (Parameter parameter : iteration.getOwnedAccumulator()) {
                        ((PrettyPrinter)this.context).append(prefix);
                        ((PrettyPrinter)this.context).appendTypedMultiplicity(parameter);
                        prefix = ",";
                    }
                }
                prefix = "|";
            }
            for (Parameter parameter : object.getOwnedParameter()) {
                ((PrettyPrinter)this.context).append(prefix);
                ((PrettyPrinter)this.context).appendTypedMultiplicity(parameter);
                prefix = ",";
            }
            ((PrettyPrinter)this.context).append(")");
        }
        return null;
    }

    @Override
    public Object visitPrimitiveType(@NonNull PrimitiveType object) {
        ((PrettyPrinter)this.context).appendName(object);
        return null;
    }

    @Override
    public Object visitTemplateParameter(@NonNull TemplateParameter object) {
        if (((PrettyPrinter)this.context).showNames()) {
            ((PrettyPrinter)this.context).appendName((NamedElement)((Object)object.getParameteredElement()));
        } else {
            ((PrettyPrinter)this.context).appendName((NamedElement)((Object)object.getParameteredElement()), ((PrettyPrinter)this.context).getRestrictedNames());
        }
        return null;
    }

    @Override
    public Object visitTupleType(@NonNull TupleType object) {
        if (((PrettyPrinter)this.context).showNames()) {
            ((PrettyPrinter)this.context).appendParent(((PrettyPrinter)this.context).getScope(), object, "::");
        }
        ((PrettyPrinter)this.context).appendName(object);
        List<Property> tupleParts = object.getOwnedAttribute();
        if (!tupleParts.isEmpty()) {
            ((PrettyPrinter)this.context).append("(");
            String prefix = "";
            for (Property tuplePart : tupleParts) {
                ((PrettyPrinter)this.context).append(prefix);
                if (((PrettyPrinter)this.context).showNames()) {
                    ((PrettyPrinter)this.context).appendElement(tuplePart);
                } else {
                    ((PrettyPrinter)this.context).appendName(tuplePart, ((PrettyPrinter)this.context).getRestrictedNames());
                    ((PrettyPrinter)this.context).append(" : ");
                    ((PrettyPrinter)this.context).appendElement(tuplePart.getType());
                }
                prefix = ", ";
            }
            ((PrettyPrinter)this.context).append(")");
        }
        return null;
    }

    @Override
    public Object visitType(@NonNull Type object) {
        if (((PrettyPrinter)this.context).showNames()) {
            ((PrettyPrinter)this.context).appendParent(((PrettyPrinter)this.context).getScope(), object, "::");
        }
        ((PrettyPrinter)this.context).appendName(object);
        ((PrettyPrinter)this.context).appendTemplateParameters(object);
        ((PrettyPrinter)this.context).appendTemplateBindings(object);
        return null;
    }

    @Override
    public Object visitTypedElement(@NonNull TypedElement object) {
        if (((PrettyPrinter)this.context).showNames()) {
            ((PrettyPrinter)this.context).appendParent(((PrettyPrinter)this.context).getScope(), object, "::");
            ((PrettyPrinter)this.context).appendName(object);
            ((PrettyPrinter)this.context).append(" : ");
        }
        ((PrettyPrinter)this.context).appendElement(object.getType());
        return null;
    }

    @Override
    public Object visitTypedMultiplicityElement(@NonNull TypedMultiplicityElement object) {
        if (((PrettyPrinter)this.context).showNames()) {
            ((PrettyPrinter)this.context).appendParent(((PrettyPrinter)this.context).getScope(), object, "::");
            ((PrettyPrinter)this.context).appendName(object);
            ((PrettyPrinter)this.context).append(" : ");
        }
        ((PrettyPrinter)this.context).appendTypedMultiplicity(object);
        return null;
    }

    @Override
    public String visiting(@NonNull Visitable visitable) {
        return visitable.getClass().getName();
    }
}

