/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.library;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainCallExp;
import org.eclipse.ocl.examples.domain.elements.DomainExpression;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.AbstractOperation;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;

public class EInvokeOperation
extends AbstractOperation {
    @NonNull
    protected final EOperation eOperation;

    public EInvokeOperation(@NonNull EOperation eOperation) {
        this.eOperation = eOperation;
        EClassifier eType = eOperation.getEType();
        if (eType == null) {
            throw new IllegalArgumentException("Non-query EOperation");
        }
    }

    @Nullable
    public Object dispatch(@NonNull DomainEvaluator evaluator, @NonNull DomainCallExp callExp, @Nullable Object sourceValue) {
        TypeId typeId = callExp.getTypeId();
        List arguments = callExp.getArgument();
        if (arguments.size() == 0) {
            return this.evaluate(evaluator, typeId, sourceValue, new Object[0]);
        }
        DomainExpression argument0 = (DomainExpression)arguments.get(0);
        assert (argument0 != null);
        Object firstArgument = evaluator.evaluate(argument0);
        if (arguments.size() == 1) {
            return this.evaluate(evaluator, typeId, sourceValue, firstArgument);
        }
        DomainExpression argument1 = (DomainExpression)arguments.get(1);
        assert (argument1 != null);
        Object secondArgument = evaluator.evaluate(argument1);
        if (arguments.size() == 2) {
            return this.evaluate(evaluator, typeId, sourceValue, firstArgument, secondArgument);
        }
        Object[] argumentValues = new Object[arguments.size()];
        argumentValues[0] = firstArgument;
        argumentValues[1] = secondArgument;
        int i = 2;
        while (i < arguments.size()) {
            DomainExpression argument = (DomainExpression)arguments.get(i);
            assert (argument != null);
            argumentValues[i] = evaluator.evaluate(argument);
            ++i;
        }
        return this.evaluate(evaluator, typeId, sourceValue, argumentValues);
    }

    @Nullable
    public Object evaluate(@NonNull DomainEvaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue, Object ... argumentValues) {
        EObject eObject = EInvokeOperation.asNavigableObject((Object)sourceValue, (Object)this.eOperation);
        EList arguments = evaluator.getIdResolver().unboxedValuesOfEach(argumentValues);
        try {
            Object eResult = eObject.eInvoke(this.eOperation, arguments);
            return this.getResultValue(evaluator, returnTypeId, eResult);
        }
        catch (InvocationTargetException e) {
            return EInvokeOperation.createInvalidValue((Exception)e);
        }
    }

    @Nullable
    protected Object getResultValue(@NonNull DomainEvaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object eResult) {
        if (returnTypeId instanceof CollectionTypeId) {
            if (eResult instanceof Iterable) {
                return evaluator.getIdResolver().createCollectionOfAll((CollectionTypeId)returnTypeId, (Iterable)eResult);
            }
            throw new InvalidValueException("Non-iterable result", new Object[0]);
        }
        if (eResult != null) {
            EClassifier eType = this.eOperation.getEType();
            return evaluator.getIdResolver().boxedValueOf(eResult, eType);
        }
        return null;
    }
}

