/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.library;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainCallExp;
import org.eclipse.ocl.examples.domain.elements.DomainExpression;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.library.AbstractOperation;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitorImpl;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

public class ConstrainedOperation
extends AbstractOperation {
    @NonNull
    protected final ExpressionInOCL expressionInOCL;

    public ConstrainedOperation(@NonNull ExpressionInOCL expressionInOCL) {
        this.expressionInOCL = expressionInOCL;
    }

    @Nullable
    public Object dispatch(@NonNull DomainEvaluator evaluator, @NonNull DomainCallExp callExp, @Nullable Object sourceValue) {
        List arguments = callExp.getArgument();
        Object[] argumentValues = new Object[arguments.size()];
        int i = 0;
        while (i < arguments.size()) {
            DomainExpression argument = (DomainExpression)arguments.get(i);
            assert (argument != null);
            argumentValues[i] = evaluator.evaluate(argument);
            ++i;
        }
        return this.evaluate(evaluator, callExp, sourceValue, argumentValues);
    }

    @Nullable
    private Object evaluate(@NonNull DomainEvaluator evaluator, @NonNull DomainCallExp callExp, @Nullable Object sourceValue, Object ... argumentValues) {
        PivotUtil.checkExpression(this.expressionInOCL);
        EvaluationVisitor evaluationVisitor = (EvaluationVisitor)evaluator;
        EvaluationVisitor nestedVisitor = evaluationVisitor instanceof EvaluationVisitorImpl ? ((EvaluationVisitorImpl)evaluationVisitor).createNestedUndecoratedEvaluator(this.expressionInOCL) : evaluationVisitor.createNestedEvaluator();
        EvaluationEnvironment nestedEvaluationEnvironment = nestedVisitor.getEvaluationEnvironment();
        nestedEvaluationEnvironment.add((DomainTypedElement)DomainUtil.nonNullModel((Object)this.expressionInOCL.getContextVariable()), sourceValue);
        List<Variable> parameters = this.expressionInOCL.getParameterVariable();
        if (!parameters.isEmpty()) {
            int i = 0;
            while (i < parameters.size()) {
                Object value = argumentValues[i];
                nestedEvaluationEnvironment.add((DomainTypedElement)DomainUtil.nonNullModel((Object)parameters.get(i)), value);
                ++i;
            }
        }
        try {
            Object object = nestedVisitor.evaluate(this.expressionInOCL);
            return object;
        }
        finally {
            nestedVisitor.dispose();
        }
    }
}

