/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.internal.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.elements.DomainMetaclass;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.library.classifier.OclTypeConformsToOperation;
import org.eclipse.ocl.examples.pivot.DataType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.PivotTables;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.PropertyCallExp;
import org.eclipse.ocl.examples.pivot.ReferringElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.internal.impl.NavigationCallExpImpl;
import org.eclipse.ocl.examples.pivot.manager.TemplateSpecialisation;
import org.eclipse.ocl.examples.pivot.util.Visitor;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyCallExpImpl
extends NavigationCallExpImpl
implements PropertyCallExp {
    protected Property referredProperty;

    protected PropertyCallExpImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return PivotPackage.Literals.PROPERTY_CALL_EXP;
    }

    @Override
    public Property getReferredProperty() {
        if (this.referredProperty != null && this.referredProperty.eIsProxy()) {
            InternalEObject oldReferredProperty = (InternalEObject)this.referredProperty;
            this.referredProperty = (Property)this.eResolveProxy(oldReferredProperty);
            if (this.referredProperty != oldReferredProperty && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 12, (Object)oldReferredProperty, (Object)this.referredProperty));
            }
        }
        return this.referredProperty;
    }

    public Property basicGetReferredProperty() {
        return this.referredProperty;
    }

    @Override
    public void setReferredProperty(Property newReferredProperty) {
        Property oldReferredProperty = this.referredProperty;
        this.referredProperty = newReferredProperty;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldReferredProperty, (Object)this.referredProperty));
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getExtension();
            }
            case 1: {
                return this.getOwnedAnnotation();
            }
            case 2: {
                return this.getOwnedComment();
            }
            case 3: {
                return this.isStatic();
            }
            case 4: {
                return this.getName();
            }
            case 5: {
                return this.isRequired();
            }
            case 6: {
                if (resolve) {
                    return this.getType();
                }
                return this.basicGetType();
            }
            case 7: {
                return this.isImplicit();
            }
            case 8: {
                return this.getSource();
            }
            case 9: {
                return this.isPre();
            }
            case 10: {
                if (resolve) {
                    return this.getNavigationSource();
                }
                return this.basicGetNavigationSource();
            }
            case 11: {
                return this.getQualifier();
            }
            case 12: {
                if (resolve) {
                    return this.getReferredProperty();
                }
                return this.basicGetReferredProperty();
            }
        }
        return this.eDynamicGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getExtension().clear();
                this.getExtension().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getOwnedAnnotation().clear();
                this.getOwnedAnnotation().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getOwnedComment().clear();
                this.getOwnedComment().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.setIsStatic((Boolean)newValue);
                return;
            }
            case 4: {
                this.setName((String)newValue);
                return;
            }
            case 5: {
                this.setIsRequired((Boolean)newValue);
                return;
            }
            case 6: {
                this.setType((Type)newValue);
                return;
            }
            case 7: {
                this.setImplicit((Boolean)newValue);
                return;
            }
            case 8: {
                this.setSource((OCLExpression)newValue);
                return;
            }
            case 9: {
                this.setIsPre((Boolean)newValue);
                return;
            }
            case 10: {
                this.setNavigationSource((Property)newValue);
                return;
            }
            case 11: {
                this.getQualifier().clear();
                this.getQualifier().addAll((Collection)newValue);
                return;
            }
            case 12: {
                this.setReferredProperty((Property)newValue);
                return;
            }
        }
        this.eDynamicSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getExtension().clear();
                return;
            }
            case 1: {
                this.getOwnedAnnotation().clear();
                return;
            }
            case 2: {
                this.getOwnedComment().clear();
                return;
            }
            case 3: {
                this.setIsStatic(false);
                return;
            }
            case 4: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 5: {
                this.setIsRequired(true);
                return;
            }
            case 6: {
                this.setType(null);
                return;
            }
            case 7: {
                this.setImplicit(false);
                return;
            }
            case 8: {
                this.setSource(null);
                return;
            }
            case 9: {
                this.setIsPre(false);
                return;
            }
            case 10: {
                this.setNavigationSource(null);
                return;
            }
            case 11: {
                this.getQualifier().clear();
                return;
            }
            case 12: {
                this.setReferredProperty(null);
                return;
            }
        }
        this.eDynamicUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.extension != null && !this.extension.isEmpty();
            }
            case 1: {
                return this.ownedAnnotation != null && !this.ownedAnnotation.isEmpty();
            }
            case 2: {
                return this.ownedComment != null && !this.ownedComment.isEmpty();
            }
            case 3: {
                return (this.eFlags & 0x100) != 0;
            }
            case 4: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 5: {
                return (this.eFlags & 0x200) == 0;
            }
            case 6: {
                return this.type != null;
            }
            case 7: {
                return (this.eFlags & 0x400) != 0;
            }
            case 8: {
                return this.source != null;
            }
            case 9: {
                return (this.eFlags & 0x800) != 0;
            }
            case 10: {
                return this.navigationSource != null;
            }
            case 11: {
                return this.qualifier != null && !this.qualifier.isEmpty();
            }
            case 12: {
                return this.referredProperty != null;
            }
        }
        return this.eDynamicIsSet(featureID);
    }

    public int eDerivedOperationID(int baseOperationID, Class<?> baseClass) {
        if (baseClass == ReferringElement.class) {
            switch (baseOperationID) {
                case 0: {
                    return 2;
                }
            }
            return -1;
        }
        return super.eDerivedOperationID(baseOperationID, baseClass);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.allOwnedElements();
            }
            case 1: {
                return this.getValue((Type)arguments.get(0), (String)arguments.get(1));
            }
            case 2: {
                return this.getReferredElement();
            }
            case 3: {
                return this.validateCompatibleResultType((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 4: {
                return this.validateNonStaticSourceTypeIsConformant((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 5: {
                return this.getSpecializedReferredPropertyOwningType();
            }
            case 6: {
                return this.getSpecializedReferredPropertyType();
            }
        }
        return this.eDynamicInvoke(operationID, arguments);
    }

    @Override
    public <R> R accept(@NonNull Visitor<R> visitor) {
        return visitor.visitPropertyCallExp(this);
    }

    @Override
    public Element getReferredElement() {
        return this.getReferredProperty();
    }

    @Override
    public DomainType getSpecializedReferredPropertyOwningType() {
        Property referredProperty = this.getReferredProperty();
        Type referencedType = referredProperty.getOwningType();
        if (!TemplateSpecialisation.needsSpecialisation(referencedType)) {
            return referencedType;
        }
        TemplateSpecialisation templateSpecialization = new TemplateSpecialisation((DomainStandardLibrary)PivotTables.LIBRARY);
        Type resultType = this.getType();
        templateSpecialization.installEquivalence(resultType, referredProperty.getType());
        return templateSpecialization.getSpecialisation(referencedType);
    }

    @Override
    public DomainType getSpecializedReferredPropertyType() {
        Type referencedType;
        Property referredProperty = this.getReferredProperty();
        Type specializedType = referencedType = referredProperty.getType();
        if (referencedType != null && TemplateSpecialisation.needsSpecialisation(referencedType)) {
            TemplateSpecialisation templateSpecialization = new TemplateSpecialisation((DomainStandardLibrary)PivotTables.LIBRARY);
            Type resultType = this.getType();
            boolean isMetaclass = resultType instanceof DomainMetaclass;
            if (isMetaclass) {
                resultType = ((DomainMetaclass)resultType).getInstanceType();
            }
            templateSpecialization.installEquivalence(resultType, referredProperty.getType());
            specializedType = templateSpecialization.getSpecialisation(referencedType);
            if (isMetaclass && specializedType != null) {
                specializedType = PivotTables.LIBRARY.getMetaclass((DomainType)specializedType);
            }
        }
        if (specializedType instanceof DataType) {
            Type behavioralType = ((DataType)specializedType).getBehavioralType();
            return behavioralType != null ? behavioralType : specializedType;
        }
        return specializedType;
    }

    @Override
    public boolean validateNonStaticSourceTypeIsConformant(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_symbol_10;
        try {
            boolean symbol_10;
            Object CAUGHT_b;
            Object CAUGHT_symbol_1;
            try {
                boolean eq;
                Object CAUGHT_self_71;
                try {
                    Property referredProperty = this.getReferredProperty();
                    if (referredProperty == null) {
                        throw new InvalidValueException("Null source for 'pivot::NamedElement::isStatic'", new Object[0]);
                    }
                    boolean self_71 = referredProperty.isStatic();
                    CAUGHT_self_71 = self_71;
                }
                catch (Exception e) {
                    CAUGHT_self_71 = ValuesUtil.createInvalidValue((Exception)e);
                }
                if (CAUGHT_self_71 instanceof InvalidValueException) {
                    throw CAUGHT_self_71;
                }
                boolean symbol_0 = CAUGHT_self_71 instanceof InvalidValueException;
                boolean symbol_1 = symbol_0 ? (Boolean)CAUGHT_self_71 : (eq = CAUGHT_self_71 == Boolean.FALSE);
                CAUGHT_symbol_1 = symbol_1;
            }
            catch (Exception e) {
                CAUGHT_symbol_1 = ValuesUtil.createInvalidValue((Exception)e);
            }
            DomainEvaluator evaluator = PivotUtil.getEvaluator(this);
            try {
                OCLExpression source = this.getSource();
                if (source == null) {
                    throw new InvalidValueException("Null source for 'pivot::TypedElement::type'", new Object[0]);
                }
                DomainType type = source.getType();
                DomainType getSpecializedReferredPropertyOwningType = this.getSpecializedReferredPropertyOwningType();
                boolean b = OclTypeConformsToOperation.INSTANCE.evaluate(evaluator, (Object)type, (Object)getSpecializedReferredPropertyOwningType);
                CAUGHT_b = b;
            }
            catch (Exception e) {
                CAUGHT_b = ValuesUtil.createInvalidValue((Exception)e);
            }
            boolean symbol_2 = CAUGHT_symbol_1 instanceof InvalidValueException;
            if (symbol_2) {
                boolean symbol_5;
                boolean symbol_3 = CAUGHT_b instanceof InvalidValueException;
                if (symbol_3) {
                    if (CAUGHT_symbol_1 instanceof InvalidValueException) {
                        throw CAUGHT_symbol_1;
                    }
                    symbol_5 = (Boolean)CAUGHT_symbol_1;
                } else {
                    boolean symbol_4;
                    if (CAUGHT_b == Boolean.TRUE) {
                        symbol_4 = ValuesUtil.TRUE_VALUE;
                    } else {
                        if (CAUGHT_symbol_1 instanceof InvalidValueException) {
                            throw CAUGHT_symbol_1;
                        }
                        symbol_4 = (Boolean)CAUGHT_symbol_1;
                    }
                    symbol_5 = symbol_4;
                }
                symbol_10 = symbol_5;
            } else {
                boolean symbol_9;
                boolean eq_0;
                if (CAUGHT_symbol_1 instanceof InvalidValueException) {
                    throw CAUGHT_symbol_1;
                }
                boolean bl = eq_0 = CAUGHT_symbol_1 == Boolean.FALSE;
                if (eq_0) {
                    symbol_9 = ValuesUtil.TRUE_VALUE;
                } else {
                    boolean symbol_8;
                    boolean symbol_6 = CAUGHT_b instanceof InvalidValueException;
                    if (symbol_6) {
                        if (CAUGHT_b instanceof InvalidValueException) {
                            throw CAUGHT_b;
                        }
                        symbol_8 = (Boolean)CAUGHT_b;
                    } else {
                        boolean symbol_7 = CAUGHT_b == Boolean.TRUE ? ValuesUtil.TRUE_VALUE.booleanValue() : ValuesUtil.FALSE_VALUE.booleanValue();
                        symbol_8 = symbol_7;
                    }
                    symbol_9 = symbol_8;
                }
                symbol_10 = symbol_9;
            }
            CAUGHT_symbol_10 = symbol_10;
        }
        catch (Exception e) {
            CAUGHT_symbol_10 = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_symbol_10 == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"PropertyCallExp", "NonStaticSourceTypeIsConformant", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 59, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateCompatibleResultType(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_eq;
        try {
            Type type = this.getType();
            DomainType getSpecializedReferredPropertyType = this.getSpecializedReferredPropertyType();
            boolean eq = type != null ? type.getTypeId() == getSpecializedReferredPropertyType.getTypeId() : ValuesUtil.throwBooleanInvalidValueException((String)"null equal input");
            CAUGHT_eq = eq;
        }
        catch (Exception e) {
            CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_eq == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"PropertyCallExp", "CompatibleResultType", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 58, message, new Object[]{this}));
        }
        return false;
    }
}

