/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.executor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainMetaclass;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.library.ecore.EcoreExecutorPackage;
import org.eclipse.ocl.examples.library.executor.ExecutableStandardLibrary;
import org.eclipse.ocl.examples.library.oclstdlib.OCLstdlibTables;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.Metaclass;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.PivotTables;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2Pivot;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManageable;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.PackageServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PivotExecutorStandardLibrary
extends ExecutableStandardLibrary
implements MetaModelManageable {
    @NonNull
    protected final MetaModelManager metaModelManager;
    private Map<DomainType, Type> typeMap = null;
    private Map<DomainPackage, Package> packageMap = null;

    public PivotExecutorStandardLibrary(EcoreExecutorPackage ... execPackages) {
        OCLstdlibTables.PACKAGE.getClass();
        this.metaModelManager = new MetaModelManager();
        this.metaModelManager.setDefaultStandardLibraryURI("http://www.eclipse.org/ocl/3.1.0/OCL.oclstdlib");
        PivotTables.PACKAGE.getClass();
    }

    @NonNull
    protected DomainMetaclass createMetaclass(@NonNull DomainType typeType) {
        DomainType metaclassType = this.getMetaclassType();
        Metaclass metaclass = PivotFactory.eINSTANCE.createMetaclass();
        metaclass.setName(metaclassType.getName());
        metaclass.setUnspecializedElement((TemplateableElement)metaclassType);
        metaclass.setInstanceType(this.getType(typeType));
        return metaclass;
    }

    @NonNull
    protected Package createPackage(@NonNull DomainPackage domainPackage) {
        Package pivotPackage = PivotFactory.eINSTANCE.createPackage();
        pivotPackage.setName(domainPackage.getName());
        pivotPackage.setNsURI(domainPackage.getNsURI());
        for (DomainType domainType : domainPackage.getOwnedType()) {
            if (domainType == null) continue;
            Type pivotType = this.createType(domainType);
            pivotPackage.getOwnedType().add(pivotType);
        }
        return pivotPackage;
    }

    @NonNull
    protected Type createType(@NonNull DomainType domainType) {
        Type pivotType = PivotFactory.eINSTANCE.createType();
        pivotType.setName(domainType.getName());
        return pivotType;
    }

    @NonNull
    public Class getEnumerationType() {
        return this.metaModelManager.getEnumerationType();
    }

    @NonNull
    public Metaclass<?> getMetaclassType() {
        return this.metaModelManager.getMetaclassType();
    }

    @NonNull
    public DomainInheritance getInheritance(@NonNull DomainType type) {
        return this.metaModelManager.getInheritance(type);
    }

    @Override
    @NonNull
    public MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }

    public DomainType getOclType(@NonNull String typeName) {
        return PivotTables.PACKAGE.getType(typeName);
    }

    protected Type getType(DomainType typeType) {
        DomainPackage domainPackage;
        Object pivotPackage;
        if (typeType instanceof DomainCollectionType) {
            DomainCollectionType domainCollectionType = (DomainCollectionType)typeType;
            return this.metaModelManager.getCollectionType(domainCollectionType.getContainerType(), domainCollectionType.getElementType(), null, null);
        }
        if (this.typeMap == null) {
            this.typeMap = new HashMap<DomainType, Type>();
        } else {
            Type type = this.typeMap.get(typeType);
            if (type != null) {
                return type;
            }
        }
        if (this.packageMap == null) {
            this.packageMap = new HashMap<DomainPackage, Package>();
        }
        if ((pivotPackage = (DomainPackage)this.packageMap.get(domainPackage = typeType.getPackage())) == null) {
            String nsURI = domainPackage.getNsURI();
            if (nsURI != null) {
                pivotPackage = this.metaModelManager.getPrimaryPackage(nsURI, new String[0]);
            }
            if (pivotPackage == null) {
                pivotPackage = this.createPackage(domainPackage);
            }
        }
        PackageServer packageServer = this.metaModelManager.getPackageServer((DomainPackage)pivotPackage);
        return packageServer.getMemberType(typeType.getName());
    }

    @NonNull
    public DomainType getType(@NonNull EClassifier eClassifier) {
        Ecore2Pivot ecore2Pivot = Ecore2Pivot.getAdapter((Resource)DomainUtil.nonNullEMF((Object)eClassifier.eResource()), this.metaModelManager);
        Type pivotType = ecore2Pivot.getCreated(Type.class, (EObject)eClassifier);
        return (DomainType)DomainUtil.nonNullState((Object)pivotType);
    }
}

