/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.ecore;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.util.EcoreSwitch;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.examples.common.utils.EcoreUtils;
import org.eclipse.ocl.examples.domain.library.LibraryFeature;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.UnlimitedValue;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.pivot.Annotation;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.DataType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.PivotConstants;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeTemplateParameter;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2Pivot;
import org.eclipse.ocl.examples.pivot.library.JavaCompareToOperation;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ecore2PivotReferenceSwitch
extends EcoreSwitch<Object> {
    private static final Logger logger = Logger.getLogger(Ecore2PivotReferenceSwitch.class);
    public static final String PROPERTY_OPPOSITE_ROLE_NAME_KEY = "Property.oppositeRoleName";
    public static final Object PROPERTY_OPPOSITE_ROLE_UNIQUE_KEY = "Property.oppositeUnique";
    public static final Object PROPERTY_OPPOSITE_ROLE_ORDERED_KEY = "Property.oppositeOrdered";
    public static final Object PROPERTY_OPPOSITE_ROLE_LOWER_KEY = "Property.oppositeLower";
    public static final Object PROPERTY_OPPOSITE_ROLE_UPPER_KEY = "Property.oppositeUpper";
    protected final Ecore2Pivot converter;
    protected final MetaModelManager metaModelManager;

    public Ecore2PivotReferenceSwitch(Ecore2Pivot converter) {
        this.converter = converter;
        this.metaModelManager = converter.getMetaModelManager();
    }

    public Object caseEAnnotation(EAnnotation eObject) {
        EAnnotation eObject2 = eObject;
        Annotation pivotElement = this.converter.getCreated(Annotation.class, (EObject)eObject2);
        if (pivotElement != null) {
            this.doSwitchAll(Element.class, pivotElement.getReference(), (List<? extends EObject>)eObject2.getReferences());
        }
        return null;
    }

    public Object caseEClass(EClass eObject) {
        EClass eObject2 = eObject;
        Class pivotElement = this.converter.getCreated(Class.class, (EObject)eObject2);
        if (pivotElement != null) {
            this.doSwitchAll(Type.class, pivotElement.getSuperClass(), (List<? extends EObject>)eObject2.getEGenericSuperTypes());
            if (pivotElement.getSuperClass().isEmpty()) {
                Class oclElementType = this.metaModelManager.getOclElementType();
                pivotElement.getSuperClass().add(oclElementType);
            }
        }
        return null;
    }

    public Object caseEDataType(EDataType eObject) {
        java.lang.Class instanceClass;
        EDataType eObject2 = eObject;
        DataType pivotElement = this.converter.getCreated(DataType.class, (EObject)eObject2);
        if (pivotElement != null && (instanceClass = eObject2.getInstanceClass()) != null) {
            try {
                Method declaredMethod = instanceClass.getDeclaredMethod("compareTo", instanceClass);
                if (declaredMethod != null) {
                    Operation operation = PivotFactory.eINSTANCE.createOperation();
                    operation.setName("compareTo");
                    operation.setImplementation((LibraryFeature)new JavaCompareToOperation(declaredMethod));
                    Parameter parameter = PivotFactory.eINSTANCE.createParameter();
                    parameter.setName("that");
                    parameter.setType(this.metaModelManager.getOclSelfType());
                    operation.getOwnedParameter().add(parameter);
                    operation.setType(this.metaModelManager.getIntegerType());
                    pivotElement.getOwnedOperation().add(operation);
                    pivotElement.getSuperClass().add(this.metaModelManager.getOclComparableType());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Object caseEEnum(EEnum eObject) {
        return null;
    }

    public Object caseEOperation(EOperation eObject) {
        EOperation eObject2 = eObject;
        if (this.converter.isInvariant(eObject2)) {
            EAnnotation redefinesAnnotation;
            Constraint pivotElement = this.converter.getCreated(Constraint.class, (EObject)eObject2);
            if (pivotElement != null && (redefinesAnnotation = eObject2.getEAnnotation("redefines")) != null) {
                for (EObject eReference : redefinesAnnotation.getReferences()) {
                    NamedElement redefinedConstraint;
                    if (eReference == null || !((redefinedConstraint = this.converter.getCreated(NamedElement.class, eReference)) instanceof Constraint)) continue;
                    pivotElement.getRedefinedConstraint().add((Constraint)redefinedConstraint);
                }
            }
            return pivotElement;
        }
        Operation pivotElement = (Operation)this.caseETypedElement((ETypedElement)eObject2);
        if (pivotElement != null) {
            EAnnotation redefinesAnnotation = eObject2.getEAnnotation("redefines");
            if (redefinesAnnotation != null) {
                for (EObject eReference : redefinesAnnotation.getReferences()) {
                    NamedElement redefinedOperation;
                    if (eReference == null || !((redefinedOperation = this.converter.getCreated(NamedElement.class, eReference)) instanceof Operation)) continue;
                    pivotElement.getRedefinedOperation().add((Operation)redefinedOperation);
                }
            }
            this.doSwitchAll(Type.class, pivotElement.getRaisedException(), (List<? extends EObject>)eObject2.getEGenericExceptions());
        }
        return pivotElement;
    }

    public Object caseEReference(EReference eObject) {
        Property pivotElement = this.caseEStructuralFeature((EStructuralFeature)eObject);
        this.doSwitchAll(Property.class, pivotElement.getKeys(), (List<? extends EObject>)eObject.getEKeys());
        Property oppositeProperty = null;
        EReference eOpposite = eObject.getEOpposite();
        if (eOpposite != null) {
            oppositeProperty = this.converter.getCreated(Property.class, (EObject)eOpposite);
        } else {
            EAnnotation oppositeRole = eObject.getEAnnotation("http://schema.omg.org/spec/MOF/2.0/emof.xml");
            if (oppositeRole != null) {
                EMap details = oppositeRole.getDetails();
                String oppositeName = (String)details.get((Object)PROPERTY_OPPOSITE_ROLE_NAME_KEY);
                if (oppositeName != null) {
                    IntegerValue upper;
                    IntegerValue lower;
                    oppositeProperty = PivotFactory.eINSTANCE.createProperty();
                    oppositeProperty.setName(oppositeName);
                    oppositeProperty.setImplicit(true);
                    Type remoteType = pivotElement.getType();
                    Type localType = PivotUtil.getOwningType(pivotElement);
                    oppositeProperty.setType(localType);
                    String uniqueValue = (String)details.get(PROPERTY_OPPOSITE_ROLE_UNIQUE_KEY);
                    String orderedValue = (String)details.get(PROPERTY_OPPOSITE_ROLE_ORDERED_KEY);
                    String lowerValue = (String)details.get(PROPERTY_OPPOSITE_ROLE_LOWER_KEY);
                    String upperValue = (String)details.get(PROPERTY_OPPOSITE_ROLE_UPPER_KEY);
                    boolean isOrdered = orderedValue != null ? Boolean.valueOf(orderedValue) : false;
                    boolean isUnique = uniqueValue != null ? Boolean.valueOf(uniqueValue) : true;
                    IntegerValue one = ValuesUtil.ONE_VALUE;
                    IntegerValue integerValue = lower = lowerValue != null ? ValuesUtil.integerValueOf((String)lowerValue) : one;
                    if (lower.isInvalid()) {
                        logger.error((Object)("Invalid " + PROPERTY_OPPOSITE_ROLE_LOWER_KEY + " " + lower));
                        lower = one;
                    }
                    IntegerValue integerValue2 = upper = upperValue != null ? ValuesUtil.integerValueOf((String)upperValue) : one;
                    if (upper.isInvalid()) {
                        logger.error((Object)("Invalid " + PROPERTY_OPPOSITE_ROLE_UPPER_KEY + " " + upper));
                        upper = one;
                    }
                    if (upper != one) {
                        oppositeProperty.setType(this.metaModelManager.getCollectionType(isOrdered, isUnique, localType, lower, upper));
                        oppositeProperty.setIsRequired(true);
                    } else {
                        oppositeProperty.setType(localType);
                        oppositeProperty.setIsRequired(lower == one);
                    }
                    remoteType.getOwnedAttribute().add(oppositeProperty);
                    oppositeProperty.setOpposite(pivotElement);
                }
            } else {
                EObject eContainer;
                EMap details;
                String oppositeName;
                oppositeRole = eObject.getEAnnotation("http://schema.omg.org/spec/MOF/2.0/emof.xml#Property.oppositeRoleName");
                if (oppositeRole != null && (oppositeName = (String)(details = oppositeRole.getDetails()).get((Object)"body")) != null && (eContainer = pivotElement.eContainer()) instanceof Type) {
                    String upperValue;
                    IntegerValue upper;
                    String lowerValue;
                    IntegerValue lower;
                    Type localType = (Type)eContainer;
                    oppositeProperty = PivotFactory.eINSTANCE.createProperty();
                    oppositeProperty.setName(oppositeName);
                    oppositeProperty.setImplicit(true);
                    Type remoteType = pivotElement.getType();
                    if (remoteType instanceof CollectionType) {
                        remoteType = ((CollectionType)remoteType).getElementType();
                    }
                    IntegerValue integerValue = lower = (lowerValue = (String)details.get((Object)"lower")) != null ? ValuesUtil.integerValueOf((String)lowerValue) : PivotConstants.ANNOTATED_IMPLICIT_OPPOSITE_LOWER_VALUE;
                    if (lower.isInvalid()) {
                        logger.error((Object)("Invalid " + PROPERTY_OPPOSITE_ROLE_LOWER_KEY + " " + lower));
                        lower = PivotConstants.ANNOTATED_IMPLICIT_OPPOSITE_LOWER_VALUE;
                    }
                    IntegerValue integerValue3 = upper = (upperValue = (String)details.get((Object)"upper")) != null ? ValuesUtil.integerValueOf((String)upperValue) : PivotConstants.ANNOTATED_IMPLICIT_OPPOSITE_UPPER_VALUE;
                    if (upper.isInvalid()) {
                        logger.error((Object)("Invalid " + PROPERTY_OPPOSITE_ROLE_UPPER_KEY + " " + upper));
                        upper = PivotConstants.ANNOTATED_IMPLICIT_OPPOSITE_UPPER_VALUE;
                    }
                    if (!upper.equals(ValuesUtil.ONE_VALUE)) {
                        String uniqueValue = (String)details.get((Object)"unique");
                        boolean isUnique = uniqueValue != null ? Boolean.valueOf(uniqueValue) : true;
                        String orderedValue = (String)details.get((Object)"ordered");
                        boolean isOrdered = orderedValue != null ? Boolean.valueOf(orderedValue) : false;
                        oppositeProperty.setType(this.metaModelManager.getCollectionType(isOrdered, isUnique, localType, lower, upper));
                        oppositeProperty.setIsRequired(true);
                    } else {
                        oppositeProperty.setType(localType);
                        oppositeProperty.setIsRequired(lower.equals(ValuesUtil.ONE_VALUE));
                    }
                    remoteType.getOwnedAttribute().add(oppositeProperty);
                    oppositeProperty.setOpposite(pivotElement);
                }
            }
        }
        if (oppositeProperty != null) {
            pivotElement.setOpposite(oppositeProperty);
        }
        return null;
    }

    public Property caseEStructuralFeature(EStructuralFeature eObject) {
        EStructuralFeature eObject2 = eObject;
        Property pivotElement = (Property)this.caseETypedElement((ETypedElement)eObject2);
        if (pivotElement != null) {
            EAnnotation eAnnotation;
            EAnnotation duplicatesAnnotation;
            EObject eContainer;
            EAnnotation redefinesAnnotation = eObject2.getEAnnotation("redefines");
            if (redefinesAnnotation != null) {
                for (EObject eReference : redefinesAnnotation.getReferences()) {
                    if (eReference == null) continue;
                    Property redefinedProperty = this.converter.getCreated(Property.class, eReference);
                    pivotElement.getRedefinedProperty().add(redefinedProperty);
                }
            }
            if ((eContainer = eObject2.eContainer()) instanceof EAnnotation && "duplicates".equals((duplicatesAnnotation = (EAnnotation)eContainer).getSource()) && (eAnnotation = duplicatesAnnotation.getEAnnotation(eObject.getName())) != null) {
                String newLowerBound = null;
                Boolean newOrdered = null;
                Boolean newUnique = null;
                String newUpperBound = null;
                Type newType = null;
                boolean changedType = false;
                EMap details = eAnnotation.getDetails();
                for (String key : details.keySet()) {
                    EClassifier eClassifier;
                    EPackage ePackage;
                    Object value = details.get((Object)key);
                    if (value == null) continue;
                    if ("lowerBound".equals(key)) {
                        newLowerBound = value.toString();
                        changedType = true;
                        continue;
                    }
                    if ("ordered".equals(key)) {
                        newOrdered = Boolean.valueOf(value.toString());
                        changedType = true;
                        continue;
                    }
                    if ("unique".equals(key)) {
                        newUnique = Boolean.valueOf(value.toString());
                        changedType = true;
                        continue;
                    }
                    if ("upperBound".equals(key)) {
                        newUpperBound = value.toString();
                        changedType = true;
                        continue;
                    }
                    if (!"eType".equals(key)) continue;
                    String[] path = value.toString().split("::");
                    EObject eRoot = EcoreUtil.getRootContainer((EObject)eObject);
                    int iSize = path.length;
                    if (iSize < 2 || !(eRoot instanceof EPackage) || !path[0].equals((ePackage = (EPackage)eRoot).getName())) continue;
                    int i = 1;
                    while (ePackage != null && i < iSize - 1) {
                        ePackage = (EPackage)EcoreUtils.getNamedElement((Collection)ePackage.getESubpackages(), (String)path[i]);
                        ++i;
                    }
                    if (ePackage == null || (eClassifier = (EClassifier)EcoreUtils.getNamedElement((Collection)ePackage.getEClassifiers(), (String)path[iSize - 1])) == null) continue;
                    newType = this.converter.getPivotType((EObject)eClassifier);
                    changedType = true;
                }
                if (changedType) {
                    boolean isRequired;
                    Type pivotType;
                    Type type;
                    IntegerValue oldUpperValue;
                    boolean oldUnique;
                    boolean oldOrdered;
                    IntegerValue oldLowerValue;
                    Type oldType = pivotElement.getType();
                    if (oldType instanceof CollectionType) {
                        CollectionType oldCollectionType = (CollectionType)oldType;
                        oldType = oldCollectionType.getElementType();
                        oldLowerValue = oldCollectionType.getLowerValue();
                        oldOrdered = oldCollectionType.isOrdered();
                        oldUnique = oldCollectionType.isUnique();
                        oldUpperValue = oldCollectionType.getUpperValue();
                    } else {
                        oldLowerValue = pivotElement.isRequired() ? ValuesUtil.ONE_VALUE : ValuesUtil.ZERO_VALUE;
                        oldOrdered = false;
                        oldUnique = false;
                        oldUpperValue = ValuesUtil.ONE_VALUE;
                    }
                    boolean isOrdered = newOrdered != null ? newOrdered : oldOrdered;
                    IntegerValue lowerValue = newLowerBound != null ? ValuesUtil.integerValueOf((String)newLowerBound) : oldLowerValue;
                    boolean isUnique = newUnique != null ? newUnique : oldUnique;
                    IntegerValue upperValue = newUpperBound != null ? ValuesUtil.integerValueOf((String)newUpperBound) : oldUpperValue;
                    Type type2 = type = newType != null ? newType : oldType;
                    if (type != null) {
                        pivotType = type;
                        if (upperValue.equals(ValuesUtil.ONE_VALUE)) {
                            isRequired = lowerValue.equals(ValuesUtil.ONE_VALUE);
                        } else {
                            isRequired = true;
                            pivotType = this.metaModelManager.getCollectionType(isOrdered, isUnique, pivotType, lowerValue, upperValue);
                        }
                    } else {
                        isRequired = false;
                        pivotType = this.metaModelManager.getOclVoidType();
                    }
                    pivotElement.setType(pivotType);
                    pivotElement.setIsRequired(isRequired);
                }
            }
        }
        return pivotElement;
    }

    public TypedElement caseETypedElement(ETypedElement eObject) {
        ETypedElement eObject2 = eObject;
        TypedElement pivotElement = this.converter.getCreated(TypedElement.class, (EObject)eObject2);
        if (pivotElement != null) {
            boolean isRequired;
            Type pivotType;
            EGenericType eType = eObject2.getEGenericType();
            if (eType != null) {
                pivotType = this.converter.getPivotType((EObject)eType);
                int lower = eObject.getLowerBound();
                int upper = eObject.getUpperBound();
                if (upper == 1) {
                    isRequired = lower == 1;
                } else {
                    isRequired = true;
                    boolean isOrdered = eObject.isOrdered();
                    boolean isUnique = eObject.isUnique();
                    if (pivotType != null) {
                        IntegerValue lowerValue = ValuesUtil.integerValueOf((int)lower);
                        UnlimitedValue upperValue = upper != -1 ? ValuesUtil.integerValueOf((int)upper) : ValuesUtil.UNLIMITED_VALUE;
                        pivotType = this.metaModelManager.getCollectionType(isOrdered, isUnique, pivotType, lowerValue, (IntegerValue)upperValue);
                    }
                }
            } else {
                isRequired = false;
                pivotType = this.metaModelManager.getOclVoidType();
            }
            pivotElement.setType(pivotType);
            pivotElement.setIsRequired(isRequired);
        }
        return pivotElement;
    }

    public Object caseETypeParameter(ETypeParameter eObject) {
        ETypeParameter eObject2 = eObject;
        Class pivotElement = this.converter.getCreated(Class.class, (EObject)eObject2);
        if (pivotElement != null) {
            TypeTemplateParameter typeTemplateParameter = (TypeTemplateParameter)pivotElement.getTemplateParameter();
            this.doSwitchAll(Type.class, typeTemplateParameter.getConstrainingType(), (List<? extends EObject>)eObject2.getEBounds());
        }
        return null;
    }

    public Object doInPackageSwitch(EObject eObject) {
        int classifierID = eObject.eClass().getClassifierID();
        return this.doSwitch(classifierID, eObject);
    }

    public <T extends Element> void doSwitchAll(java.lang.Class<T> pivotClass, Collection<T> pivotElements, List<? extends EObject> eObjects) {
        java.lang.Class<T> pivotClass2 = pivotClass;
        for (EObject eObject : eObjects) {
            T pivotElement;
            if (eObject == null || (pivotElement = this.converter.getPivotElement(pivotClass2, eObject)) == null) continue;
            pivotElements.add(pivotElement);
        }
    }
}

