/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.ecore;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreSwitch;
import org.eclipse.ocl.examples.pivot.PivotConstants;
import org.eclipse.ocl.examples.pivot.utilities.AliasAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ecore2Moniker
extends EcoreSwitch<Object>
implements PivotConstants {
    protected boolean fullSignature;
    private StringBuilder s = new StringBuilder();
    private List<ETypeParameter> emittedParameters = null;

    public static String toString(EModelElement eElement) {
        Ecore2Moniker moniker = new Ecore2Moniker(false);
        moniker.appendElement(eElement);
        String string = moniker.toString();
        return string;
    }

    public static String toString(EGenericType eElement) {
        Ecore2Moniker moniker = new Ecore2Moniker(false);
        moniker.appendType(eElement);
        String string = moniker.toString();
        return string;
    }

    protected Ecore2Moniker(boolean fullSignature) {
        this.fullSignature = fullSignature;
    }

    protected void append(String string) {
        this.s.append(string != null ? string : "null");
    }

    protected void appendBounds(List<? extends EGenericType> bounds) {
        String prefix = "";
        for (EGenericType eGenericType : bounds) {
            EClassifier eClassifier;
            EGenericType eUpperBound;
            this.s.append(prefix);
            prefix = "|";
            EGenericType eLowerBound = eGenericType.getELowerBound();
            if (eLowerBound != null) {
                this.s.append(" >= ");
                this.appendType(eLowerBound);
            }
            if ((eUpperBound = eGenericType.getEUpperBound()) != null) {
                this.s.append(" <= ");
                this.appendType(eUpperBound);
            }
            if ((eClassifier = eGenericType.getEClassifier()) != null) {
                this.s.append(" extends ");
                this.appendType(eGenericType);
            } else {
                assert (eGenericType.getETypeArguments().isEmpty());
                assert (eGenericType.getERawType() == null);
            }
            assert (eGenericType.getETypeParameter() == null);
        }
    }

    protected void appendElement(EModelElement eElement) {
        if (eElement != null) {
            int classifierID = eElement.eClass().getClassifierID();
            this.doSwitch(classifierID, (EObject)eElement);
        }
    }

    protected Object doInPackageSwitch1(EModelElement theEObject) {
        int classifierID = theEObject.eClass().getClassifierID();
        return this.doSwitch(classifierID, (EObject)theEObject);
    }

    protected void appendName(ENamedElement eNamedElement) {
        this.append(eNamedElement.getName());
    }

    protected void appendParameters(List<EParameter> parameters) {
        this.s.append("(");
        String prefix = "";
        for (EParameter eParameter : parameters) {
            this.s.append(prefix);
            this.appendType(eParameter.getEGenericType());
            if (this.fullSignature) {
                this.s.append(":");
                this.s.append(eParameter.getName());
            }
            prefix = ",";
        }
        this.s.append(")");
    }

    protected void appendParent(EObject eElement, String parentSeparator) {
        EObject parent;
        EObject eObject = parent = eElement != null ? eElement.eContainer() : null;
        if (parent instanceof EModelElement) {
            boolean wasFullSignature = this.fullSignature;
            this.fullSignature = false;
            this.appendElement((EModelElement)parent);
            this.fullSignature = wasFullSignature;
        } else if (parent instanceof EGenericType) {
            this.appendParent(parent, parentSeparator);
        }
        this.append(parentSeparator);
    }

    protected void appendType(EGenericType eGenericType) {
        ETypeParameter eTypeParameter = eGenericType.getETypeParameter();
        EClassifier eClassifier = eGenericType.getEClassifier();
        if (eClassifier != null) {
            this.appendParent((EObject)eClassifier, "!");
            this.append(eClassifier.getName());
            this.appendTypeArguments((List<EGenericType>)eGenericType.getETypeArguments(), (List<ETypeParameter>)eClassifier.getETypeParameters());
        } else if (eTypeParameter != null) {
            this.appendElement((EModelElement)eTypeParameter);
            assert (eGenericType.getETypeArguments().size() == 0);
        } else {
            EStructuralFeature eContainingFeature = eGenericType.eContainingFeature();
            if (this.s.length() == 0) {
                this.appendParent((EObject)eGenericType, "!");
                this.s.append("?");
            } else if (eContainingFeature == EcorePackage.Literals.EGENERIC_TYPE__ETYPE_ARGUMENTS) {
                EGenericType eContainer = (EGenericType)eGenericType.eContainer();
                List eTypeArguments = (List)eContainer.eGet(eContainingFeature);
                int index = eTypeArguments.indexOf(eGenericType);
                EClassifier unspecializedClassifier = eContainer.getEClassifier();
                this.appendElement((EModelElement)unspecializedClassifier);
                this.s.append("/");
                EList eTypeParameters = unspecializedClassifier.getETypeParameters();
                eTypeParameter = (ETypeParameter)eTypeParameters.get(index);
                this.appendName((ENamedElement)eTypeParameter);
                this.s.append("!");
                this.s.append("?");
                this.s.append(index);
            } else {
                this.s.append("?");
            }
            assert (eGenericType.getETypeArguments().size() == 0);
        }
    }

    protected void appendTypeArguments(List<EGenericType> eTypeArguments, List<ETypeParameter> eTypeParameters) {
        assert (eTypeArguments.size() == eTypeParameters.size());
        if (!eTypeArguments.isEmpty()) {
            this.s.append("[");
            String prefix = "";
            int i = 0;
            while (i < eTypeArguments.size()) {
                this.s.append(prefix);
                this.appendType(eTypeArguments.get(i));
                if (this.fullSignature) {
                    this.s.append(":");
                    this.appendTypeParameter(eTypeParameters.get(i));
                }
                prefix = ",";
                ++i;
            }
            this.s.append("]");
        }
    }

    protected void appendTypeParameter(ETypeParameter eTypeParameter) {
        if (this.emittedParameters == null) {
            this.emittedParameters = new ArrayList<ETypeParameter>();
        }
        this.emittedParameters.add(eTypeParameter);
        this.appendName((ENamedElement)eTypeParameter);
        if (this.fullSignature) {
            this.appendBounds((List<? extends EGenericType>)eTypeParameter.getEBounds());
        }
    }

    protected void appendTypeParameters(List<ETypeParameter> eTypeParameters) {
        if (!eTypeParameters.isEmpty()) {
            this.s.append("{");
            String prefix = "";
            for (ETypeParameter eTypeParameter : eTypeParameters) {
                this.s.append(prefix);
                this.appendTypeParameter(eTypeParameter);
                prefix = ",";
            }
            this.s.append("}");
        }
    }

    protected void appendTypes(List<EGenericType> eTypes) {
        String prefix = "";
        for (EGenericType eType : eTypes) {
            this.s.append(prefix);
            this.appendType(eType);
            prefix = ",";
        }
    }

    public Object caseEAnnotation(EAnnotation eElement) {
        this.appendParent((EObject)eElement, "!");
        this.s.append("'");
        this.append(eElement.getSource());
        this.s.append("'");
        Object container = eElement.eContainer().eGet(eElement.eContainingFeature());
        if (container instanceof List) {
            int index = 0;
            for (Object object : (List)container) {
                String source;
                if (object == eElement) break;
                if (!(object instanceof EAnnotation) || (source = ((EAnnotation)object).getSource()) == null || !source.equals(eElement.getSource())) continue;
                ++index;
            }
            if (index > 0) {
                this.s.append(index);
            }
        }
        return true;
    }

    public Object caseEClassifier(EClassifier eElement) {
        this.caseENamedElement((ENamedElement)eElement);
        this.appendTypeParameters((List<ETypeParameter>)eElement.getETypeParameters());
        return true;
    }

    public Object caseENamedElement(ENamedElement eElement) {
        this.appendParent((EObject)eElement, "!");
        this.appendName(eElement);
        return true;
    }

    public Object caseEOperation(EOperation eElement) {
        EList eGenericExceptions;
        this.caseENamedElement((ENamedElement)eElement);
        this.appendTypeParameters((List<ETypeParameter>)eElement.getETypeParameters());
        this.appendParameters((List<EParameter>)eElement.getEParameters());
        if (this.fullSignature && (eGenericExceptions = eElement.getEGenericExceptions()).size() > 0) {
            this.append(" throws ");
            this.appendTypes((List<EGenericType>)eGenericExceptions);
        }
        return true;
    }

    public Object caseEPackage(EPackage eElement) {
        String alias = AliasAdapter.getAlias((EObject)eElement);
        if (alias != null) {
            this.append(alias);
            return true;
        }
        return this.caseENamedElement((ENamedElement)eElement);
    }

    public Object caseETypeParameter(ETypeParameter eElement) {
        if (!this.hasEmitted(eElement)) {
            if (this.toString().length() < 1024) {
                this.appendParent((EObject)eElement, "?");
            } else {
                this.append("##");
            }
        }
        this.appendName((ENamedElement)eElement);
        return true;
    }

    protected boolean hasEmitted(ETypeParameter eTypeParameter) {
        return this.emittedParameters != null && this.emittedParameters.contains(eTypeParameter);
    }

    public String toString() {
        return this.s.toString();
    }
}

