/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.delegate;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.common.delegate.DelegateResourceSetAdapter;
import org.eclipse.ocl.common.internal.delegate.OCLDelegateException;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.SemanticException;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.delegate.AbstractDelegatedBehavior;
import org.eclipse.ocl.examples.pivot.delegate.DelegateDomain;
import org.eclipse.ocl.examples.pivot.delegate.ValidationDelegate;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2Pivot;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationBehavior
extends AbstractDelegatedBehavior<EClassifier, EValidator.ValidationDelegate.Registry, ValidationDelegate.Factory> {
    @NonNull
    public static final ValidationBehavior INSTANCE = new ValidationBehavior();
    @NonNull
    public static final String NAME = "validationDelegates";

    public Constraint getConstraint(@NonNull MetaModelManager metaModelManager, @NonNull EClassifier eClassifier, @NonNull String constraintName) throws OCLDelegateException {
        Constraint constraint;
        Resource ecoreMetaModel = (Resource)DomainUtil.nonNullEMF((Object)eClassifier.eResource());
        Ecore2Pivot ecore2Pivot = Ecore2Pivot.getAdapter(ecoreMetaModel, metaModelManager);
        Type type = ecore2Pivot.getCreated(Type.class, (EObject)eClassifier);
        if (type != null && (constraint = (Constraint)DomainUtil.getNamedElement(metaModelManager.getAllInvariants(type), (String)constraintName)) != null) {
            return constraint;
        }
        String message = NLS.bind((String)OCLMessages.MissingBodyForInvocationDelegate_ERROR_, (Object)type);
        throw new OCLDelegateException((Exception)new SemanticException(message));
    }

    @Override
    @Nullable
    public ValidationDelegate.Factory getDefaultFactory() {
        return (ValidationDelegate.Factory)ValidationDelegate.Factory.Registry.INSTANCE.getValidationDelegate(this.getName());
    }

    @Override
    @NonNull
    public EValidator.ValidationDelegate.Registry getDefaultRegistry() {
        return (EValidator.ValidationDelegate.Registry)DomainUtil.nonNullEMF((Object)ValidationDelegate.Factory.Registry.INSTANCE);
    }

    @Override
    @NonNull
    public EPackage getEPackage(@NonNull EClassifier eClassifier) {
        return (EPackage)DomainUtil.nonNullEMF((Object)eClassifier.getEPackage());
    }

    @Override
    @Nullable
    public ValidationDelegate.Factory getFactory(@NonNull DelegateDomain delegateDomain, @NonNull EClassifier eClassifier) {
        EValidator.ValidationDelegate.Registry registry = (EValidator.ValidationDelegate.Registry)DelegateResourceSetAdapter.getRegistry((EModelElement)eClassifier, EValidator.ValidationDelegate.Registry.class, (Object)this.getDefaultRegistry());
        if (registry == null) {
            return null;
        }
        String delegateURI = delegateDomain.getURI();
        EValidator.ValidationDelegate validationDelegate = registry.getValidationDelegate(delegateURI);
        return (ValidationDelegate.Factory)validationDelegate;
    }

    @Override
    @NonNull
    public Class<ValidationDelegate.Factory> getFactoryClass() {
        return ValidationDelegate.Factory.class;
    }

    @Override
    @NonNull
    public String getName() {
        return NAME;
    }

    @Override
    @NonNull
    public Class<ValidationDelegate.Factory.Registry> getRegistryClass() {
        return ValidationDelegate.Factory.Registry.class;
    }
}

