/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.attributes;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.scoping.AbstractAttribution;
import org.eclipse.ocl.examples.pivot.scoping.EnvironmentView;
import org.eclipse.ocl.examples.pivot.scoping.ScopeView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageAttribution
extends AbstractAttribution {
    public static final PackageAttribution INSTANCE = new PackageAttribution();

    @Override
    public ScopeView computeLookup(@NonNull EObject target, @NonNull EnvironmentView environmentView, @NonNull ScopeView scopeView) {
        Package targetPackage = (Package)target;
        MetaModelManager metaModelManager = environmentView.getMetaModelManager();
        HashSet<Package> allPackages = new HashSet<Package>();
        this.gatherAllPackages(metaModelManager, allPackages, targetPackage);
        for (Package aPackage : allPackages) {
            environmentView.addAllPackages(aPackage);
            environmentView.addAllTypes(aPackage);
        }
        return scopeView.getParent();
    }

    private void gatherAllPackages(@NonNull MetaModelManager metaModelManager, @NonNull Set<Package> allPackages, @NonNull Package targetPackage) {
        Package primaryPackage = metaModelManager.getPrimaryElement(targetPackage);
        if (allPackages.add(primaryPackage)) {
            for (DomainPackage domainPackage : metaModelManager.getPartialPackages(primaryPackage, false)) {
                if (!(domainPackage instanceof Package)) continue;
                for (Package importedPackage : ((Package)domainPackage).getImportedPackage()) {
                    this.gatherAllPackages(metaModelManager, allPackages, importedPackage);
                }
            }
        }
    }
}

