/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.BasicEnvironment;
import org.eclipse.ocl.examples.pivot.ProblemHandler;
import org.eclipse.ocl.examples.pivot.options.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBasicEnvironment<P extends BasicEnvironment>
implements BasicEnvironment {
    @NonNull
    private final Map<Option<?>, Object> options = new HashMap();
    @Nullable
    protected P parent;

    protected AbstractBasicEnvironment(P parent) {
        this.parent = parent;
    }

    @NonNull
    protected final Map<Option<?>, Object> basicGetOptions() {
        return this.options;
    }

    @Override
    @NonNull
    public Map<Option<?>, Object> clearOptions() {
        Map<Option<?>, Object> myOptions = this.options;
        HashMap result = new HashMap(myOptions);
        myOptions.clear();
        return result;
    }

    @Override
    public <T> T getAdapter(Class<T> adapterType) {
        if (adapterType.isInstance(this)) {
            return (T)this;
        }
        return null;
    }

    @Override
    public Map<Option<?>, Object> getOptions() {
        P parent2 = this.parent;
        HashMap result = parent2 != null ? new HashMap(parent2.getOptions()) : new HashMap();
        result.putAll(this.options);
        return result;
    }

    public final P getParent() {
        return this.parent;
    }

    @Override
    @Nullable
    public <T> T getValue(@NonNull Option<T> option) {
        Object result = this.getOptions().get(option);
        if (result == null) {
            P parent2 = this.parent;
            result = parent2 != null ? parent2.getValue(option) : option.getDefaultValue();
        }
        return (T)result;
    }

    @Override
    public boolean isEnabled(@NonNull Option<Boolean> option) {
        Boolean result = this.getValue(option);
        return result == null ? false : result;
    }

    public boolean notOK(@NonNull Option<ProblemHandler.Severity> option) {
        ProblemHandler.Severity sev = this.getValue(option);
        return sev != null && !sev.isOK();
    }

    @Override
    public <T> void putOptions(@NonNull Map<? extends Option<T>, ? extends T> newOptions) {
        Map<Option<?>, Object> myOptions = this.options;
        myOptions.clear();
        myOptions.putAll(newOptions);
    }

    @Override
    @Nullable
    public <T> T removeOption(@NonNull Option<T> option) {
        T result = this.getValue(option);
        this.options.remove(option);
        return result;
    }

    @Override
    @NonNull
    public <T> Map<Option<T>, T> removeOptions(@NonNull Collection<Option<T>> unwantedOptions) {
        HashMap<Option<T>, T> result = new HashMap<Option<T>, T>();
        Map<Option<?>, Object> myOptions = this.options;
        for (Option<T> next : unwantedOptions) {
            if (next == null) continue;
            result.put(next, this.getValue(next));
            myOptions.remove(next);
        }
        return result;
    }

    @Override
    public <T> void setOption(@NonNull Option<T> option, @Nullable T value) {
        this.options.put(option, value);
    }

    protected void setParent(P parent) {
        this.parent = parent;
    }
}

