/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.generation.writers;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.acceleo.engine.AcceleoEnginePlugin;
import org.eclipse.acceleo.engine.generation.writers.AbstractAcceleoWriter;
import org.eclipse.acceleo.engine.internal.evaluation.JMergeUtil;
import org.eclipse.emf.common.EMFPlugin;

public class AcceleoWorkspaceFileWriter
extends AbstractAcceleoWriter {
    private final String targetPath;
    private String selectedCharset;
    private boolean shouldMerge;

    public AcceleoWorkspaceFileWriter(File target, boolean appendMode, boolean merge) throws IOException {
        this(target, appendMode, merge, null);
    }

    public AcceleoWorkspaceFileWriter(File target, boolean appendMode, boolean merge, String charset) throws IOException {
        this.delegate = new StringWriter(1024);
        if (appendMode && target.exists() && target.canRead()) {
            this.delegate.append(this.readOldContent(target, charset));
            this.delegate.append(LINE_SEPARATOR);
        }
        this.targetPath = target.getPath();
        this.shouldMerge = !appendMode && merge;
        this.selectedCharset = charset;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    private String readOldContent(File target, String charset) throws IOException {
        BufferedReader reader = null;
        StringBuilder oldContent = new StringBuilder();
        try {
            if (charset == null) {
                reader = new BufferedReader(new FileReader(target));
            } else {
                FileInputStream fileInputStream = new FileInputStream(target);
                InputStreamReader fileReader = new InputStreamReader((InputStream)fileInputStream, charset);
                reader = new BufferedReader(fileReader);
            }
            char[] buf = new char[1024];
            int length = reader.read(buf);
            while (length > 0) {
                oldContent.append(buf, 0, length);
                length = reader.read(buf);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return oldContent.toString();
    }

    public void close() throws IOException {
        this.flush();
        Writer writer = null;
        try {
            if (this.selectedCharset == null) {
                writer = new BufferedWriter(new FileWriter(new File(this.targetPath)));
            } else {
                FileOutputStream fileOutputStream = new FileOutputStream(new File(this.targetPath));
                OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)fileOutputStream, this.selectedCharset);
                writer = new BufferedWriter(fileWriter);
            }
            if (!this.shouldMerge || !EMFPlugin.IS_ECLIPSE_RUNNING) {
                writer.append(this.toString());
            } else {
                try {
                    Class.forName("org.eclipse.emf.codegen.merge.java.JMerger");
                    String mergedContent = JMergeUtil.mergeFileContent(new File(this.targetPath), this.toString(), this.selectedCharset);
                    writer.append(mergedContent);
                }
                catch (ClassNotFoundException e) {
                    AcceleoEnginePlugin.log(e, true);
                }
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public boolean hasChanged() throws IOException {
        boolean hasChanged;
        block9: {
            hasChanged = false;
            File target = new File(this.targetPath);
            if (this.shouldMerge && EMFPlugin.IS_ECLIPSE_RUNNING) {
                try {
                    if (target.exists() && target.canRead()) {
                        Class.forName("org.eclipse.emf.codegen.merge.java.JMerger");
                        String mergedContent = JMergeUtil.mergeFileContent(target, this.toString(), this.selectedCharset);
                        String oldContent = this.readOldContent(target, this.selectedCharset);
                        if (!mergedContent.equals(oldContent)) {
                            hasChanged = true;
                        }
                        break block9;
                    }
                    hasChanged = true;
                }
                catch (ClassNotFoundException e) {
                    AcceleoEnginePlugin.log(e, true);
                }
            } else if (target.exists() && target.canRead()) {
                String oldContent = this.readOldContent(target, this.selectedCharset);
                String newContent = this.toString();
                if (!newContent.equals(oldContent)) {
                    hasChanged = true;
                }
            } else {
                hasChanged = true;
            }
        }
        return hasChanged;
    }
}

