/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.viewpoints.configuration;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusView;
import org.eclipse.papyrus.infra.viewpoints.configuration.SurrogateItemPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StereotypePropertyDescriptor
extends SurrogateItemPropertyDescriptor {
    private static final Collection<EObject> empty = new ArrayList<EObject>();

    public StereotypePropertyDescriptor(IItemPropertyDescriptor inner) {
        super(inner);
    }

    @Override
    public Collection<?> getChoiceOfValues(Object object) {
        EObject current = (EObject)object;
        while (current != null && !(current instanceof PapyrusView)) {
            current = current.eContainer();
        }
        if (current == null) {
            return empty;
        }
        PapyrusView conf = (PapyrusView)current;
        ArrayList<EClass> result = new ArrayList<EClass>();
        for (EPackage p : conf.getProfiles()) {
            for (EClassifier c : p.getEClassifiers()) {
                if (!(c instanceof EClass)) continue;
                result.add((EClass)c);
            }
        }
        return result;
    }

    @Override
    public IItemLabelProvider getLabelProvider(Object object) {
        return new IItemLabelProvider(){

            public String getText(Object object) {
                if (object instanceof EClass) {
                    return StereotypePropertyDescriptor.this.eClassToString((EClass)object);
                }
                if (object instanceof EList) {
                    EList list = (EList)object;
                    if (list.isEmpty()) {
                        return "";
                    }
                    StringBuilder builder = new StringBuilder("{");
                    int i = 0;
                    while (i != list.size()) {
                        if (i != 0) {
                            builder.append(", ");
                        }
                        builder.append(StereotypePropertyDescriptor.this.eClassToString((EClass)list.get(i)));
                        ++i;
                    }
                    builder.append("}");
                    return builder.toString();
                }
                return "";
            }

            public Object getImage(Object object) {
                return null;
            }
        };
    }

    private String eClassToString(EClass item) {
        return String.valueOf(item.getEPackage().getNsPrefix()) + "#" + item.getName();
    }
}

