/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.jdt.internal.corext.util.JavaElementResourceMapping;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;

public class MonitoringNewNameQueries
implements INewNameQueries {
    private INewNameQueries fDelegate;
    private ReorgExecutionLog fExecutionLog;

    public MonitoringNewNameQueries(INewNameQueries delegate, ReorgExecutionLog log) {
        this.fDelegate = delegate;
        this.fExecutionLog = log;
    }

    public INewNameQuery createNewCompilationUnitNameQuery(final ICompilationUnit cu, final String initialSuggestedName) {
        return new INewNameQuery(){

            public String getNewName() throws OperationCanceledException {
                String result = MonitoringNewNameQueries.this.fDelegate.createNewCompilationUnitNameQuery(cu, initialSuggestedName).getNewName();
                String newName = JavaModelUtil.getRenamedCUName(cu, result);
                MonitoringNewNameQueries.this.fExecutionLog.setNewName((Object)cu, newName);
                ResourceMapping mapping = JavaElementResourceMapping.create(cu);
                if (mapping != null) {
                    MonitoringNewNameQueries.this.fExecutionLog.setNewName((Object)mapping, newName);
                }
                return result;
            }
        };
    }

    public INewNameQuery createNewPackageFragmentRootNameQuery(final IPackageFragmentRoot root, final String initialSuggestedName) {
        return new INewNameQuery(){

            public String getNewName() throws OperationCanceledException {
                String result = MonitoringNewNameQueries.this.fDelegate.createNewPackageFragmentRootNameQuery(root, initialSuggestedName).getNewName();
                MonitoringNewNameQueries.this.fExecutionLog.setNewName((Object)root, result);
                ResourceMapping mapping = JavaElementResourceMapping.create(root);
                if (mapping != null) {
                    MonitoringNewNameQueries.this.fExecutionLog.setNewName((Object)mapping, result);
                }
                return result;
            }
        };
    }

    public INewNameQuery createNewPackageNameQuery(final IPackageFragment pack, final String initialSuggestedName) {
        return new INewNameQuery(){

            public String getNewName() throws OperationCanceledException {
                String result = MonitoringNewNameQueries.this.fDelegate.createNewPackageNameQuery(pack, initialSuggestedName).getNewName();
                MonitoringNewNameQueries.this.fExecutionLog.setNewName((Object)pack, result);
                ResourceMapping mapping = JavaElementResourceMapping.create(pack);
                if (mapping != null) {
                    int index = result.lastIndexOf(46);
                    String newFolderName = index == -1 ? result : result.substring(index + 1);
                    MonitoringNewNameQueries.this.fExecutionLog.setNewName((Object)mapping, newFolderName);
                }
                return result;
            }
        };
    }

    public INewNameQuery createNewResourceNameQuery(final IResource res, final String initialSuggestedName) {
        return new INewNameQuery(){

            public String getNewName() throws OperationCanceledException {
                String result = MonitoringNewNameQueries.this.fDelegate.createNewResourceNameQuery(res, initialSuggestedName).getNewName();
                MonitoringNewNameQueries.this.fExecutionLog.setNewName((Object)res, result);
                return result;
            }
        };
    }

    public INewNameQuery createNullQuery() {
        return this.fDelegate.createNullQuery();
    }

    public INewNameQuery createStaticQuery(String newName) {
        return this.fDelegate.createStaticQuery(newName);
    }
}

