/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.wizard;

import java.io.File;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.papyrus.infra.nattable.manager.ImportAxisInNattableManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.paste.PasteSeparator;
import org.eclipse.papyrus.infra.nattable.paste.TextDelimiter;
import org.eclipse.papyrus.infra.nattable.utils.CSVPasteHelper;
import org.eclipse.papyrus.infra.nattable.wizard.pages.ImportCSVConfigurationPage;
import org.eclipse.papyrus.infra.nattable.wizard.pages.ImportFilePage;
import org.eclipse.papyrus.infra.nattable.wizard.pages.ImportInvertedTableErrorPage;
import org.eclipse.papyrus.infra.nattable.wizard.pages.ImportTableErrorPage;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.util.FileUtil;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ImportTableWizard
extends Wizard
implements IImportWizard {
    private ImportFilePage importPage;
    private ImportCSVConfigurationPage csvConfigurationPage;
    private INattableModelManager manager;

    public ImportTableWizard() {
        this.setWindowTitle(Messages.ImportTableWizard_ImportTableFromFileInPapyrusModel);
        String pluginId = "org.eclipse.papyrus.infra.nattable";
        String path = "icons/importTablePapyrusWizban.png";
        ImageDescriptor desc = Activator.getDefault().getImageDescriptor(pluginId, path);
        this.setDefaultPageImageDescriptor(desc);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.manager = this.getNattableModelManager(workbench, selection);
    }

    public void addPages() {
        String pageTitle = Messages.ImportTableWizard_ImportTable;
        ImageDescriptor desc = null;
        if (this.manager != null) {
            if (this.manager.getTable().isInvertAxis()) {
                this.addPage((IWizardPage)new ImportInvertedTableErrorPage(Messages.ImportTableWizard_ImportTableError, pageTitle, desc));
            } else {
                this.importPage = new ImportFilePage(pageTitle, pageTitle, desc, this.manager);
                this.addPage((IWizardPage)this.importPage);
                this.csvConfigurationPage = new ImportCSVConfigurationPage(pageTitle, Messages.ImportTableWizard_ConfigureImport, desc, PasteSeparator.SEMICOLON, TextDelimiter.DOUBLE_QUOTE);
                this.addPage((IWizardPage)this.csvConfigurationPage);
            }
        } else {
            this.addPage((IWizardPage)new ImportTableErrorPage(Messages.ImportTableWizard_ImportTableError, pageTitle, desc));
        }
    }

    public boolean performFinish() {
        File file = FileUtil.getFile((String)this.importPage.getFilePath());
        CSVPasteHelper pasteHelper = new CSVPasteHelper(this.csvConfigurationPage.getSeparator(), this.csvConfigurationPage.getTextDelimiter(), ",");
        ImportAxisInNattableManager pasteManager = new ImportAxisInNattableManager(this.manager, pasteHelper, file, true);
        return pasteManager.doPaste();
    }

    private INattableModelManager getNattableModelManager(IWorkbench workbench, IStructuredSelection selection) {
        IEditorPart editorPart = workbench.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editorPart != null) {
            return (INattableModelManager)editorPart.getAdapter(INattableModelManager.class);
        }
        return null;
    }
}

