/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import java.io.Reader;
import org.eclipse.papyrus.infra.nattable.parsers.CSVParser;
import org.eclipse.papyrus.infra.nattable.paste.PasteSeparator;
import org.eclipse.papyrus.infra.nattable.paste.TextDelimiter;

public class CSVPasteHelper {
    public static final char DEFAULT_CLIPBOARD_COLUMN_SEPARATOR = PasteSeparator.TABULATION.getSeparator();
    public static final String DEFAULT_MULTI_VALUE_SEPARATOR = ",";
    public static final char DEFAULT_TEXT_MARKER = TextDelimiter.DOUBLE_QUOTE.getDelimiter();
    private final char textMarker;
    private final char cellSeparator;
    private final String multiValueSeparator;

    public CSVPasteHelper() {
        this(DEFAULT_CLIPBOARD_COLUMN_SEPARATOR, DEFAULT_TEXT_MARKER, DEFAULT_MULTI_VALUE_SEPARATOR);
    }

    public CSVPasteHelper(char cellSeparator, char textMarker, String multiValueSeparator) {
        this.cellSeparator = cellSeparator;
        this.textMarker = textMarker;
        this.multiValueSeparator = multiValueSeparator;
    }

    public CSVParser createParser(Reader reader) {
        return new CSVParser(reader, this.cellSeparator, this.textMarker);
    }

    public String getMultiValueSeparator() {
        return this.multiValueSeparator;
    }
}

