/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.sort;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;
import org.eclipse.papyrus.infra.nattable.comparator.RowComparator;
import org.eclipse.papyrus.infra.nattable.manager.axis.ICompositeAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.sort.IPapyrusSortModel;
import org.eclipse.papyrus.infra.tools.comparator.CompositeComparator;

public class ColumnSortModel
implements IPapyrusSortModel {
    private final List<Object> sortedColumns = new ArrayList<Object>();
    private final Map<Object, SortDirectionEnum> sortedColumnsAndDirection = new HashMap<Object, SortDirectionEnum>();
    private INattableModelManager tableManager;

    public ColumnSortModel(INattableModelManager tableManager) {
        this.tableManager = tableManager;
    }

    public List<Integer> getSortedColumnIndexes() {
        ArrayList<Integer> sortedColumnsIndex = new ArrayList<Integer>();
        for (Object current : this.sortedColumns) {
            sortedColumnsIndex.add(this.getColumnIndex(current));
        }
        return sortedColumnsIndex;
    }

    public boolean isColumnIndexSorted(int columnIndex) {
        return this.sortedColumns.contains(this.getObject(columnIndex));
    }

    public SortDirectionEnum getSortDirection(int columnIndex) {
        Object object = this.getObject(columnIndex);
        SortDirectionEnum direction = this.sortedColumnsAndDirection.get(object);
        if (direction == null) {
            direction = SortDirectionEnum.NONE;
        }
        return direction;
    }

    public int getSortOrder(int columnIndex) {
        Object obj = this.getObject(columnIndex);
        return this.sortedColumns.indexOf(obj);
    }

    public List<Comparator> getComparatorsForColumnIndex(int columnIndex) {
        RowComparator comp = new RowComparator(this.getObject(columnIndex), this.sortedColumnsAndDirection.get(this.getObject(columnIndex)), this.tableManager);
        return Collections.singletonList(comp);
    }

    public void sort(int columnIndex, SortDirectionEnum sortDirection, boolean accumulate) {
        Object columnElement = this.getObject(columnIndex);
        if (!accumulate) {
            this.clear();
        }
        this.sortedColumns.remove(columnElement);
        this.sortedColumnsAndDirection.remove(columnElement);
        if (sortDirection != SortDirectionEnum.NONE) {
            this.sortedColumnsAndDirection.put(columnElement, sortDirection);
            this.sortedColumns.add(0, columnElement);
        }
        ArrayList<RowComparator> comparators = new ArrayList<RowComparator>();
        for (Object current : this.sortedColumns) {
            RowComparator newOne = new RowComparator(current, this.sortedColumnsAndDirection.get(current), this.tableManager);
            comparators.add(newOne);
        }
        this.setAxisComparator();
    }

    protected void setAxisComparator() {
        Comparator<Object> comp = this.createComparator();
        ICompositeAxisManager manager = (ICompositeAxisManager)this.tableManager.getRowAxisManager();
        manager.setAxisComparator(comp);
    }

    protected final Comparator<Object> createComparator() {
        ArrayList<RowComparator> comparators = new ArrayList<RowComparator>();
        for (Object current : this.sortedColumns) {
            RowComparator newOne = new RowComparator(current, this.sortedColumnsAndDirection.get(current), this.tableManager);
            comparators.add(newOne);
        }
        CompositeComparator comp = comparators.isEmpty() ? null : new CompositeComparator(comparators);
        return comp;
    }

    public void clear() {
        this.sortedColumns.clear();
        this.sortedColumnsAndDirection.clear();
    }

    private Object getObject(int columnIndex) {
        return this.tableManager.getColumnElement(columnIndex);
    }

    private int getColumnIndex(Object object) {
        return this.tableManager.getColumnElementsList().indexOf(object);
    }

    @Override
    public void updateSort() {
        ListIterator<Object> iterator = this.sortedColumns.listIterator();
        while (iterator.hasNext()) {
            Object current = iterator.next();
            if (-1 != this.tableManager.getColumnElementsList().indexOf(current)) continue;
            iterator.remove();
            this.sortedColumnsAndDirection.remove(current);
            this.sortedColumns.remove(current);
        }
        this.setAxisComparator();
    }
}

