/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.provider;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.emf.providers.EMFLabelProvider;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.services.labelprovider.service.IFilteredLabelProvider;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.swt.graphics.Image;

public class TableLabelProvider
extends EMFLabelProvider
implements IFilteredLabelProvider {
    public String getText(Object table) {
        if (table instanceof IStructuredSelection) {
            return super.getText((IStructuredSelection)table);
        }
        EObject el = EMFHelper.getEObject((Object)table);
        if (el instanceof Table) {
            return ((Table)el).getName();
        }
        return "";
    }

    public Image getImage(Object table) {
        String iconPath;
        if (table instanceof IStructuredSelection) {
            return this.getImage((IStructuredSelection)table);
        }
        if ((table = EMFHelper.getEObject((Object)table)) instanceof Table && (iconPath = this.getIcon((Table)table)) != null) {
            return Activator.getDefault().getImage(iconPath);
        }
        return null;
    }

    protected String getIcon(Table table) {
        if (table == null || table.getTableConfiguration() == null || table.getTableConfiguration().getIconPath() == null) {
            return null;
        }
        return table.getTableConfiguration().getIconPath();
    }

    public boolean accept(Object object) {
        if (object instanceof IStructuredSelection) {
            return this.accept((IStructuredSelection)object);
        }
        return EMFHelper.getEObject((Object)object) instanceof Table;
    }

    protected boolean accept(IStructuredSelection selection) {
        for (Object current : selection.toList()) {
            if (this.accept(current)) continue;
            return false;
        }
        return true;
    }

    protected boolean hasCommonImage(Collection<?> objects) {
        String iconPath = null;
        for (Object current : objects) {
            if (!(current instanceof Table)) {
                return false;
            }
            String icon = this.getIcon((Table)current);
            if (icon == null && iconPath != null) {
                return false;
            }
            if (iconPath == null) {
                iconPath = icon;
                continue;
            }
            if (iconPath.equals(icon)) continue;
            return false;
        }
        return true;
    }

    protected Image getNonCommonIcon(Object commonObject) {
        return Activator.getDefault().getImage("org.eclipse.papyrus.infra.nattable", "/icons/table.gif");
    }
}

