/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.provider;

import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.ILabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.ObjectLabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.utils.LabelConfigurationManagementUtils;
import org.eclipse.papyrus.infra.nattable.utils.LabelProviderCellContextElementWrapper;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.services.labelprovider.service.IFilteredLabelProvider;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractNattableCellLabelProvider
implements IFilteredLabelProvider {
    public boolean accept(Object element) {
        return false;
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        return "";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    protected Object getRowObject(ILayerCell cell, IConfigRegistry registry) {
        int rowIndex = cell.getRowIndex();
        INattableModelManager provider = this.getAxisContentProvider(registry);
        return provider.getRowElement(rowIndex);
    }

    protected Object getColumnObject(ILayerCell cell, IConfigRegistry registry) {
        int columnIndex = cell.getColumnIndex();
        INattableModelManager provider = this.getAxisContentProvider(registry);
        return provider.getColumnElement(columnIndex);
    }

    protected INattableModelManager getAxisContentProvider(IConfigRegistry registry) {
        return (INattableModelManager)registry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
    }

    protected LabelProviderService getLabelProviderService(IConfigRegistry registry) {
        return (LabelProviderService)registry.getConfigAttribute(NattableConfigAttributes.LABEL_PROVIDER_SERVICE_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"label_provider_service_id"});
    }

    protected ILabelProviderConfiguration getLabelConfiguration(LabelProviderCellContextElementWrapper element) {
        ObjectLabelProviderConfiguration conf = null;
        IConfigRegistry configRegistry = element.getConfigRegistry();
        INattableModelManager manager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
        LabelStack labels = element.getConfigLabels();
        if (labels.hasLabel("COLUMN_HEADER")) {
            conf = LabelConfigurationManagementUtils.getUsedColumnObjectLabelConfiguration(manager.getTable());
        } else if (labels.hasLabel("ROW_HEADER")) {
            conf = LabelConfigurationManagementUtils.getUsedRowObjectLabelConfiguration(manager.getTable());
        }
        return conf;
    }
}

