/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.parsers;

import java.io.Reader;
import org.eclipse.papyrus.infra.nattable.parsers.RewindableTextStream;

public class CSVLexer {
    public static final int TOKEN_ERROR = -1;
    public static final int TOKEN_VALUE = 0;
    public static final int TOKEN_SEPARATOR = 1;
    public static final int TOKEN_NEW_ROW = 2;
    public static final int TOKEN_EOF = 3;
    private static final int BUFFER_SIZE = 1024;
    private RewindableTextStream input;
    private char separator;
    private char textMarker;
    private char[] builder;
    private int lastTokenType;
    private String lastTokenValue;

    public CSVLexer(Reader input, char valueSeparator, char textMarker) {
        this.input = new RewindableTextStream(input);
        this.separator = valueSeparator;
        this.textMarker = textMarker;
        this.builder = new char[1024];
        this.lastTokenType = -1;
        this.lastTokenValue = null;
    }

    public int getTokenType() {
        return this.lastTokenType;
    }

    public String getTokenValue() {
        return this.lastTokenValue;
    }

    /*
     * Unable to fully structure code
     */
    public String next() {
        c = this.input.read();
        if (!this.input.isAtEnd()) ** GOTO lbl7
        return this.getTokenEOF();
lbl-1000:
        // 1 sources

        {
            c = this.input.read();
            if (!this.input.isAtEnd()) continue;
            return this.getTokenEOF();
lbl7:
            // 2 sources

            ** while (this.isWhitespace((char)c))
        }
lbl8:
        // 1 sources

        if (c == this.separator) {
            return this.getTokenSeparator();
        }
        if (c == this.textMarker) {
            return this.onTextMarkerChar();
        }
        if (c == '\r' || c == '\n') {
            return this.onLineEndingChar(c);
        }
        length = 1;
        this.builder[0] = c;
        while (true) {
            block6: {
                c = this.input.read();
                if (this.input.isAtEnd()) ** GOTO lbl28
                if (c != this.separator && c != '\r' && c != '\n') break block6;
                this.input.rewind(1);
                if (true) ** GOTO lbl28
            }
            this.builder[length] = c;
            ++length;
        }
        do {
            --length;
lbl28:
            // 3 sources

        } while (length > 0 && this.isWhitespace(this.builder[length - 1]));
        return this.getTokenValue(length);
    }

    private boolean isWhitespace(char c) {
        if (c == this.separator || c == this.textMarker || c == '\n' || c == '\r') {
            return false;
        }
        return Character.isWhitespace(c);
    }

    private String onLineEndingChar(char c) {
        if (c == '\n') {
            return this.getTokenNewRow();
        }
        char n = this.input.read();
        if (this.input.isAtEnd()) {
            return this.getTokenNewRow();
        }
        if (n != '\n') {
            this.input.rewind(1);
        }
        return this.getTokenNewRow();
    }

    private String onTextMarkerChar() {
        int length = 0;
        while (true) {
            char c = this.input.read();
            if (this.input.isAtEnd()) {
                return this.getTokenError();
            }
            if (c != this.textMarker) {
                this.builder[length] = c;
                ++length;
                continue;
            }
            c = this.input.read();
            if (c != this.textMarker) break;
            this.builder[length] = c;
            ++length;
        }
        if (!this.input.isAtEnd()) {
            this.input.rewind(1);
        }
        return this.getTokenValue(length);
    }

    private String getTokenError() {
        this.lastTokenType = -1;
        this.lastTokenValue = null;
        return null;
    }

    private String getTokenEOF() {
        this.lastTokenType = 3;
        this.lastTokenValue = null;
        return null;
    }

    private String getTokenSeparator() {
        this.lastTokenType = 1;
        this.lastTokenValue = null;
        return null;
    }

    private String getTokenNewRow() {
        this.lastTokenType = 2;
        this.lastTokenValue = null;
        return null;
    }

    private String getTokenValue(int length) {
        this.lastTokenType = 0;
        this.lastTokenValue = new String(this.builder, 0, length);
        return this.lastTokenValue;
    }

    public long getReadCharacters() {
        return this.input.getReadCharacters();
    }
}

