/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.manager.cell;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.manager.cell.ICellManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.tools.converter.AbstractStringValueConverter;

public final class CellManagerFactory {
    private static final String CLASS_MANAGER = "manager";
    private static final String ORDER = "order";
    private static final String EXTENSION_ID = "org.eclipse.papyrus.infra.nattable.cellmanager";
    public static final String CELL_MANAGER_NOT_FOUND = Messages.CellManagerFactory_CellManagerNotFound;
    private final Map<Integer, ICellManager> managersMap = new TreeMap<Integer, ICellManager>();
    public static final CellManagerFactory INSTANCE = new CellManagerFactory();

    private CellManagerFactory() {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            Integer order = new Integer(iConfigurationElement.getAttribute(ORDER));
            try {
                ICellManager solver = (ICellManager)iConfigurationElement.createExecutableExtension(CLASS_MANAGER);
                this.managersMap.put(order, solver);
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
            ++n2;
        }
    }

    public Object getCrossValue(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        ICellManager cellManager = this.getCellManager(columnElement, rowElement);
        if (cellManager != null) {
            return cellManager.getValue(columnElement, rowElement, tableManager);
        }
        return CELL_MANAGER_NOT_FOUND;
    }

    private ICellManager getCellManager(Object columnElement, Object rowElement) {
        for (Integer integer : this.managersMap.keySet()) {
            ICellManager current = this.managersMap.get(integer);
            if (!current.handles(columnElement, rowElement)) continue;
            return current;
        }
        return null;
    }

    public boolean isCellEditable(Object columnElement, Object rowElement) {
        ICellManager cellManager = this.getCellManager(columnElement, rowElement);
        if (cellManager != null) {
            return cellManager.isCellEditable(columnElement, rowElement);
        }
        return false;
    }

    public void setCellValue(TransactionalEditingDomain domain, Object columnElement, Object rowElement, Object newValue, INattableModelManager tableManager) {
        ICellManager cellManager = this.getCellManager(columnElement, rowElement);
        if (cellManager == null) {
            throw new UnsupportedOperationException(CELL_MANAGER_NOT_FOUND);
        }
        cellManager.setValue(domain, columnElement, rowElement, newValue, tableManager);
    }

    public Command getSetStringValueCommand(TransactionalEditingDomain editingDomain, Object columnElement, Object rowElement, String valueAsString, AbstractStringValueConverter stringResolvers, INattableModelManager tableManager) {
        ICellManager cellManager = this.getCellManager(columnElement, rowElement);
        if (cellManager != null) {
            return cellManager.getSetStringValueCommand(editingDomain, columnElement, rowElement, valueAsString, stringResolvers, tableManager);
        }
        return UnexecutableCommand.INSTANCE;
    }

    public AbstractStringValueConverter getOrCreateStringValueConverterClass(Object columnElement, Object rowElement, INattableModelManager tableManager, Map<Class<? extends AbstractStringValueConverter>, AbstractStringValueConverter> existingConverters, String multiValueSeparator) {
        ICellManager cellManager = this.getCellManager(columnElement, rowElement);
        if (cellManager != null) {
            return cellManager.getOrCreateStringValueConverterClass(tableManager, existingConverters, multiValueSeparator);
        }
        return null;
    }

    public void setStringValue(Object columnElement, Object rowElement, String valueAsString, AbstractStringValueConverter valueConverter, INattableModelManager tableManager, Map<?, ?> sharedMap) {
        ICellManager cellManager = this.getCellManager(columnElement, rowElement);
        if (cellManager == null) {
            throw new UnsupportedOperationException(CELL_MANAGER_NOT_FOUND);
        }
        cellManager.setStringValue(columnElement, rowElement, valueAsString, valueConverter, tableManager, sharedMap);
    }

    public boolean isCellEditable(Object columnElement, Object rowElement, Map<?, ?> sharedMap) {
        ICellManager cellManager = this.getCellManager(columnElement, rowElement);
        if (cellManager != null) {
            return cellManager.isCellEditable(columnElement, rowElement, sharedMap);
        }
        return false;
    }

    public Command getSetCellValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, Object newValue, INattableModelManager tableManager) {
        ICellManager cellManager = this.getCellManager(columnElement, rowElement);
        if (cellManager != null) {
            return cellManager.getSetValueCommand(domain, columnElement, rowElement, newValue, tableManager);
        }
        return UnexecutableCommand.INSTANCE;
    }
}

