/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.handler;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.handler.AbstractTableHandler;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.widgets.editors.TwoInputDialog;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractSaveCurrentAxisProvidersHandler
extends AbstractTableHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        AbstractAxisProvider currentAxisProvider = this.getAxisProvider();
        EList<AbstractAxisProvider> axisProvidersHistory = this.getAxisProviderHistory();
        EReference eReference = this.getAxisProviderHistoryEReference();
        return this.saveAxisProviderConfig(this.getCurrentNattableModelManager(), currentAxisProvider, axisProvidersHistory, eReference);
    }

    public Object saveAxisProviderConfig(INattableModelManager currentNattableModelManager, AbstractAxisProvider axisProvider, EList<AbstractAxisProvider> axisProvidersHistory, EReference axisProvidersHistoryEReference) {
        AbstractAxisProvider copy = (AbstractAxisProvider)EcoreUtil.copy((EObject)axisProvider);
        String name = axisProvider.getName();
        String description = axisProvider.getDescription();
        final ArrayList<String> existingProviderNames = new ArrayList<String>();
        for (AbstractAxisProvider abstractAxisProvider : axisProvidersHistory) {
            existingProviderNames.add(abstractAxisProvider.getName());
        }
        TwoInputDialog dialog = new TwoInputDialog(Display.getCurrent().getActiveShell(), Messages.AbstractSaveCurrentAxisProvidersHandler_0, Messages.AbstractSaveCurrentAxisProvidersHandler_1, Messages.AbstractSaveCurrentAxisProvidersHandler_2, name, description, new IInputValidator(){

            public String isValid(String newText) {
                if (newText == null || newText.equals("")) {
                    return Messages.AbstractSaveCurrentAxisProvidersHandler_4;
                }
                if (existingProviderNames.contains(newText)) {
                    return Messages.AbstractSaveCurrentAxisProvidersHandler_5;
                }
                return null;
            }
        });
        if (dialog.open() == 0) {
            name = dialog.getValue();
            description = dialog.getValue_2();
            copy.setName(name);
            copy.setDescription(description);
            ArrayList<AbstractAxisProvider> historyCopy = new ArrayList<AbstractAxisProvider>((Collection<AbstractAxisProvider>)axisProvidersHistory);
            historyCopy.add(copy);
            CompositeCommand cmd = new CompositeCommand("SaveCurrentAxisProvidersHandler");
            SetRequest request = new SetRequest(this.getTableEditingDomain(), (EObject)currentNattableModelManager.getTable(), (EStructuralFeature)axisProvidersHistoryEReference, historyCopy);
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)currentNattableModelManager.getTable());
            cmd.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)request));
            this.getTableEditingDomain().getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)cmd));
            return copy;
        }
        return null;
    }

    public abstract AbstractAxisProvider getAxisProvider();

    public abstract EList<AbstractAxisProvider> getAxisProviderHistory();

    public abstract EReference getAxisProviderHistoryEReference();
}

