/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.comparator;

import java.text.Collator;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;
import org.eclipse.papyrus.infra.nattable.comparator.AbstractAxisComparator;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.utils.LabelProviderCellContextElementWrapper;

public class RowComparator
extends AbstractAxisComparator {
    public RowComparator(Object selectedColumn, SortDirectionEnum direction, INattableModelManager tableManager) {
        super(selectedColumn, direction, tableManager);
    }

    @Override
    public int compare(Object o1, Object o2) {
        int index_01 = this.tableManager.getRowElementsList().indexOf(o1);
        int index_02 = this.tableManager.getRowElementsList().indexOf(o2);
        int columnIndex = this.tableManager.getColumnElementsList().indexOf(this.selectedColumn);
        if (columnIndex == -1) {
            return 0;
        }
        ILayerCell cell_O1 = this.stack.getSelectionLayer().getCellByPosition(columnIndex, index_01);
        ILayerCell cell_O2 = this.stack.getSelectionLayer().getCellByPosition(columnIndex, index_02);
        LabelProviderCellContextElementWrapper wrapper1 = new LabelProviderCellContextElementWrapper(cell_O1, this.configRegistry);
        LabelProviderCellContextElementWrapper wrapper2 = new LabelProviderCellContextElementWrapper(cell_O2, this.configRegistry);
        String txt1 = this.serv.getLabelProvider("org.eclipse.papyrus.infra.nattable.full.labelprovider").getText((Object)wrapper1);
        String txt2 = this.serv.getLabelProvider("org.eclipse.papyrus.infra.nattable.full.labelprovider").getText((Object)wrapper2);
        int res = this.direction == SortDirectionEnum.DESC ? Collator.getInstance().compare(txt2, txt1) : Collator.getInstance().compare(txt1, txt2);
        return res;
    }
}

