/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.command;

import java.util.ArrayList;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattablePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AbstractHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.IAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.LocalTableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.NattableaxisconfigurationFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.NattableaxisconfigurationPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.ILabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.utils.HeaderAxisConfigurationManagementUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableEditingDomainUtils;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;

public class TableCommands {
    private TableCommands() {
    }

    public static ICommand getSetRowHeaderConfigurationValueCommand(Table table, EStructuralFeature feature, Object newValue) {
        ICommand cmd;
        IElementEditService provider;
        SetRequest request;
        TransactionalEditingDomain domain = TableEditingDomainUtils.getTableEditingDomain(table);
        CompositeCommand compositeCommand = new CompositeCommand("SetRowHeaderConfigurationCommand");
        AbstractHeaderAxisConfiguration elementToEdit = HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisUsedInTable(table);
        if (elementToEdit instanceof TableHeaderAxisConfiguration) {
            elementToEdit = HeaderAxisConfigurationManagementUtils.transformToLocalHeaderConfiguration((TableHeaderAxisConfiguration)elementToEdit);
            request = null;
            request = !table.isInvertAxis() ? new SetRequest(domain, (EObject)table, (EStructuralFeature)NattablePackage.eINSTANCE.getTable_LocalRowHeaderAxisConfiguration(), (Object)elementToEdit) : new SetRequest(domain, (EObject)table, (EStructuralFeature)NattablePackage.eINSTANCE.getTable_LocalColumnHeaderAxisConfiguration(), (Object)elementToEdit);
            provider = ElementEditServiceUtils.getCommandProvider((Object)table);
            cmd = provider.getEditCommand((IEditCommandRequest)request);
            compositeCommand.add((IUndoableOperation)cmd);
        }
        request = new SetRequest(domain, (EObject)elementToEdit, feature, newValue);
        provider = ElementEditServiceUtils.getCommandProvider((Object)elementToEdit);
        cmd = provider.getEditCommand((IEditCommandRequest)request);
        compositeCommand.add((IUndoableOperation)cmd);
        return compositeCommand;
    }

    public static ICommand getSetColumnHeaderConfigurationValueCommand(Table table, EStructuralFeature feature, Object newValue) {
        ICommand cmd;
        IElementEditService provider;
        SetRequest request;
        TransactionalEditingDomain domain = TableEditingDomainUtils.getTableEditingDomain(table);
        CompositeCommand compositeCommand = new CompositeCommand("SetColumnHeaderConfigurationCommand");
        AbstractHeaderAxisConfiguration elementToEdit = HeaderAxisConfigurationManagementUtils.getColumnAbstractHeaderAxisUsedInTable(table);
        if (elementToEdit instanceof TableHeaderAxisConfiguration) {
            elementToEdit = HeaderAxisConfigurationManagementUtils.transformToLocalHeaderConfiguration((TableHeaderAxisConfiguration)elementToEdit);
            request = null;
            request = table.isInvertAxis() ? new SetRequest(domain, (EObject)table, (EStructuralFeature)NattablePackage.eINSTANCE.getTable_LocalRowHeaderAxisConfiguration(), (Object)elementToEdit) : new SetRequest(domain, (EObject)table, (EStructuralFeature)NattablePackage.eINSTANCE.getTable_LocalColumnHeaderAxisConfiguration(), (Object)elementToEdit);
            provider = ElementEditServiceUtils.getCommandProvider((Object)table);
            cmd = provider.getEditCommand((IEditCommandRequest)request);
            compositeCommand.add((IUndoableOperation)cmd);
        }
        request = new SetRequest(domain, (EObject)elementToEdit, feature, newValue);
        provider = ElementEditServiceUtils.getCommandProvider((Object)elementToEdit);
        cmd = provider.getEditCommand((IEditCommandRequest)request);
        compositeCommand.add((IUndoableOperation)cmd);
        return compositeCommand;
    }

    public static final ICommand getSetColumnLabelConfigurationValueCommand(Table table, ILabelProviderConfiguration usedLabelConfiguration, EStructuralFeature editedFeature, Object newValue) {
        ILabelProviderConfiguration editedLabelConf;
        CompositeCommand cmd = new CompositeCommand("ChangeColumnLabelConfigurationValueCommand");
        TransactionalEditingDomain domain = TableEditingDomainUtils.getTableEditingDomain(table);
        if (usedLabelConfiguration.eContainer() instanceof TableHeaderAxisConfiguration) {
            editedLabelConf = (ILabelProviderConfiguration)EcoreUtil.copy((EObject)usedLabelConfiguration);
            cmd.add((IUndoableOperation)TableCommands.getRegisterLocalColumnLabelConfigurationCommand(table, usedLabelConfiguration, editedLabelConf));
        } else {
            editedLabelConf = usedLabelConfiguration;
        }
        SetRequest request = new SetRequest(domain, (EObject)editedLabelConf, editedFeature, newValue);
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)editedLabelConf);
        cmd.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)request));
        return cmd;
    }

    public static final ICommand getSetRowLabelConfigurationValueCommand(Table table, ILabelProviderConfiguration usedLabelConfiguration, EStructuralFeature editedFeature, Object newValue) {
        ILabelProviderConfiguration editedLabelConf;
        CompositeCommand cmd = new CompositeCommand("ChangeRowLabelConfigurationValueCommand");
        TransactionalEditingDomain domain = TableEditingDomainUtils.getTableEditingDomain(table);
        if (usedLabelConfiguration.eContainer() instanceof TableHeaderAxisConfiguration) {
            editedLabelConf = (ILabelProviderConfiguration)EcoreUtil.copy((EObject)usedLabelConfiguration);
            cmd.add((IUndoableOperation)TableCommands.getRegisterLocalRowLabelConfigurationCommand(table, usedLabelConfiguration, editedLabelConf));
        } else {
            editedLabelConf = usedLabelConfiguration;
        }
        SetRequest request = new SetRequest(domain, (EObject)editedLabelConf, editedFeature, newValue);
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)editedLabelConf);
        cmd.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)request));
        return cmd;
    }

    private static final ICommand getRegisterLocalColumnLabelConfigurationCommand(Table table, ILabelProviderConfiguration tableLabelConfiguration, ILabelProviderConfiguration localTableLabelConfiguration) {
        AbstractHeaderAxisConfiguration abstractHeaderAxisUsedInTable = HeaderAxisConfigurationManagementUtils.getColumnAbstractHeaderAxisUsedInTable(table);
        EReference axisConfigurationFeature = NattablePackage.eINSTANCE.getTable_LocalColumnHeaderAxisConfiguration();
        if (!table.isInvertAxis()) {
            axisConfigurationFeature = NattablePackage.eINSTANCE.getTable_LocalRowHeaderAxisConfiguration();
        }
        TableHeaderAxisConfiguration headerAxisConfig = (TableHeaderAxisConfiguration)HeaderAxisConfigurationManagementUtils.getColumnAbstractHeaderAxisInTableConfiguration(table);
        return TableCommands.getRegisterLocalLabelConfigurationCommand("ChangeColumnHeaderLabelConfigurationCommand", table, abstractHeaderAxisUsedInTable, headerAxisConfig, (EStructuralFeature)axisConfigurationFeature, localTableLabelConfiguration, tableLabelConfiguration);
    }

    private static final ICommand getRegisterLocalRowLabelConfigurationCommand(Table table, ILabelProviderConfiguration tableLabelConfiguration, ILabelProviderConfiguration localTableLabelConfiguration) {
        AbstractHeaderAxisConfiguration abstractHeaderAxisUsedInTable = HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisUsedInTable(table);
        EReference axisConfigurationFeature = NattablePackage.eINSTANCE.getTable_LocalColumnHeaderAxisConfiguration();
        if (table.isInvertAxis()) {
            axisConfigurationFeature = NattablePackage.eINSTANCE.getTable_LocalRowHeaderAxisConfiguration();
        }
        TableHeaderAxisConfiguration headerAxisConfig = (TableHeaderAxisConfiguration)HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisInTableConfiguration(table);
        return TableCommands.getRegisterLocalLabelConfigurationCommand("ChangeRowHeaderLabelConfigurationCommand", table, abstractHeaderAxisUsedInTable, headerAxisConfig, (EStructuralFeature)axisConfigurationFeature, localTableLabelConfiguration, tableLabelConfiguration);
    }

    private static final ICommand getRegisterLocalLabelConfigurationCommand(String commandName, Table table, AbstractHeaderAxisConfiguration headerAxisConfigurationUsedInTable, TableHeaderAxisConfiguration tableHeaderAxisConfiguration, EStructuralFeature axisConfigurationFeature, ILabelProviderConfiguration localTableLabelConfiguration, ILabelProviderConfiguration tableLabelConfiguration) {
        IElementEditService provider;
        SetRequest request;
        TransactionalEditingDomain domain = TableEditingDomainUtils.getTableEditingDomain(table);
        CompositeCommand cmd = new CompositeCommand(commandName);
        LocalTableHeaderAxisConfiguration localConfig = null;
        if (headerAxisConfigurationUsedInTable instanceof LocalTableHeaderAxisConfiguration) {
            localConfig = (LocalTableHeaderAxisConfiguration)headerAxisConfigurationUsedInTable;
        } else if (headerAxisConfigurationUsedInTable instanceof TableHeaderAxisConfiguration) {
            localConfig = HeaderAxisConfigurationManagementUtils.transformToLocalHeaderConfiguration((TableHeaderAxisConfiguration)headerAxisConfigurationUsedInTable);
            request = new SetRequest(domain, (EObject)table, axisConfigurationFeature, (Object)headerAxisConfigurationUsedInTable);
            provider = ElementEditServiceUtils.getCommandProvider((Object)table);
            cmd.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)request));
        }
        request = new SetRequest(domain, (EObject)headerAxisConfigurationUsedInTable, (EStructuralFeature)NattableaxisconfigurationPackage.eINSTANCE.getAbstractHeaderAxisConfiguration_OwnedLabelConfigurations(), (Object)localTableLabelConfiguration);
        provider = ElementEditServiceUtils.getCommandProvider((Object)headerAxisConfigurationUsedInTable);
        cmd.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)request));
        ArrayList<AxisManagerConfiguration> axisManagerConfiguration = new ArrayList<AxisManagerConfiguration>();
        for (AxisManagerRepresentation axisManagerRepresentation : tableHeaderAxisConfiguration.getAxisManagers()) {
            if (axisManagerRepresentation.getHeaderLabelConfiguration() != tableLabelConfiguration) continue;
            AxisManagerConfiguration currentConf = null;
            for (AxisManagerConfiguration axisConf : localConfig.getAxisManagerConfigurations()) {
                if (axisConf.getAxisManager() != axisManagerRepresentation) continue;
                currentConf = axisConf;
            }
            if (currentConf == null) {
                currentConf = NattableaxisconfigurationFactory.eINSTANCE.createAxisManagerConfiguration();
                currentConf.setAxisManager(axisManagerRepresentation);
                SetRequest request2 = new SetRequest(domain, (EObject)localConfig, (EStructuralFeature)NattableaxisconfigurationPackage.eINSTANCE.getLocalTableHeaderAxisConfiguration_AxisManagerConfigurations(), (Object)currentConf);
                IElementEditService provider2 = ElementEditServiceUtils.getCommandProvider((Object)localConfig);
                cmd.add((IUndoableOperation)provider2.getEditCommand((IEditCommandRequest)request2));
            }
            axisManagerConfiguration.add(currentConf);
        }
        for (AxisManagerConfiguration axisManagerConfiguration2 : axisManagerConfiguration) {
            SetRequest request2 = new SetRequest(domain, (EObject)axisManagerConfiguration2, (EStructuralFeature)NattableaxisconfigurationPackage.eINSTANCE.getAxisManagerConfiguration_LocalHeaderLabelConfiguration(), (Object)localTableLabelConfiguration);
            IElementEditService provider2 = ElementEditServiceUtils.getCommandProvider((Object)axisManagerConfiguration2);
            cmd.add((IUndoableOperation)provider2.getEditCommand((IEditCommandRequest)request2));
        }
        return cmd;
    }

    private static final ICommand getRegisterLocalHeaderAxisConfigurationCommand(Table table, LocalTableHeaderAxisConfiguration localHeaderAxisConfiguration, boolean workOnColumn) {
        TransactionalEditingDomain domain = TableEditingDomainUtils.getTableEditingDomain(table);
        EReference feature = TableCommands.registerOnColumn(table, workOnColumn) ? NattablePackage.eINSTANCE.getTable_LocalColumnHeaderAxisConfiguration() : NattablePackage.eINSTANCE.getTable_LocalRowHeaderAxisConfiguration();
        SetRequest request = new SetRequest(domain, (EObject)table, (EStructuralFeature)feature, (Object)localHeaderAxisConfiguration);
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)table);
        return provider.getEditCommand((IEditCommandRequest)request);
    }

    private static final ICommand getAddIAxisConfigurationToLocalTableHeaderAxisConfiguration(Table table, IAxisConfiguration configurationToAdd, boolean onColumn) {
        CompositeCommand compositeCommand = new CompositeCommand("Add IAxis Configuration to table header");
        TransactionalEditingDomain domain = TableEditingDomainUtils.getTableEditingDomain(table);
        AbstractHeaderAxisConfiguration headerAxisConfiguration = null;
        headerAxisConfiguration = TableCommands.registerOnColumn(table, onColumn) ? HeaderAxisConfigurationManagementUtils.getColumnAbstractHeaderAxisInTable(table) : HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisInTable(table);
        if (headerAxisConfiguration == null) {
            EReference feature;
            TableHeaderAxisConfiguration tableHeaderAxisConfiguration;
            if (TableCommands.registerOnColumn(table, onColumn)) {
                tableHeaderAxisConfiguration = (TableHeaderAxisConfiguration)HeaderAxisConfigurationManagementUtils.getColumnAbstractHeaderAxisInTableConfiguration(table);
                feature = NattablePackage.eINSTANCE.getTable_LocalColumnHeaderAxisConfiguration();
            } else {
                tableHeaderAxisConfiguration = (TableHeaderAxisConfiguration)HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisInTableConfiguration(table);
                feature = NattablePackage.eINSTANCE.getTable_LocalRowHeaderAxisConfiguration();
            }
            headerAxisConfiguration = HeaderAxisConfigurationManagementUtils.transformToLocalHeaderConfiguration(tableHeaderAxisConfiguration);
            SetRequest request = new SetRequest(domain, (EObject)table, (EStructuralFeature)feature, (Object)headerAxisConfiguration);
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)table);
            compositeCommand.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)request));
        }
        SetRequest request = new SetRequest(domain, (EObject)headerAxisConfiguration, (EStructuralFeature)NattableaxisconfigurationPackage.eINSTANCE.getAbstractHeaderAxisConfiguration_OwnedAxisConfigurations(), (Object)configurationToAdd);
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)headerAxisConfiguration);
        compositeCommand.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)request));
        return compositeCommand;
    }

    private static final boolean registerOnColumn(Table table, boolean workOnColumn) {
        return workOnColumn || !workOnColumn && table.isInvertAxis();
    }

    public static ICommand getSetIAxisConfigurationValueCommand(Table table, IAxisConfiguration editedConfiguration, EStructuralFeature managedFeature, Object value, boolean onColumn) {
        CompositeCommand compositeCommand = new CompositeCommand("Set IAxis Value Command");
        TransactionalEditingDomain domain = TableEditingDomainUtils.getTableEditingDomain(table);
        EObject parent = editedConfiguration.eContainer();
        IAxisConfiguration realEditedObject = editedConfiguration;
        if (parent == null) {
            compositeCommand.add((IUndoableOperation)TableCommands.getAddIAxisConfigurationToLocalTableHeaderAxisConfiguration(table, editedConfiguration, onColumn));
        } else if (parent instanceof TableHeaderAxisConfiguration) {
            realEditedObject = (IAxisConfiguration)EcoreUtil.copy((EObject)editedConfiguration);
            compositeCommand.add((IUndoableOperation)TableCommands.getAddIAxisConfigurationToLocalTableHeaderAxisConfiguration(table, realEditedObject, onColumn));
        }
        SetRequest request = new SetRequest(domain, (EObject)realEditedObject, managedFeature, value);
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)realEditedObject);
        compositeCommand.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)request));
        return compositeCommand;
    }
}

